/*
 * Decompiled with CFR 0.152.
 */
package tech.yaog.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import tech.yaog.widgets.FontManager;
import tech.yaog.widgets.fontabletextview.R;

public class FontableTextView
extends AppCompatTextView {
    private String font;

    public FontableTextView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public FontableTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public FontableTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    private void init(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FontableTextView, defStyleAttr, defStyleRes);
        String fontPath = typedArray.getString(R.styleable.FontableTextView_custom_font);
        if (fontPath != null) {
            this.setFont(fontPath);
        }
        typedArray.recycle();
    }

    public void setFont(String customFont) {
        if (!(customFont == null || this.font != null && this.font.equals(customFont))) {
            try {
                Typeface typeFace = FontManager.getFont(this.getContext(), customFont);
                this.setTypeface(typeFace);
                this.font = customFont;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

