/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.asn1;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\f\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rJ#\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\b\b\u0002\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Ltech/relaycorp/relaynet/wrappers/asn1/ASN1Utils;", "", "()V", "BER_DATETIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getBER_DATETIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "derEncodeUTCDate", "Lorg/bouncycastle/asn1/DERGeneralizedTime;", "date", "Ljava/time/ZonedDateTime;", "deserializeHeterogeneousSequence", "", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "serialization", "", "([B)[Lorg/bouncycastle/asn1/ASN1TaggedObject;", "deserializeHomogeneousSequence", "T", "Lorg/bouncycastle/asn1/ASN1Encodable;", "([B)[Lorg/bouncycastle/asn1/ASN1Encodable;", "getOID", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "oidSerialized", "getOctetString", "Lorg/bouncycastle/asn1/ASN1OctetString;", "octetString", "getVisibleString", "Lorg/bouncycastle/asn1/DERVisibleString;", "visibleString", "serializeSequence", "items", "explicitTagging", "", "([Lorg/bouncycastle/asn1/ASN1Encodable;Z)[B", "relaynet"})
public final class ASN1Utils {
    @NotNull
    private static final DateTimeFormatter BER_DATETIME_FORMATTER;
    public static final ASN1Utils INSTANCE;

    @NotNull
    public final DateTimeFormatter getBER_DATETIME_FORMATTER() {
        return BER_DATETIME_FORMATTER;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serializeSequence(@NotNull ASN1Encodable[] items, boolean explicitTagging) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        ASN1EncodableVector messagesVector = new ASN1EncodableVector(items.length);
        if (explicitTagging) {
            list = ArraysKt.asList((Object[])items);
        } else {
            void $this$mapIndexedTo$iv$iv;
            ASN1Encodable[] $this$mapIndexed$iv = items;
            boolean $i$f$mapIndexed = false;
            ASN1Encodable[] aSN1EncodableArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n = index$iv$iv++;
                void var15_15 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DERTaggedObject dERTaggedObject = new DERTaggedObject(false, (int)index, (ASN1Encodable)item);
                collection.add(dERTaggedObject);
            }
            list = (List)destination$iv$iv;
        }
        List finalItems = list;
        Iterable $this$forEach$iv = finalItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASN1Encodable it = (ASN1Encodable)element$iv;
            boolean bl = false;
            messagesVector.add(it);
        }
        DERSequence sequence = new DERSequence(messagesVector);
        byte[] byArray = sequence.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sequence.encoded");
        return byArray;
    }

    public static /* synthetic */ byte[] serializeSequence$default(ASN1Utils aSN1Utils, ASN1Encodable[] aSN1EncodableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.serializeSequence(aSN1EncodableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final /* synthetic */ <T extends ASN1Encodable> T[] deserializeHomogeneousSequence(@NotNull byte[] serialization) throws ASN1Exception {
        void $this$mapTo$iv$iv;
        ASN1Sequence sequence;
        ASN1Sequence _2;
        ASN1Primitive aSN1Primitive;
        int $i$f$deserializeHomogeneousSequence = 0;
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        byte[] byArray = serialization;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new ASN1Exception("Value is empty", null, 2, null);
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _2) {
            throw (Throwable)new ASN1Exception("Value is not DER-encoded", null, 2, null);
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            _2 = ASN1Sequence.getInstance((Object)asn1Value);
        }
        catch (IllegalArgumentException _3) {
            throw (Throwable)new ASN1Exception("Value is not an ASN.1 sequence", null, 2, null);
        }
        ASN1Sequence aSN1Sequence = sequence = _2;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence, (String)"sequence");
        Iterable $this$map$iv = (Iterable)aSN1Sequence;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(it instanceof ASN1Encodable)) {
                throw (Throwable)new ASN1Exception("Sequence contains an item of an unexpected type " + '(' + it.getClass().getSimpleName() + ')', null, 2, null);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            ASN1Encodable aSN1Encodable2 = (ASN1Encodable)it;
            collection.add(aSN1Encodable2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ASN1Encodable[])objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ASN1TaggedObject[] deserializeHeterogeneousSequence(@NotNull byte[] serialization) throws ASN1Exception {
        void $this$mapTo$iv$iv$iv;
        ASN1Sequence sequence$iv;
        ASN1Sequence _$iv2;
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        ASN1Utils this_$iv = this;
        boolean $i$f$deserializeHomogeneousSequence = false;
        byte[] byArray = serialization;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new ASN1Exception("Value is empty", null, 2, null);
        }
        ASN1InputStream asn1InputStream$iv = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream$iv.readObject();
        }
        catch (IOException _$iv2) {
            throw (Throwable)new ASN1Exception("Value is not DER-encoded", null, 2, null);
        }
        ASN1Primitive asn1Value$iv = aSN1Primitive;
        try {
            _$iv2 = ASN1Sequence.getInstance((Object)asn1Value$iv);
        }
        catch (IllegalArgumentException _$iv3) {
            throw (Throwable)new ASN1Exception("Value is not an ASN.1 sequence", null, 2, null);
        }
        ASN1Sequence aSN1Sequence = sequence$iv = _$iv2;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence, (String)"sequence");
        Iterable $this$map$iv$iv = (Iterable)aSN1Sequence;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl2 = false;
            if (!(it$iv instanceof ASN1TaggedObject)) {
                throw (Throwable)new ASN1Exception("Sequence contains an item of an unexpected type " + '(' + it$iv.getClass().getSimpleName() + ')', null, 2, null);
            }
            ASN1Encodable aSN1Encodable2 = (ASN1Encodable)((ASN1TaggedObject)it$iv);
            collection.add(aSN1Encodable2);
        }
        Collection $this$toTypedArray$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        ASN1TaggedObject[] aSN1TaggedObjectArray = thisCollection$iv$iv.toArray(new ASN1TaggedObject[0]);
        if (aSN1TaggedObjectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ASN1TaggedObject[])((ASN1Encodable[])aSN1TaggedObjectArray);
    }

    @NotNull
    public final DERGeneralizedTime derEncodeUTCDate(@NotNull ZonedDateTime date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        ZonedDateTime dateUTC = date.withZoneSameInstant(ZoneOffset.UTC);
        return new DERGeneralizedTime(dateUTC.format(BER_DATETIME_FORMATTER));
    }

    @NotNull
    public final ASN1ObjectIdentifier getOID(@NotNull ASN1TaggedObject oidSerialized) throws ASN1Exception {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)oidSerialized, (String)"oidSerialized");
        try {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)oidSerialized, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1ObjectIdentifier2, (String)"ASN1ObjectIdentifier.get\u2026nce(oidSerialized, false)");
            aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
        }
        catch (IllegalArgumentException exc) {
            throw (Throwable)new ASN1Exception("Value is not an OID", exc);
        }
        return aSN1ObjectIdentifier;
    }

    @NotNull
    public final DERVisibleString getVisibleString(@NotNull ASN1TaggedObject visibleString) {
        Intrinsics.checkParameterIsNotNull((Object)visibleString, (String)"visibleString");
        DERVisibleString dERVisibleString = DERVisibleString.getInstance((ASN1TaggedObject)visibleString, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString, (String)"DERVisibleString.getInstance(visibleString, false)");
        return dERVisibleString;
    }

    @NotNull
    public final ASN1OctetString getOctetString(@NotNull ASN1TaggedObject octetString) {
        Intrinsics.checkParameterIsNotNull((Object)octetString, (String)"octetString");
        ASN1OctetString aSN1OctetString = DEROctetString.getInstance((ASN1TaggedObject)octetString, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1OctetString, (String)"DEROctetString.getInstance(octetString, false)");
        return aSN1OctetString;
    }

    private ASN1Utils() {
    }

    static {
        ASN1Utils aSN1Utils;
        INSTANCE = aSN1Utils = new ASN1Utils();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"yyyyMMddHHmmss\")");
        BER_DATETIME_FORMATTER = dateTimeFormatter;
    }
}

