/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.RSASigning;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.KeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationRequest;", "", "clientPublicKey", "Ljava/security/PublicKey;", "craSerialized", "", "(Ljava/security/PublicKey;[B)V", "getClientPublicKey", "()Ljava/security/PublicKey;", "getCraSerialized", "()[B", "serialize", "clientPrivateKey", "Ljava/security/PrivateKey;", "Companion", "relaynet"})
public final class ClientRegistrationRequest {
    @NotNull
    private final PublicKey clientPublicKey;
    @NotNull
    private final byte[] craSerialized;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey clientPrivateKey) {
        Intrinsics.checkParameterIsNotNull((Object)clientPrivateKey, (String)"clientPrivateKey");
        byte[] craCountersignaturePlaintext = ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)OIDs.INSTANCE.getCRA_COUNTERSIGNATURE(), (ASN1Encodable)new DEROctetString(this.craSerialized)}, false);
        byte[] craCountersignature = RSASigning.INSTANCE.sign(craCountersignaturePlaintext, clientPrivateKey);
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)new DEROctetString(this.clientPublicKey.getEncoded()), (ASN1Encodable)new DEROctetString(this.craSerialized), (ASN1Encodable)new DEROctetString(craCountersignature)}, false);
    }

    @NotNull
    public final PublicKey getClientPublicKey() {
        return this.clientPublicKey;
    }

    @NotNull
    public final byte[] getCraSerialized() {
        return this.craSerialized;
    }

    public ClientRegistrationRequest(@NotNull PublicKey clientPublicKey, @NotNull byte[] craSerialized) {
        Intrinsics.checkParameterIsNotNull((Object)clientPublicKey, (String)"clientPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)craSerialized, (String)"craSerialized");
        this.clientPublicKey = clientPublicKey;
        this.craSerialized = craSerialized;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationRequest$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/ClientRegistrationRequest;", "serialization", "", "verifyCRACountersignature", "", "craSerialized", "Lorg/bouncycastle/asn1/ASN1OctetString;", "craCountersignature", "clientPublicKey", "Ljava/security/PublicKey;", "relaynet"})
    public static final class Companion {
        @NotNull
        public final ClientRegistrationRequest deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            PublicKey publicKey;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw (Throwable)new InvalidMessageException("CRR is not a DER sequence", exc);
            }
            ASN1TaggedObject[] crrSequence = aSN1TaggedObjectArray;
            if (crrSequence.length < 3) {
                throw (Throwable)new InvalidMessageException("CRR sequence should have at least 3 items (got " + crrSequence.length + ')', null, 2, null);
            }
            ASN1OctetString clientPublicKeyASN1 = ASN1Utils.INSTANCE.getOctetString(crrSequence[0]);
            try {
                byte[] byArray = clientPublicKeyASN1.getOctets();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"clientPublicKeyASN1.octets");
                publicKey = Keys.deserializeRSAPublicKey(byArray);
            }
            catch (KeyException exc) {
                throw (Throwable)new InvalidMessageException("Client public key is invalid", exc);
            }
            PublicKey clientPublicKey = publicKey;
            ASN1OctetString craSerialized = ASN1Utils.INSTANCE.getOctetString(crrSequence[1]);
            byte[] craCounterSignature = ASN1Utils.INSTANCE.getOctetString(crrSequence[2]).getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)craCounterSignature, (String)"craCounterSignature");
            this.verifyCRACountersignature(craSerialized, craCounterSignature, clientPublicKey);
            byte[] byArray = craSerialized.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"craSerialized.octets");
            return new ClientRegistrationRequest(clientPublicKey, byArray);
        }

        private final void verifyCRACountersignature(ASN1OctetString craSerialized, byte[] craCountersignature, PublicKey clientPublicKey) throws InvalidMessageException {
            byte[] expectedPlaintext = ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)OIDs.INSTANCE.getCRA_COUNTERSIGNATURE(), (ASN1Encodable)craSerialized}, false);
            if (!RSASigning.INSTANCE.verify(craCountersignature, clientPublicKey, expectedPlaintext)) {
                throw (Throwable)new InvalidMessageException("CRA countersignature is invalid", null, 2, null);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

