/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\t\u001a\u00020\u0007\u001a4\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\t\u001a\u00020\u0007\u001a0\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"issueEndpointCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "subjectPublicKey", "Ljava/security/PublicKey;", "issuerPrivateKey", "Ljava/security/PrivateKey;", "validityEndDate", "Ljava/time/ZonedDateTime;", "issuerCertificate", "validityStartDate", "issueGatewayCertificate", "issueParcelDeliveryAuthorization", "relaynet"})
@JvmName(name="PKI")
public final class PKI {
    @NotNull
    public static final Certificate issueGatewayCertificate(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkParameterIsNotNull((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkParameterIsNotNull((Object)validityStartDate, (String)"validityStartDate");
        boolean isSelfIssued = issuerCertificate == null;
        return Certificate.Companion.issue$relaynet(Keys.getPrivateAddress(subjectPublicKey), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, true, isSelfIssued ? 2 : 1, validityStartDate);
    }

    public static /* synthetic */ Certificate issueGatewayCertificate$default(PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 8) != 0) {
            certificate = null;
        }
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"ZonedDateTime.now()");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueGatewayCertificate(publicKey, privateKey, zonedDateTime, certificate, zonedDateTime2);
    }

    @NotNull
    public static final Certificate issueEndpointCertificate(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkParameterIsNotNull((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkParameterIsNotNull((Object)validityStartDate, (String)"validityStartDate");
        return Certificate.Companion.issue$relaynet(Keys.getPrivateAddress(subjectPublicKey), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, true, 0, validityStartDate);
    }

    public static /* synthetic */ Certificate issueEndpointCertificate$default(PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 8) != 0) {
            certificate = null;
        }
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"ZonedDateTime.now()");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueEndpointCertificate(publicKey, privateKey, zonedDateTime, certificate, zonedDateTime2);
    }

    @NotNull
    public static final Certificate issueParcelDeliveryAuthorization(@NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @NotNull Certificate issuerCertificate, @NotNull ZonedDateTime validityStartDate) {
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)issuerPrivateKey, (String)"issuerPrivateKey");
        Intrinsics.checkParameterIsNotNull((Object)validityEndDate, (String)"validityEndDate");
        Intrinsics.checkParameterIsNotNull((Object)issuerCertificate, (String)"issuerCertificate");
        Intrinsics.checkParameterIsNotNull((Object)validityStartDate, (String)"validityStartDate");
        return Certificate.Companion.issue$relaynet(Keys.getPrivateAddress(subjectPublicKey), subjectPublicKey, issuerPrivateKey, validityEndDate, issuerCertificate, false, 0, validityStartDate);
    }

    public static /* synthetic */ Certificate issueParcelDeliveryAuthorization$default(PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"ZonedDateTime.now()");
            zonedDateTime2 = zonedDateTime3;
        }
        return PKI.issueParcelDeliveryAuthorization(publicKey, privateKey, zonedDateTime, certificate, zonedDateTime2);
    }
}

