/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFSerializer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\b\u0010\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "", "recipientAddress", "", "messageId", "creationTime", "Ljava/time/ZonedDateTime;", "ttl", "", "payload", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/ZonedDateTime;I[B)V", "getCreationTime", "()Ljava/time/ZonedDateTime;", "getMessageId", "()Ljava/lang/String;", "getPayload", "()[B", "getRecipientAddress", "getTtl", "()I", "serialize", "Companion", "relaynet"})
public class RAMFMessage {
    @NotNull
    private final String recipientAddress;
    @NotNull
    private final String messageId;
    @NotNull
    private final ZonedDateTime creationTime;
    private final int ttl;
    @NotNull
    private final byte[] payload;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize() {
        return Companion.serialize(this);
    }

    @NotNull
    public final String getRecipientAddress() {
        return this.recipientAddress;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    public RAMFMessage(@NotNull String recipientAddress, @NotNull String messageId, @NotNull ZonedDateTime creationTime, int ttl, @NotNull byte[] payload) {
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Intrinsics.checkParameterIsNotNull((Object)creationTime, (String)"creationTime");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.recipientAddress = recipientAddress;
        this.messageId = messageId;
        this.creationTime = creationTime;
        this.ttl = ttl;
        this.payload = payload;
        if (1023 < this.recipientAddress.length()) {
            throw (Throwable)new RAMFException("Recipient address cannot span more than 1023 octets (got " + this.recipientAddress.length() + ')');
        }
        if (255 < this.messageId.length()) {
            throw (Throwable)new RAMFException("Message id cannot span more than 255 octets (got " + this.messageId.length() + ')');
        }
        if (this.ttl < 0) {
            throw (Throwable)new RAMFException("TTL cannot be negative (got " + this.ttl + ')');
        }
        if (15552000 < this.ttl) {
            throw (Throwable)new RAMFException("TTL cannot be greater than 15552000 (got " + this.ttl + ')');
        }
        if (0x800000 < this.payload.length) {
            throw (Throwable)new RAMFException("Payload cannot span more than 8388608 octets (got " + this.payload.length + ')');
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage$Companion;", "Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "()V", "relaynet"})
    public static final class Companion
    extends RAMFSerializer<RAMFMessage> {
        private Companion() {
            super((byte)0, (byte)0, 1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

