/*
 * Decompiled with CFR 0.152.
 */
package tech.liujin.widget.pager;

import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import tech.liujin.widget.pager.PagerItemInfo;
import tech.liujin.widget.pager.PagerItemPool;

public abstract class BasePagerAdapter<D, V extends View>
extends PagerAdapter {
    private PagerItemPool<D, V> mPool = new PagerItemPool(this);

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        PagerItemInfo<D, V> info = this.mPool.getPagerItemInfo(container, position);
        container.addView(info.getView());
        return info;
    }

    public abstract int getCount();

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        PagerItemInfo pagerItemInfo = (PagerItemInfo)object;
        return pagerItemInfo.getView() == view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        PagerItemInfo itemInfo = (PagerItemInfo)object;
        Object view = itemInfo.getView();
        container.removeView(view);
        itemInfo.setPosition(-1);
        itemInfo.setData(null);
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    protected abstract D getData(int var1);

    protected abstract V getView(ViewGroup var1, int var2);

    protected abstract void bindData(int var1, D var2, V var3);

    public V getItemView(int position) {
        PagerItemInfo<D, V> item = this.mPool.getPagerItem(position);
        return item == null ? null : (V)item.getView();
    }

    public D getItemData(int position) {
        PagerItemInfo<D, V> item = this.mPool.getPagerItem(position);
        return item == null ? null : (D)item.getData();
    }
}

