/*
 * Decompiled with CFR 0.152.
 */
package tech.liujin.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.ImageView;

public class ScaleImageView
extends AppCompatImageView {
    protected float mCanvasScaleX = 1.0f;
    protected float mMinCanvasScaleX = 1.0f;
    protected float mCanvasScaleY = 1.0f;
    protected float mMinCanvasScaleY = 1.0f;
    protected float mPivotPointX = 0.5f;
    protected float mPivotPointY = 0.5f;
    protected float mTranslateX;
    protected float mTranslateY;
    protected boolean isScaleGestureEnabled = true;
    protected boolean isTranslateGestureEnabled = true;
    protected boolean isTouchEventEnabled = true;
    protected ScaleGestureDetector mScaleGestureDetector;
    protected GestureDetector mTranslateGestureDetector;
    protected RectF mDrawableRect;
    protected Rect mCanvasRect;

    public ScaleImageView(Context context) {
        this(context, null, 0);
    }

    public ScaleImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScaleImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initField(context);
    }

    private void initField(Context context) {
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        this.mTranslateGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.mDrawableRect = new RectF();
        this.mCanvasRect = new Rect();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean isScaleGestureEnabled() {
        return this.isScaleGestureEnabled;
    }

    public void setScaleGestureEnabled(boolean scaleGestureEnabled) {
        this.isScaleGestureEnabled = scaleGestureEnabled;
    }

    public boolean isTranslateGestureEnabled() {
        return this.isTranslateGestureEnabled;
    }

    public void setTranslateGestureEnabled(boolean translateGestureEnabled) {
        this.isTranslateGestureEnabled = translateGestureEnabled;
    }

    public boolean isTouchEventEnabled() {
        return this.isTouchEventEnabled;
    }

    public void setTouchEventEnabled(boolean touchEventEnabled) {
        this.isTouchEventEnabled = touchEventEnabled;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.isTouchEventEnabled) {
            this.handleScaleGesture(event);
            this.handleTranslateGesture(event);
            super.onTouchEvent(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        canvas.getClipBounds(this.mCanvasRect);
        int i = canvas.save();
        canvas.scale(this.mCanvasScaleX, this.mCanvasScaleY, (float)this.getWidth() * this.mPivotPointX, (float)this.getHeight() * this.mPivotPointY);
        float dx = this.mTranslateX / this.mCanvasScaleX;
        float dy = this.mTranslateY / this.mCanvasScaleY;
        canvas.translate(dx, dy);
        super.onDraw(canvas);
        canvas.restoreToCount(i);
    }

    public RectF getDrawableRect() {
        this.getDrawableRectByScaleType(this.mCanvasRect);
        float dLeftOffset = this.mDrawableRect.left - (float)this.mCanvasRect.left;
        float dTopOffset = this.mDrawableRect.top - (float)this.mCanvasRect.top;
        float dRightOffset = this.mDrawableRect.right - (float)this.mCanvasRect.right;
        float dBottomOffset = this.mDrawableRect.bottom - (float)this.mCanvasRect.bottom;
        float centerX = (float)this.mCanvasRect.width() * this.mPivotPointX;
        float centerY = (float)this.mCanvasRect.height() * this.mPivotPointY;
        float canvasLeft = centerX - centerX * this.mCanvasScaleX + this.mTranslateX;
        float canvasTop = centerY - centerY * this.mCanvasScaleY + this.mTranslateY;
        float canvasRight = centerX + ((float)this.mCanvasRect.width() - centerX) * this.mCanvasScaleX + this.mTranslateX;
        float canvasBottom = centerY + ((float)this.mCanvasRect.height() - centerY) * this.mCanvasScaleY + this.mTranslateY;
        float dLeft = canvasLeft + dLeftOffset * this.mCanvasScaleX;
        float dTop = canvasTop + dTopOffset * this.mCanvasScaleY;
        float dRight = canvasRight + dRightOffset * this.mCanvasScaleX;
        float dBottom = canvasBottom + dBottomOffset * this.mCanvasScaleY;
        this.mDrawableRect.set(dLeft, dTop, dRight, dBottom);
        this.invalidate();
        return this.mDrawableRect;
    }

    public void getDrawableRect(RectF rectF) {
        rectF.set(this.getDrawableRect());
    }

    private void getDrawableRectByScaleType(Rect canvasRect) {
        if (this.getDrawable() == null) {
            this.mDrawableRect.set(canvasRect);
            return;
        }
        if (this.getScaleType() == ImageView.ScaleType.CENTER) {
            this.getCenterRect(canvasRect);
            return;
        }
        if (this.getScaleType() == ImageView.ScaleType.CENTER_CROP) {
            this.getCenterCropRect(canvasRect);
            return;
        }
        if (this.getScaleType() == ImageView.ScaleType.CENTER_INSIDE) {
            int width = this.getDrawable().getIntrinsicWidth();
            int height = this.getDrawable().getIntrinsicHeight();
            if (width < canvasRect.width() && height < canvasRect.height()) {
                this.getCenterRect(canvasRect);
            } else {
                this.getCenterInsideRect(canvasRect);
            }
            return;
        }
        if (this.getScaleType() == ImageView.ScaleType.FIT_START) {
            this.getFitStartRect(canvasRect);
            return;
        }
        if (this.getScaleType() == ImageView.ScaleType.FIT_CENTER) {
            this.getCenterInsideRect(canvasRect);
            return;
        }
        if (this.getScaleType() == ImageView.ScaleType.FIT_END) {
            this.getFitEndRect(canvasRect);
            return;
        }
        this.mDrawableRect.set(canvasRect);
    }

    private void getFitEndRect(Rect canvasRect) {
        float fateHeight;
        int width = this.getDrawable().getIntrinsicWidth();
        int height = this.getDrawable().getIntrinsicHeight();
        float fateWidth = (float)canvasRect.width() * 1.0f / (float)width;
        if (fateWidth > (fateHeight = (float)canvasRect.height() * 1.0f / (float)height)) {
            float cropWidth = (float)canvasRect.height() * 1.0f * (float)width / (float)height;
            float xOffset = cropWidth - (float)canvasRect.width();
            this.mDrawableRect.set((float)this.mCanvasRect.left - xOffset, (float)this.mCanvasRect.top, (float)this.mCanvasRect.right, (float)this.mCanvasRect.bottom);
        } else {
            float cropHeight = (float)canvasRect.width() * 1.0f * (float)height / (float)width;
            float yOffset = cropHeight - (float)canvasRect.height();
            this.mDrawableRect.set((float)this.mCanvasRect.left, (float)this.mCanvasRect.top - yOffset, (float)this.mCanvasRect.right, (float)this.mCanvasRect.bottom);
        }
    }

    private void getFitStartRect(Rect canvasRect) {
        float fateHeight;
        int width = this.getDrawable().getIntrinsicWidth();
        int height = this.getDrawable().getIntrinsicHeight();
        float fateWidth = (float)canvasRect.width() * 1.0f / (float)width;
        if (fateWidth > (fateHeight = (float)canvasRect.height() * 1.0f / (float)height)) {
            float cropWidth = (float)canvasRect.height() * 1.0f * (float)width / (float)height;
            float xOffset = cropWidth - (float)canvasRect.width();
            this.mDrawableRect.set((float)this.mCanvasRect.left, (float)this.mCanvasRect.top, (float)this.mCanvasRect.right + xOffset, (float)this.mCanvasRect.bottom);
        } else {
            float cropHeight = (float)canvasRect.width() * 1.0f * (float)height / (float)width;
            float yOffset = cropHeight - (float)canvasRect.height();
            this.mDrawableRect.set((float)this.mCanvasRect.left, (float)this.mCanvasRect.top, (float)this.mCanvasRect.right, (float)this.mCanvasRect.bottom + yOffset);
        }
    }

    private void getCenterInsideRect(Rect canvasRect) {
        float fateHeight;
        int width = this.getDrawable().getIntrinsicWidth();
        int height = this.getDrawable().getIntrinsicHeight();
        float fateWidth = (float)canvasRect.width() * 1.0f / (float)width;
        if (fateWidth > (fateHeight = (float)canvasRect.height() * 1.0f / (float)height)) {
            float cropWidth = (float)canvasRect.height() * 1.0f * (float)width / (float)height;
            float xOffset = (cropWidth - (float)canvasRect.width()) / 2.0f;
            this.mDrawableRect.set((float)this.mCanvasRect.left - xOffset, (float)this.mCanvasRect.top, (float)this.mCanvasRect.right + xOffset, (float)this.mCanvasRect.bottom);
        } else {
            float cropHeight = (float)canvasRect.width() * 1.0f * (float)height / (float)width;
            float yOffset = (cropHeight - (float)canvasRect.height()) / 2.0f;
            this.mDrawableRect.set((float)this.mCanvasRect.left, (float)this.mCanvasRect.top - yOffset, (float)this.mCanvasRect.right, (float)this.mCanvasRect.bottom + yOffset);
        }
    }

    private void getCenterCropRect(Rect canvasRect) {
        float fateHeight;
        int width = this.getDrawable().getIntrinsicWidth();
        int height = this.getDrawable().getIntrinsicHeight();
        float fateWidth = (float)canvasRect.width() * 1.0f / (float)width;
        if (fateWidth <= (fateHeight = (float)canvasRect.height() * 1.0f / (float)height)) {
            float cropWidth = (float)canvasRect.height() * 1.0f * (float)width / (float)height;
            float xOffset = (cropWidth - (float)canvasRect.width()) / 2.0f;
            this.mDrawableRect.set((float)this.mCanvasRect.left - xOffset, (float)this.mCanvasRect.top, (float)this.mCanvasRect.right + xOffset, (float)this.mCanvasRect.bottom);
        } else {
            float cropHeight = (float)canvasRect.width() * 1.0f * (float)height / (float)width;
            float yOffset = (cropHeight - (float)canvasRect.height()) / 2.0f;
            this.mDrawableRect.set((float)this.mCanvasRect.left, (float)this.mCanvasRect.top - yOffset, (float)this.mCanvasRect.right, (float)this.mCanvasRect.bottom + yOffset);
        }
    }

    private void getCenterRect(Rect canvasRect) {
        int width = this.getDrawable().getIntrinsicWidth();
        int height = this.getDrawable().getIntrinsicHeight();
        float xOffset = width - canvasRect.width() >> 1;
        float yOffset = height - canvasRect.height() >> 1;
        this.mDrawableRect.set((float)canvasRect.left - xOffset, (float)canvasRect.top - yOffset, (float)canvasRect.right + xOffset, (float)canvasRect.bottom + yOffset);
    }

    public void handleScaleGesture(MotionEvent event) {
        if (this.isScaleGestureEnabled) {
            this.mScaleGestureDetector.onTouchEvent(event);
        }
    }

    public void handleTranslateGesture(MotionEvent event) {
        if (this.isTranslateGestureEnabled) {
            this.mTranslateGestureDetector.onTouchEvent(event);
        }
    }

    public void setMinCanvasScaleX(float minCanvasScaleX) {
        this.mMinCanvasScaleX = minCanvasScaleX;
    }

    public float getMinCanvasScaleX() {
        return this.mMinCanvasScaleX;
    }

    public void setCanvasScaleX(float scaleX) {
        this.setCanvasScaleX(scaleX, this.mPivotPointX, this.mPivotPointY);
    }

    public void setCanvasScaleX(float scaleX, @FloatRange(from=0.0, to=1.0) float pivotX, @FloatRange(from=0.0, to=1.0) float pivotY) {
        if (scaleX < this.mMinCanvasScaleX) {
            scaleX = this.mMinCanvasScaleX;
        }
        if (this.mCanvasScaleX == scaleX) {
            return;
        }
        this.mCanvasScaleX = scaleX;
        if (pivotX < 0.0f) {
            pivotX = 0.0f;
        } else if (pivotX > 1.0f) {
            pivotX = 1.0f;
        }
        if (pivotY < 0.0f) {
            pivotY = 0.0f;
        } else if (pivotY > 1.0f) {
            pivotY = 1.0f;
        }
        this.mPivotPointX = pivotX;
        this.mPivotPointY = pivotY;
        this.invalidate();
    }

    public float getCanvasScaleX() {
        return this.mCanvasScaleX;
    }

    public void setMinCanvasScaleY(float minCanvasScaleY) {
        this.mMinCanvasScaleY = minCanvasScaleY;
    }

    public float getMinCanvasScaleY() {
        return this.mMinCanvasScaleY;
    }

    public void setCanvasScaleY(float scaleY) {
        this.setCanvasScaleY(scaleY, this.mPivotPointX, this.mPivotPointY);
    }

    public void setCanvasScaleY(float scaleY, @FloatRange(from=0.0, to=1.0) float pivotX, @FloatRange(from=0.0, to=1.0) float pivotY) {
        if (scaleY < this.mMinCanvasScaleY) {
            scaleY = this.mMinCanvasScaleY;
        }
        if (this.mCanvasScaleY == scaleY) {
            return;
        }
        this.mCanvasScaleY = scaleY;
        if (pivotX < 0.0f) {
            pivotX = 0.0f;
        } else if (pivotX > 1.0f) {
            pivotX = 1.0f;
        }
        if (pivotY < 0.0f) {
            pivotY = 0.0f;
        } else if (pivotY > 1.0f) {
            pivotY = 1.0f;
        }
        this.mPivotPointX = pivotX;
        this.mPivotPointY = pivotY;
        this.invalidate();
    }

    public float getCanvasScaleY() {
        return this.mCanvasScaleY;
    }

    public void setCanvasScale(float scaleX, float scaleY) {
        this.setCanvasScale(scaleX, scaleY, this.mPivotPointX, this.mPivotPointY);
    }

    public void setCanvasScale(float scaleX, float scaleY, float pivotX, float pivotY) {
        if (scaleY < this.mMinCanvasScaleY) {
            scaleY = this.mMinCanvasScaleY;
        }
        if (scaleX < this.mMinCanvasScaleX) {
            scaleX = this.mMinCanvasScaleX;
        }
        if (pivotX < 0.0f) {
            pivotX = 0.0f;
        } else if (pivotX > 1.0f) {
            pivotX = 1.0f;
        }
        if (pivotY < 0.0f) {
            pivotY = 0.0f;
        } else if (pivotY > 1.0f) {
            pivotY = 1.0f;
        }
        if (scaleX == this.mCanvasScaleX && scaleY == this.mCanvasScaleY && pivotX == this.mPivotPointX && pivotY == this.mPivotPointY) {
            return;
        }
        this.mCanvasScaleX = scaleX;
        this.mCanvasScaleY = scaleY;
        this.mPivotPointX = pivotX;
        this.mPivotPointY = pivotY;
        this.invalidate();
    }

    public void setTranslateX(float translateX) {
        if (this.mTranslateX == translateX) {
            return;
        }
        this.mTranslateX = translateX;
        this.invalidate();
    }

    public float getTranslateX() {
        return this.mTranslateX;
    }

    public void setTranslateY(float translateY) {
        if (this.mTranslateY == translateY) {
            return;
        }
        this.mTranslateY = translateY;
        this.invalidate();
    }

    public float getTranslateY() {
        return this.mTranslateY;
    }

    public void setTranslate(float translateX, float translateY) {
        boolean call = false;
        if (this.mTranslateX != translateX) {
            this.mTranslateX = translateX;
            call = true;
        }
        if (this.mTranslateY != translateY) {
            this.mTranslateY = translateY;
            call = true;
        }
        if (call) {
            this.invalidate();
        }
    }

    public void setChange(float scaleX, float scaleY, float translateX, float translateY) {
        this.setChange(scaleX, scaleY, this.mPivotPointX, this.mPivotPointY, translateX, translateY);
    }

    public void setChange(float scaleX, float scaleY, float pivotX, float pivotY, float translateX, float translateY) {
        this.setCanvasScale(scaleX, scaleY, pivotX, pivotY);
        this.setTranslate(translateX, translateY);
    }

    public void reset() {
        this.setChange(1.0f, 1.0f, 0.5f, 0.5f, 0.0f, 0.0f);
    }

    public boolean isNotScaledOrTranslated() {
        return this.mCanvasScaleX == 1.0f && this.mCanvasScaleY == 1.0f && this.mTranslateX == 0.0f && this.mTranslateY == 0.0f;
    }

    private class GestureListener
    implements GestureDetector.OnGestureListener {
        private float mX;
        private float mY;

        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            this.mX += distanceX;
            this.mY += distanceY;
            ScaleImageView.this.setTranslate(-this.mX, -this.mY);
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }
    }

    private class ScaleGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private ScaleGestureListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float factor = detector.getScaleFactor();
            float v = ScaleImageView.this.mCanvasScaleX * factor;
            float v1 = ScaleImageView.this.mCanvasScaleY * factor;
            ScaleImageView.this.setCanvasScale(v, v1);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }
}

