/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation;

import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class FileAnnotation {
    protected String text;
    protected String link;
    protected PDRectangle rectangle;
    protected PDPage page;

    FileAnnotation(String text, String link, PDRectangle rectangle, PDPage page) {
        this.text = text;
        this.link = link;
        this.rectangle = rectangle;
        this.page = page;
    }

    public static FileAnnotationBuilder builder() {
        return new FileAnnotationBuilder();
    }

    public String getText() {
        return this.text;
    }

    public String getLink() {
        return this.link;
    }

    public PDRectangle getRectangle() {
        return this.rectangle;
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setRectangle(PDRectangle rectangle) {
        this.rectangle = rectangle;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileAnnotation)) {
            return false;
        }
        FileAnnotation other = (FileAnnotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        PDRectangle this$rectangle = this.getRectangle();
        PDRectangle other$rectangle = other.getRectangle();
        if (this$rectangle == null ? other$rectangle != null : !this$rectangle.equals(other$rectangle)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        PDRectangle $rectangle = this.getRectangle();
        result = result * 59 + ($rectangle == null ? 43 : $rectangle.hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String toString() {
        return "FileAnnotation(text=" + this.getText() + ", link=" + this.getLink() + ", rectangle=" + this.getRectangle() + ", page=" + this.getPage() + ")";
    }

    public static class FileAnnotationBuilder {
        private String text;
        private String link;
        private PDRectangle rectangle;
        private PDPage page;

        FileAnnotationBuilder() {
        }

        public FileAnnotationBuilder text(String text) {
            this.text = text;
            return this;
        }

        public FileAnnotationBuilder link(String link) {
            this.link = link;
            return this;
        }

        public FileAnnotationBuilder rectangle(PDRectangle rectangle) {
            this.rectangle = rectangle;
            return this;
        }

        public FileAnnotationBuilder page(PDPage page) {
            this.page = page;
            return this;
        }

        public FileAnnotation build() {
            return new FileAnnotation(this.text, this.link, this.rectangle, this.page);
        }

        public String toString() {
            return "FileAnnotation.FileAnnotationBuilder(text=" + this.text + ", link=" + this.link + ", rectangle=" + this.rectangle + ", page=" + this.page + ")";
        }
    }
}

