/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation;

import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class Annotation {
    protected int id;
    protected String title;
    protected float xBottom;
    protected float yBottom;
    protected float width;
    protected float height;
    protected PDPage page;

    public PDAnnotationLink createPDAnnotationLink() {
        PDRectangle position = new PDRectangle(this.xBottom, this.yBottom, this.width, this.height);
        PDAnnotationLink link = new PDAnnotationLink();
        PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
        link.setBorderStyle(borderULine);
        link.setRectangle(position);
        link.setHighlightMode("P");
        return link;
    }

    Annotation(int id, String title, float xBottom, float yBottom, float width, float height, PDPage page) {
        this.id = id;
        this.title = title;
        this.xBottom = xBottom;
        this.yBottom = yBottom;
        this.width = width;
        this.height = height;
        this.page = page;
    }

    public static AnnotationBuilder builder() {
        return new AnnotationBuilder();
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public float getXBottom() {
        return this.xBottom;
    }

    public float getYBottom() {
        return this.yBottom;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXBottom(float xBottom) {
        this.xBottom = xBottom;
    }

    public void setYBottom(float yBottom) {
        this.yBottom = yBottom;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Float.compare(this.getXBottom(), other.getXBottom()) != 0) {
            return false;
        }
        if (Float.compare(this.getYBottom(), other.getYBottom()) != 0) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Annotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Float.floatToIntBits(this.getXBottom());
        result = result * 59 + Float.floatToIntBits(this.getYBottom());
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String toString() {
        return "Annotation(id=" + this.getId() + ", title=" + this.getTitle() + ", xBottom=" + this.getXBottom() + ", yBottom=" + this.getYBottom() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", page=" + this.getPage() + ")";
    }

    public static class AnnotationBuilder {
        private int id;
        private String title;
        private float xBottom;
        private float yBottom;
        private float width;
        private float height;
        private PDPage page;

        AnnotationBuilder() {
        }

        public AnnotationBuilder id(int id) {
            this.id = id;
            return this;
        }

        public AnnotationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AnnotationBuilder xBottom(float xBottom) {
            this.xBottom = xBottom;
            return this;
        }

        public AnnotationBuilder yBottom(float yBottom) {
            this.yBottom = yBottom;
            return this;
        }

        public AnnotationBuilder width(float width) {
            this.width = width;
            return this;
        }

        public AnnotationBuilder height(float height) {
            this.height = height;
            return this;
        }

        public AnnotationBuilder page(PDPage page) {
            this.page = page;
            return this;
        }

        public Annotation build() {
            return new Annotation(this.id, this.title, this.xBottom, this.yBottom, this.width, this.height, this.page);
        }

        public String toString() {
            return "Annotation.AnnotationBuilder(id=" + this.id + ", title=" + this.title + ", xBottom=" + this.xBottom + ", yBottom=" + this.yBottom + ", width=" + this.width + ", height=" + this.height + ", page=" + this.page + ")";
        }
    }
}

