/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text.annotations;

import rst.pdfbox.layout.text.annotations.Annotation;

public class Annotations {

    public static class AnchorAnnotation
    implements Annotation {
        private final String anchor;

        public AnchorAnnotation(String anchor) {
            this.anchor = anchor;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public String toString() {
            return "AnchorAnnotation [anchor=" + this.anchor + "]";
        }
    }

    public static class HyperlinkAnnotation
    implements Annotation {
        private final String hyperlinkUri;
        private final LinkStyle linkStyle;

        public HyperlinkAnnotation(String hyperlinkUri, LinkStyle linkStyle) {
            this.hyperlinkUri = hyperlinkUri;
            this.linkStyle = linkStyle;
        }

        public String getHyperlinkURI() {
            return this.hyperlinkUri;
        }

        public LinkStyle getLinkStyle() {
            return this.linkStyle;
        }

        public String toString() {
            return "HyperlinkAnnotation [hyperlinkUri=" + this.hyperlinkUri + ", linkStyle=" + (Object)((Object)this.linkStyle) + "]";
        }

        public static enum LinkStyle {
            ul,
            none;

        }
    }

    public static class UnderlineAnnotation
    implements Annotation {
        private float baselineOffsetScale = 0.0f;
        private float lineWeight = 1.0f;

        public UnderlineAnnotation(float baselineOffsetScale, float lineWeight) {
            this.baselineOffsetScale = baselineOffsetScale;
            this.lineWeight = lineWeight;
        }

        public float getBaselineOffsetScale() {
            return this.baselineOffsetScale;
        }

        public float getLineWeight() {
            return this.lineWeight;
        }

        public String toString() {
            return "UnderlineAnnotation [baselineOffsetScale=" + this.baselineOffsetScale + ", lineWeight=" + this.lineWeight + "]";
        }
    }
}

