/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.util.EnumMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.cell.AbstractCellDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.DrawContext;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.annotations.AnnotationDrawListener;

public class ParagraphCellDrawer
extends AbstractCellDrawer<ParagraphCell> {
    private static final Map<HorizontalAlignment, Alignment> ALIGNMENT_MAP = new EnumMap<HorizontalAlignment, Alignment>(HorizontalAlignment.class);

    public ParagraphCellDrawer(ParagraphCell cell) {
        this.cell = cell;
    }

    @Override
    public void drawContent(DrawingContext drawingContext) {
        if (drawingContext.getPage() == null) {
            throw new PageNotSetException("Page is not set in drawing context. Please ensure the page is set on table drawer.");
        }
        Paragraph paragraph = ((ParagraphCell)this.cell).getParagraph().getWrappedParagraph();
        AnnotationDrawListener annotationDrawListener = this.createAndGetAnnotationDrawListenerWith(drawingContext);
        float x = drawingContext.getStartingPoint().x + ((ParagraphCell)this.cell).getPaddingLeft();
        float y = drawingContext.getStartingPoint().y + this.getAdaptionForVerticalAlignment();
        paragraph.drawText(drawingContext.getContentStream(), new Position(x, y), ALIGNMENT_MAP.getOrDefault((Object)((ParagraphCell)this.cell).getSettings().getHorizontalAlignment(), Alignment.Left), annotationDrawListener);
        annotationDrawListener.afterPage(null);
        annotationDrawListener.afterRender();
        drawingContext.getPage().getAnnotations().forEach(PDAnnotation::constructAppearances);
    }

    @Override
    protected float calculateInnerHeight() {
        return ((ParagraphCell)this.cell).getParagraph().getWrappedParagraph().getHeight();
    }

    private AnnotationDrawListener createAndGetAnnotationDrawListenerWith(final DrawingContext drawingContext) {
        return new AnnotationDrawListener(new DrawContext(){

            @Override
            public PDDocument getPdDocument() {
                return null;
            }

            @Override
            public PDPage getCurrentPage() {
                return drawingContext.getPage();
            }

            @Override
            public PDPageContentStream getCurrentPageContentStream() {
                return drawingContext.getContentStream();
            }
        });
    }

    static {
        ALIGNMENT_MAP.put(HorizontalAlignment.LEFT, Alignment.Left);
        ALIGNMENT_MAP.put(HorizontalAlignment.RIGHT, Alignment.Right);
        ALIGNMENT_MAP.put(HorizontalAlignment.CENTER, Alignment.Center);
        ALIGNMENT_MAP.put(HorizontalAlignment.JUSTIFY, Alignment.Justify);
    }

    private class PageNotSetException
    extends RuntimeException {
        public PageNotSetException(String message) {
            super(message);
        }
    }
}

