/*
 * Decompiled with CFR 0.152.
 */
package tech.gaolinfeng.imagecrop.lib;

import android.graphics.Matrix;
import android.graphics.RectF;

public class MatrixHelper {
    private RectF intrinsicRectF;
    private RectF transformedRectF;

    public void init(Matrix matrix, int intrinsicWidth, int intrinsicHeight) {
        this.intrinsicRectF = new RectF(0.0f, 0.0f, (float)intrinsicWidth, (float)intrinsicHeight);
        this.transformedRectF = new RectF();
        this.update(matrix);
    }

    public void update(Matrix matrix) {
        matrix.mapRect(this.transformedRectF, this.intrinsicRectF);
    }

    public RectF getTransformedRectF() {
        return this.transformedRectF;
    }

    public float getLeft() {
        return this.transformedRectF.left;
    }

    public float getRight() {
        return this.transformedRectF.right;
    }

    public float getWidth() {
        return this.transformedRectF.width();
    }

    public float getTop() {
        return this.transformedRectF.top;
    }

    public float getBottom() {
        return this.transformedRectF.bottom;
    }

    public float getHeight() {
        return this.transformedRectF.height();
    }

    public float getIntrinsicWidth() {
        return this.intrinsicRectF.right;
    }

    public float getIntrinsicHeight() {
        return this.intrinsicRectF.bottom;
    }
}

