/*
 * Decompiled with CFR 0.152.
 */
package tech.gaolinfeng.imagecrop.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.Toast;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import tech.gaolinfeng.imagecrop.lib.CropImageView;
import tech.gaolinfeng.imagecrop.lib.IOUtil;
import tech.gaolinfeng.imagecrop.lib.ImageUtil;
import tech.gaolinfeng.imagecrop.lib.R;

public class ImageCropActivity
extends Activity {
    private static final String REQUEST_IMAGE_PATH = "REQUEST_IMAGE_PATH";
    private static final String REQUEST_TARGET_PATH = "REQUEST_TARGET_PATH";
    private static final String REQUEST_CROP_RECT = "REQUEST_CROP_RECT";
    private static final String REQUEST_CROP_IN_CIRCLE = "REQUEST_CROP_IN_CIRCLE";
    private String inPath;
    private String outPath;
    private Rect cropRect;
    private boolean isCircle;
    private CropImageView cropImageView;
    private View loadingView;
    private int inSampleSize;

    public static Intent createIntent(Activity from, String imageFilePath, String targetPath, String cropRect, boolean cropInCircle) {
        Intent intent = new Intent((Context)from, ImageCropActivity.class);
        intent.putExtra(REQUEST_IMAGE_PATH, imageFilePath);
        intent.putExtra(REQUEST_TARGET_PATH, targetPath);
        intent.putExtra(REQUEST_CROP_RECT, cropRect);
        intent.putExtra(REQUEST_CROP_IN_CIRCLE, cropInCircle);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() != null) {
            this.inPath = this.getIntent().getStringExtra(REQUEST_IMAGE_PATH);
            this.outPath = this.getIntent().getStringExtra(REQUEST_TARGET_PATH);
            this.isCircle = this.getIntent().getBooleanExtra(REQUEST_CROP_IN_CIRCLE, true);
            String cropRectStr = this.getIntent().getStringExtra(REQUEST_CROP_RECT);
            if (cropRectStr.matches("\\s*\\d+\\s*,\\s*\\d+\\s*,\\s*\\d+\\s*,\\s*\\d+\\s*")) {
                String[] cropRectStrArray = cropRectStr.split(",");
                int[] rectData = new int[4];
                for (int i = 0; i < rectData.length; ++i) {
                    rectData[i] = Integer.parseInt(cropRectStrArray[i].trim());
                }
                this.cropRect = new Rect(rectData[0], rectData[1], rectData[2], rectData[3]);
            } else {
                throw new RuntimeException("imageCropActivity only accepts cropRect with format [left, top, right, bottom]");
            }
        }
        this.setContentView(R.layout.activity_image_crop);
        this.cropImageView = (CropImageView)this.findViewById(R.id.crop_image);
        this.cropImageView.setCropCircle(this.isCircle);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)this.inPath, (BitmapFactory.Options)options);
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int screenHeight = dm.heightPixels;
        int imgWidth = options.outWidth;
        int imgHeight = options.outHeight;
        int inSampleSizeWidth = 1;
        int inSampleSizeHeight = 1;
        while (screenWidth * inSampleSizeWidth * 2 < imgWidth) {
            inSampleSizeWidth *= 2;
        }
        while (screenHeight * inSampleSizeHeight * 2 < imgHeight) {
            inSampleSizeHeight *= 2;
        }
        this.inSampleSize = Math.max(inSampleSizeWidth, inSampleSizeHeight);
        options.inJustDecodeBounds = false;
        options.inSampleSize = this.inSampleSize;
        Bitmap bitmap = BitmapFactory.decodeFile((String)this.inPath, (BitmapFactory.Options)options);
        this.cropImageView.setImageBitmap(bitmap);
        this.cropImageView.setEdge(this.cropRect);
        this.cropImageView.startCrop();
        this.loadingView = this.findViewById(R.id.crop_image_cropping_layer);
        this.findViewById(R.id.crop_image_ok).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageCropActivity.this.loadingView.setVisibility(0);
                RectF imgRect = ImageCropActivity.this.cropImageView.getCurrentRect();
                CropTask task = new CropTask(ImageCropActivity.this, ImageCropActivity.this.inPath, ImageCropActivity.this.outPath, ImageCropActivity.this.isCircle, ImageCropActivity.this.cropRect, imgRect, (int)ImageCropActivity.this.cropImageView.getRawWidth(), (int)ImageCropActivity.this.cropImageView.getRawHeight(), ImageCropActivity.this.inSampleSize);
                task.execute(new Void[0]);
            }
        });
        this.findViewById(R.id.crop_image_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageCropActivity.this.onBackPressed();
            }
        });
    }

    private static class CropTask
    extends AsyncTask<Void, Void, Integer> {
        private static final int SUCCESS = 0;
        private static final int FAIL_CROP = 1;
        private static final int FAIL_OUT_PATH = 2;
        private String inPath;
        private String outPath;
        private Rect cropRect;
        private RectF imgRect;
        private int rawImgWidth;
        private int rawImgHeight;
        private int rawInSampleSize;
        private boolean cropCircle;
        private Activity context;

        public CropTask(Activity context, String inPath, String outPath, boolean cropCircle, Rect cropRect, RectF imgRect, int rawImgWidth, int rawImgHeight, int rawInSampleSize) {
            this.inPath = inPath;
            this.outPath = outPath;
            this.cropCircle = cropCircle;
            this.cropRect = cropRect;
            this.imgRect = imgRect;
            this.rawImgWidth = rawImgWidth;
            this.rawImgHeight = rawImgHeight;
            this.rawInSampleSize = rawInSampleSize;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(Void ... params) {
            Bitmap b;
            Bitmap bmp;
            Rect mappedCropRect = new Rect((int)(((float)this.cropRect.left - this.imgRect.left) * (float)this.rawImgWidth * (float)this.rawInSampleSize / this.imgRect.width()), (int)(((float)this.cropRect.top - this.imgRect.top) * (float)this.rawImgHeight * (float)this.rawInSampleSize / this.imgRect.height()), (int)(((float)this.cropRect.right - this.imgRect.left) * (float)this.rawImgWidth * (float)this.rawInSampleSize / this.imgRect.width()), (int)(((float)this.cropRect.bottom - this.imgRect.top) * (float)this.rawImgHeight * (float)this.rawInSampleSize / this.imgRect.height()));
            int rawCropArea = mappedCropRect.width() * mappedCropRect.height();
            int cropArea = this.cropRect.width() * this.cropRect.height();
            int inSampleSize = 1;
            while (cropArea * inSampleSize * 2 < rawCropArea) {
                inSampleSize *= 2;
            }
            try {
                if (Build.VERSION.SDK_INT > 9) {
                    BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((String)this.inPath, (boolean)true);
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inSampleSize = inSampleSize;
                    bmp = decoder.decodeRegion(mappedCropRect, options);
                } else {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inSampleSize = inSampleSize;
                    Bitmap originBitmap = BitmapFactory.decodeFile((String)this.inPath, (BitmapFactory.Options)options);
                    if (originBitmap != (bmp = Bitmap.createBitmap((Bitmap)originBitmap, (int)mappedCropRect.left, (int)mappedCropRect.top, (int)mappedCropRect.width(), (int)mappedCropRect.height()))) {
                        originBitmap.recycle();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return 1;
            }
            if (this.cropCircle) {
                b = ImageUtil.toRoundBitmap(bmp);
                bmp.recycle();
            } else {
                b = bmp;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.outPath);
                b.compress(Bitmap.CompressFormat.PNG, 70, (OutputStream)fos);
            }
            catch (FileNotFoundException e) {
                Integer n;
                try {
                    e.printStackTrace();
                    n = 2;
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(fos);
                    throw throwable;
                }
                IOUtil.closeQuietly(fos);
                return n;
            }
            IOUtil.closeQuietly(fos);
            return 0;
        }

        protected void onPostExecute(Integer integer) {
            super.onPostExecute((Object)integer);
            switch (integer) {
                case 0: {
                    this.context.setResult(-1);
                    this.context.finish();
                    break;
                }
                case 1: {
                    Toast.makeText((Context)this.context, (CharSequence)"\u56fe\u7247\u88c1\u526a\u5931\u8d25", (int)0).show();
                    break;
                }
                case 2: {
                    Toast.makeText((Context)this.context, (CharSequence)"\u8f93\u51fa\u8def\u5f84\u65e0\u6548", (int)0).show();
                }
            }
        }
    }
}

