/*
 * Decompiled with CFR 0.152.
 */
package tech.gaolinfeng.imagecrop.lib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.Scroller;
import tech.gaolinfeng.imagecrop.lib.MatrixHelper;

public class CropImageView
extends ImageView {
    private static final float MAX_ZOOM_RELATIVE_TO_INTRINSIC = 3.0f;
    private Matrix matrix;
    private MatrixHelper matrixHelper;
    private TouchState touchState = TouchState.TOUCH_STATE_IDLE;
    private Rect edgeRect;
    private CropScaleType cropScaleType;
    private boolean cropCircle = true;
    private boolean blockTouchEvent = false;
    private ScaleGestureDetector scaleGestureDetector;
    private GestureDetector gestureDetector;
    private Scroller flingScroller;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            if (CropImageView.this.blockTouchEvent) {
                return true;
            }
            CropImageView.this.scaleFactor = detector.getScaleFactor();
            CropImageView.this.matrix.getValues(CropImageView.this.matrixValues);
            if (CropImageView.this.matrixValues[0] * CropImageView.this.scaleFactor > 3.0f) {
                if ((float)CropImageView.this.edgeRect.width() / CropImageView.this.matrixHelper.getIntrinsicWidth() > 3.0f || (float)CropImageView.this.edgeRect.height() / CropImageView.this.matrixHelper.getIntrinsicHeight() > 3.0f) {
                    CropImageView.this.scaleFactor = 1.0f;
                } else {
                    CropImageView.this.scaleFactor = 3.0f / CropImageView.this.matrixValues[0];
                }
            }
            CropImageView.this.matrix.postScale(CropImageView.this.scaleFactor, CropImageView.this.scaleFactor, (float)(((CropImageView)CropImageView.this).edgeRect.left + CropImageView.this.edgeRect.width() / 2), (float)(((CropImageView)CropImageView.this).edgeRect.top + CropImageView.this.edgeRect.height() / 2));
            CropImageView.this.fixConstraints();
            return true;
        }
    };
    private GestureDetector.OnGestureListener onGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (CropImageView.this.blockTouchEvent) {
                return true;
            }
            CropImageView.this.matrix.postTranslate(-distanceX, -distanceY);
            CropImageView.this.fixConstraints();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            CropImageView.this.matrix.getValues(CropImageView.this.matrixValues);
            CropImageView.this.flingScroller.fling((int)CropImageView.this.matrixValues[2], (int)CropImageView.this.matrixValues[5], (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            CropImageView.this.invalidate();
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (CropImageView.this.blockTouchEvent) {
                return true;
            }
            CropImageView.this.matrix.getValues(CropImageView.this.matrixValues);
            float currentScale = CropImageView.this.matrixValues[0];
            if ((double)currentScale >= 2.99) {
                float targetScale = Math.max((float)CropImageView.this.edgeRect.width() / CropImageView.this.matrixHelper.getIntrinsicWidth(), (float)CropImageView.this.edgeRect.height() / CropImageView.this.matrixHelper.getIntrinsicHeight());
                CropImageView.this.mainHandler.post((Runnable)new AutoScaleRunnable(currentScale, targetScale, CropImageView.this.matrixHelper.getWidth(), CropImageView.this.matrixHelper.getHeight()));
            } else {
                float targetScale = currentScale * 2.0f;
                if ((double)targetScale + 0.5 > 3.0) {
                    targetScale = (float)CropImageView.this.edgeRect.width() / CropImageView.this.matrixHelper.getIntrinsicWidth() > 3.0f || (float)CropImageView.this.edgeRect.height() / CropImageView.this.matrixHelper.getIntrinsicHeight() > 3.0f ? 1.0f : 3.0f;
                }
                CropImageView.this.mainHandler.post((Runnable)new AutoScaleRunnable(currentScale, targetScale, CropImageView.this.matrixHelper.getWidth(), CropImageView.this.matrixHelper.getHeight()));
                CropImageView.this.matrix.postScale(CropImageView.this.scaleFactor, CropImageView.this.scaleFactor, (float)(((CropImageView)CropImageView.this).edgeRect.left + CropImageView.this.edgeRect.width() / 2), (float)(((CropImageView)CropImageView.this).edgeRect.top + CropImageView.this.edgeRect.height() / 2));
            }
            return true;
        }
    };
    private float dx = 0.0f;
    private float dy = 0.0f;
    private float scale = 1.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private Paint maskPaint;
    private Path circlePath = new Path();
    private float[] matrixValues = new float[9];
    private float scaleFactor = 1.0f;

    public CropImageView(Context context) {
        super(context);
        this.init();
    }

    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.matrixHelper = new MatrixHelper();
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), this.onScaleGestureListener);
        this.gestureDetector = new GestureDetector(this.getContext(), this.onGestureListener);
        this.flingScroller = new Scroller(this.getContext());
        this.maskPaint = new Paint();
        this.maskPaint.setColor(Color.argb((int)127, (int)0, (int)0, (int)0));
        this.maskPaint.setStyle(Paint.Style.FILL);
        this.cropScaleType = CropScaleType.CROP_SCALE_TYPE_HORIZONTAL;
    }

    public void startCrop() {
        this.startCrop(null);
    }

    public void startCrop(final Runnable onMatrixObtainedRunnable) {
        this.requestLayout();
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (CropImageView.this.isLayoutRequested()) {
                    return true;
                }
                CropImageView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                CropImageView.this.matrix = CropImageView.this.getImageMatrix();
                CropImageView.this.setImageMatrix(CropImageView.this.matrix);
                CropImageView.this.setScaleType(ImageView.ScaleType.MATRIX);
                CropImageView.this.matrixHelper.init(CropImageView.this.matrix, CropImageView.this.getDrawable().getIntrinsicWidth(), CropImageView.this.getDrawable().getIntrinsicHeight());
                switch (CropImageView.this.cropScaleType) {
                    case CROP_SCALE_TYPE_NONE: {
                        break;
                    }
                    case CROP_SCALE_TYPE_HORIZONTAL: {
                        if (!((float)CropImageView.this.getWidth() > CropImageView.this.matrixHelper.getWidth()) || !(CropImageView.this.matrixHelper.getIntrinsicWidth() * 3.0f > (float)CropImageView.this.getWidth())) break;
                        CropImageView.this.scale = (float)CropImageView.this.getWidth() / CropImageView.this.matrixHelper.getIntrinsicWidth();
                        CropImageView.this.matrix.getValues(CropImageView.this.matrixValues);
                        float currScale = CropImageView.this.matrixValues[0];
                        CropImageView.this.matrix.postScale(CropImageView.this.scale / currScale, CropImageView.this.scale / currScale, (float)(((CropImageView)CropImageView.this).edgeRect.left + CropImageView.this.edgeRect.width() / 2), (float)(((CropImageView)CropImageView.this).edgeRect.top + CropImageView.this.edgeRect.height() / 2));
                        CropImageView.this.matrixHelper.update(CropImageView.this.matrix);
                        CropImageView.this.scale = 1.0f;
                    }
                }
                CropImageView.this.onScale();
                CropImageView.this.onTranslate();
                if (onMatrixObtainedRunnable != null) {
                    onMatrixObtainedRunnable.run();
                }
                return false;
            }
        });
    }

    public void setCropCircle(boolean cropCircle) {
        this.cropCircle = cropCircle;
    }

    public void setCropScaleType(CropScaleType cropScaleType) {
        this.cropScaleType = cropScaleType;
    }

    public void setEdge(Rect edgeRect) {
        this.edgeRect = new Rect(edgeRect);
        this.invalidate();
    }

    public RectF getCurrentRect() {
        RectF rect = new RectF(0.0f, 0.0f, this.matrixHelper.getIntrinsicWidth(), this.matrixHelper.getIntrinsicHeight());
        this.matrix.mapRect(rect);
        return rect;
    }

    public float getRawWidth() {
        return this.matrixHelper.getIntrinsicWidth();
    }

    public float getRawHeight() {
        return this.matrixHelper.getIntrinsicHeight();
    }

    private void onScale() {
        this.matrixHelper.update(this.matrix);
        if (this.matrixHelper.getWidth() < (float)this.edgeRect.width()) {
            this.scaleX = (float)this.edgeRect.width() / this.matrixHelper.getWidth();
        }
        if (this.matrixHelper.getHeight() < (float)this.edgeRect.height()) {
            this.scaleY = (float)this.edgeRect.height() / this.matrixHelper.getHeight();
        }
        if (this.scaleX != 1.0f || this.scaleY != 1.0f) {
            this.scale = Math.max(this.scaleX, this.scaleY);
            this.matrix.postScale(this.scale, this.scale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.matrixHelper.update(this.matrix);
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
            this.scale = 1.0f;
        }
        this.setImageMatrix(this.matrix);
        this.invalidate();
    }

    private void fixConstraints() {
        this.onScale();
        this.onTranslate();
    }

    private void onTranslate() {
        this.matrixHelper.update(this.matrix);
        if (this.matrixHelper.getLeft() > (float)this.edgeRect.left) {
            this.dx = (float)this.edgeRect.left - this.matrixHelper.getLeft();
        } else if (this.matrixHelper.getRight() < (float)this.edgeRect.right) {
            this.dx = (float)this.edgeRect.right - this.matrixHelper.getRight();
        }
        if (this.matrixHelper.getTop() > (float)this.edgeRect.top) {
            this.dy = (float)this.edgeRect.top - this.matrixHelper.getTop();
        } else if (this.matrixHelper.getBottom() < (float)this.edgeRect.bottom) {
            this.dy = (float)this.edgeRect.bottom - this.matrixHelper.getBottom();
        }
        if (this.dx != 0.0f || this.dy != 0.0f) {
            this.matrix.postTranslate(this.dx, this.dy);
            this.matrixHelper.update(this.matrix);
            this.dx = 0.0f;
            this.dy = 0.0f;
        }
        this.setImageMatrix(this.matrix);
        this.invalidate();
    }

    public void computeScroll() {
        if (this.flingScroller.computeScrollOffset()) {
            this.matrix.postTranslate((float)this.flingScroller.getCurrX() - this.matrixHelper.getLeft(), (float)this.flingScroller.getCurrY() - this.matrixHelper.getTop());
            this.matrixHelper.update(this.matrix);
            this.onTranslate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.cropCircle) {
            try {
                canvas.save();
                this.circlePath.reset();
                this.circlePath.addCircle((float)((this.edgeRect.right + this.edgeRect.left) / 2), (float)((this.edgeRect.bottom + this.edgeRect.top) / 2), (float)((this.edgeRect.bottom - this.edgeRect.top) / 2), Path.Direction.CW);
                canvas.clipPath(this.circlePath, Region.Op.XOR);
                canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.maskPaint);
                canvas.restore();
            }
            catch (Exception e) {
                e.printStackTrace();
                canvas.restore();
                this.cropCircle = false;
            }
        }
        if (!this.cropCircle) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.edgeRect.top, this.maskPaint);
            canvas.drawRect(0.0f, (float)this.edgeRect.bottom, (float)this.getWidth(), (float)this.getHeight(), this.maskPaint);
            canvas.drawRect(0.0f, (float)this.edgeRect.top, (float)this.edgeRect.left, (float)this.edgeRect.bottom, this.maskPaint);
            canvas.drawRect((float)this.edgeRect.right, (float)this.edgeRect.top, (float)this.getWidth(), (float)this.edgeRect.bottom, this.maskPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.matrix == null) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 5: {
                if (event.getActionIndex() == 1) {
                    this.touchState = TouchState.TOUCH_STATE_ZOOM;
                    break;
                }
                this.touchState = TouchState.TOUCH_STATE_UNKNOWN;
                break;
            }
            case 6: {
                if (event.getActionIndex() == 2) {
                    this.touchState = TouchState.TOUCH_STATE_ZOOM;
                    break;
                }
                if (event.getActionIndex() == 1) {
                    this.touchState = TouchState.TOUCH_STATE_DRAG;
                    break;
                }
                this.touchState = TouchState.TOUCH_STATE_UNKNOWN;
                break;
            }
            case 0: {
                this.flingScroller.abortAnimation();
                this.touchState = TouchState.TOUCH_STATE_DRAG;
                break;
            }
            case 1: 
            case 3: {
                this.touchState = TouchState.TOUCH_STATE_IDLE;
            }
        }
        switch (this.touchState) {
            case TOUCH_STATE_DRAG: 
            case TOUCH_STATE_IDLE: {
                this.gestureDetector.onTouchEvent(event);
                break;
            }
            case TOUCH_STATE_ZOOM: {
                this.scaleGestureDetector.onTouchEvent(event);
            }
        }
        return true;
    }

    private class AutoScaleRunnable
    implements Runnable {
        private static final int SCALE_ANIMATION_FRAME_COUNT = 20;
        private float targetScale;
        private float fromScale;
        private float fromWidth;
        private float fromHeight;
        private int currentFrame;

        public AutoScaleRunnable(float fromScale, float targetScale, float fromWidth, float fromHeight) {
            this(fromScale, targetScale, 0, fromWidth, fromHeight);
        }

        public AutoScaleRunnable(float fromScale, float targetScale, int currentFrame, float fromWidth, float fromHeight) {
            this.fromScale = fromScale;
            this.targetScale = targetScale;
            this.currentFrame = currentFrame;
            this.fromWidth = fromWidth;
            this.fromHeight = fromHeight;
        }

        @Override
        public void run() {
            CropImageView.this.blockTouchEvent = true;
            ++this.currentFrame;
            float scaleStep = (this.targetScale - this.fromScale) / 20.0f;
            float currentScale = this.fromScale + scaleStep * (float)this.currentFrame;
            CropImageView.this.matrix.getValues(CropImageView.this.matrixValues);
            float prevScale = CropImageView.this.matrixValues[0];
            CropImageView.this.matrix.postScale(currentScale / prevScale, currentScale / prevScale, (float)(((CropImageView)CropImageView.this).edgeRect.left + CropImageView.this.edgeRect.width() / 2), (float)(((CropImageView)CropImageView.this).edgeRect.top + CropImageView.this.edgeRect.height() / 2));
            CropImageView.this.fixConstraints();
            if (this.currentFrame < 20) {
                CropImageView.this.mainHandler.post((Runnable)new AutoScaleRunnable(this.fromScale, this.targetScale, this.currentFrame, this.fromWidth, this.fromHeight));
            } else {
                CropImageView.this.blockTouchEvent = false;
            }
        }
    }

    private static enum TouchState {
        TOUCH_STATE_UNKNOWN,
        TOUCH_STATE_IDLE,
        TOUCH_STATE_DRAG,
        TOUCH_STATE_ZOOM;

    }

    public static enum CropScaleType {
        CROP_SCALE_TYPE_NONE,
        CROP_SCALE_TYPE_HORIZONTAL;

    }
}

