/*
 * Decompiled with CFR 0.152.
 */
package solar.blaz.date.week;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.OverScroller;
import java.util.ArrayList;
import java.util.Locale;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.TemporalAdjusters;
import solar.blaz.date.week.R;

public class WeekDatePicker
extends View {
    public static final String TAG = "DatePicker";
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 4;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private VelocityTracker velocityTracker;
    private int minimumFlingVelocity;
    private int maximumFlingVelocity;
    private int touchSlop;
    private final LocalDate today;
    private final LocalDate firstDay;
    private final DayOfWeek firstDayOfWeek;
    private final BoringLayout[] layouts = new BoringLayout[21];
    private final BoringLayout[] dayLabelLayouts = new BoringLayout[7];
    @Nullable
    private final CharSequence[] labelNames;
    private final TextPaint dayTextPaint;
    private final TextPaint dayLabelTextPain;
    private final Paint selectedDayColor;
    private BoringLayout.Metrics dayMetrics;
    private BoringLayout.Metrics dayLabelMetrics;
    private ColorStateList dayTextColor;
    private ColorStateList dayLabelTextColor;
    private TextUtils.TruncateAt ellipsize;
    @Nullable
    private Drawable dayDrawable;
    @Nullable
    private Drawable indicatorDrawable;
    private int weekWidth;
    private int dayWidth;
    private float lastDownEventX;
    private OverScroller flingScrollerX;
    private OverScroller adjustScrollerX;
    private int previousScrollerX;
    private boolean scrollingX;
    private int scrollPositionStart;
    private OnWeekChanged onWeekChanged;
    private OnDateSelected onDateSelected;
    private final SparseBooleanArray dayIndicators = new SparseBooleanArray();
    private int selectedWeek;
    private int selectedDay;
    private int pressedDay = Integer.MIN_VALUE;
    private float dividerSize = 0.0f;
    private float labelPadding = 0.0f;
    @Nullable
    private Rect backgroundRect;
    @Nullable
    private Rect indicatorRect;
    private TextDirectionHeuristicCompat textDir;

    public WeekDatePicker(Context context) {
        this(context, null);
    }

    public WeekDatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.weekDatePickerStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeekDatePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TextPaint paint = new TextPaint();
        paint.setAntiAlias(true);
        this.dayTextPaint = paint;
        this.dayLabelTextPain = new TextPaint();
        this.dayLabelTextPain.setAntiAlias(true);
        this.selectedDayColor = new Paint();
        this.selectedDayColor.setColor(-65536);
        this.selectedDayColor.setStyle(Paint.Style.FILL);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.WeekDatePicker, defStyle, 0);
        int ellipsize = 3;
        try {
            float labelTextSize;
            this.dayTextColor = a.getColorStateList(R.styleable.WeekDatePicker_android_textColor);
            if (this.dayTextColor == null) {
                this.dayTextColor = ColorStateList.valueOf((int)-16777216);
            }
            this.dayLabelTextColor = a.getColorStateList(R.styleable.WeekDatePicker_labelTextColor);
            if (this.dayLabelTextColor == null) {
                this.dayLabelTextColor = ColorStateList.valueOf((int)-16777216);
            }
            ellipsize = a.getInt(R.styleable.WeekDatePicker_android_ellipsize, ellipsize);
            this.dividerSize = a.getDimension(R.styleable.WeekDatePicker_dividerSize, this.dividerSize);
            float textSize = a.getDimension(R.styleable.WeekDatePicker_android_textSize, -1.0f);
            if (textSize > -1.0f) {
                this.setTextSize(textSize);
            }
            if ((labelTextSize = a.getDimension(R.styleable.WeekDatePicker_labelTextSize, -1.0f)) > -1.0f) {
                this.setLabelTextSize(labelTextSize);
            }
            this.labelPadding = a.getDimension(R.styleable.WeekDatePicker_labelPadding, this.labelPadding);
            this.labelNames = a.getTextArray(R.styleable.WeekDatePicker_labelNames);
            this.dayDrawable = a.getDrawable(R.styleable.WeekDatePicker_dayBackground);
            this.indicatorDrawable = a.getDrawable(R.styleable.WeekDatePicker_indicatorDrawable);
            int dayOfWeek = a.getInt(R.styleable.WeekDatePicker_firstDayOfWeek, DayOfWeek.SUNDAY.getValue());
            this.firstDayOfWeek = DayOfWeek.of((int)dayOfWeek);
        }
        finally {
            a.recycle();
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        this.buildFontMetrics();
        this.buildLabelFontMetrics();
        this.flingScrollerX = new OverScroller(context);
        this.adjustScrollerX = new OverScroller(context, (Interpolator)new DecelerateInterpolator(2.5f));
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.minimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maximumFlingVelocity = configuration.getScaledMaximumFlingVelocity() / 4;
        this.previousScrollerX = Integer.MIN_VALUE;
        this.calculateItemSize(this.getWidth(), this.getHeight());
        this.today = LocalDate.now();
        this.firstDay = this.getFirstDay(0);
        this.selectedDay = this.firstDay.until((ChronoLocalDate)this.today).getDays();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        for (int i = 0; i < 2 && (i == 0 || width != this.getMeasuredWidth()); ++i) {
            int height;
            if (heightMode == 0x40000000) {
                height = heightSize;
            } else {
                int labelTextHeight = Math.abs(this.dayLabelMetrics.ascent) + Math.abs(this.dayLabelMetrics.descent);
                labelTextHeight += this.getPaddingTop() + this.getPaddingBottom();
                int measuredWidth = this.getMeasuredWidth();
                if (measuredWidth == 0) {
                    measuredWidth = width;
                }
                int totalHeight = (int)((float)(labelTextHeight + measuredWidth / 7 / 3 * 2) + this.labelPadding);
                height = heightMode == Integer.MIN_VALUE ? Math.min(heightSize, totalHeight) : totalHeight;
            }
            this.setMeasuredDimension(width, height);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float itemWithPadding = (float)this.weekWidth + this.dividerSize;
        int saveCount = canvas.getSaveCount();
        canvas.save();
        int weekOffset = this.getSelectedWeek() - 1;
        float position = itemWithPadding * (float)weekOffset;
        canvas.translate(position, (float)this.getPaddingTop());
        for (int i = 0; i < 3; ++i) {
            this.drawWeek(canvas, i * 7, weekOffset + i);
            canvas.translate(itemWithPadding, 0.0f);
        }
        canvas.restoreToCount(saveCount);
    }

    private void drawWeek(Canvas canvas, int layoutIndex, int weekOffset) {
        int saveCount = canvas.save();
        int labelHeight = this.dayLabelLayouts[0].getHeight();
        float circleRadius = this.dayWidth / 3;
        int centerY = this.layouts[0].getHeight() / 2;
        float dateLineOffset = circleRadius - (float)centerY;
        for (int i = 0; i < 7; ++i) {
            int itemIndex = weekOffset * 7 + i;
            BoringLayout layout = this.layouts[layoutIndex + i];
            BoringLayout labelLayout = this.dayLabelLayouts[i];
            this.dayLabelTextPain.setColor(this.getTextColor(this.dayLabelTextColor, itemIndex));
            labelLayout.draw(canvas);
            this.dayTextPaint.setColor(this.getTextColor(this.dayTextColor, itemIndex));
            int count = canvas.save();
            canvas.translate(0.0f, (float)labelHeight + dateLineOffset + this.labelPadding);
            if (this.dayDrawable != null) {
                this.dayDrawable.setBounds(this.backgroundRect);
                this.dayDrawable.setState(this.getItemDrawableState(itemIndex));
                this.dayDrawable.draw(canvas);
            }
            if (this.indicatorDrawable != null && this.dayIndicators.get(itemIndex, false)) {
                this.indicatorDrawable.setBounds(this.indicatorRect);
                this.indicatorDrawable.setState(this.getItemDrawableState(itemIndex));
                this.indicatorDrawable.draw(canvas);
            }
            layout.draw(canvas);
            canvas.restoreToCount(count);
            canvas.translate((float)this.dayWidth, 0.0f);
        }
        canvas.restoreToCount(saveCount);
    }

    private LocalDate getRelativeFirstDay(int weekOffset) {
        weekOffset = this.getSelectedWeek() + weekOffset;
        return this.getFirstDay(weekOffset);
    }

    private LocalDate getFirstDay(int weekOffset) {
        return this.today.plusWeeks((long)weekOffset).with(TemporalAdjusters.previousOrSame((DayOfWeek)this.firstDayOfWeek));
    }

    @TargetApi(value=17)
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.textDir = this.getTextDirectionHeuristic();
    }

    private TextDirectionHeuristicCompat getTextDirectionHeuristic() {
        if (Build.VERSION.SDK_INT < 17) {
            return TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        }
        boolean defaultIsRtl = this.getLayoutDirection() == 1;
        switch (this.getTextDirection()) {
            default: {
                return defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
            }
            case 2: {
                return TextDirectionHeuristicsCompat.ANYRTL_LTR;
            }
            case 3: {
                return TextDirectionHeuristicsCompat.LTR;
            }
            case 4: {
                return TextDirectionHeuristicsCompat.RTL;
            }
            case 5: 
        }
        return TextDirectionHeuristicsCompat.LOCALE;
    }

    private void remakeLayout() {
        if (this.getWidth() > 0) {
            LocalDate day = this.getRelativeFirstDay(-1);
            for (int i = 0; i < this.layouts.length; ++i) {
                String dayText = String.valueOf(day.getDayOfMonth());
                if (this.layouts[i] == null) {
                    this.layouts[i] = BoringLayout.make((CharSequence)dayText, (TextPaint)this.dayTextPaint, (int)this.dayWidth, (Layout.Alignment)Layout.Alignment.ALIGN_CENTER, (float)1.0f, (float)1.0f, (BoringLayout.Metrics)this.dayMetrics, (boolean)false, (TextUtils.TruncateAt)this.ellipsize, (int)this.dayWidth);
                } else {
                    this.layouts[i].replaceOrMake((CharSequence)dayText, this.dayTextPaint, this.dayWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, this.dayMetrics, false, this.ellipsize, this.dayWidth);
                }
                day = day.plusDays(1L);
            }
            DayOfWeek dayOfWeek = this.firstDayOfWeek;
            for (int i = 0; i < this.dayLabelLayouts.length; ++i) {
                CharSequence name;
                if (this.labelNames == null) {
                    name = dayOfWeek.getDisplayName(TextStyle.SHORT, Locale.getDefault());
                } else {
                    int index = dayOfWeek.getValue() - 1;
                    name = this.labelNames[index];
                }
                if (this.dayLabelLayouts[i] == null) {
                    this.dayLabelLayouts[i] = BoringLayout.make((CharSequence)name, (TextPaint)this.dayLabelTextPain, (int)this.dayWidth, (Layout.Alignment)Layout.Alignment.ALIGN_CENTER, (float)1.0f, (float)1.0f, (BoringLayout.Metrics)this.dayLabelMetrics, (boolean)false, (TextUtils.TruncateAt)this.ellipsize, (int)this.dayWidth);
                } else {
                    this.dayLabelLayouts[i].replaceOrMake(name, this.dayLabelTextPain, this.dayWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, this.dayLabelMetrics, false, this.ellipsize, this.dayWidth);
                }
                dayOfWeek = dayOfWeek.plus(1L);
            }
        }
    }

    private int getTextColor(ColorStateList color, int item) {
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(16842910);
        if (this.isItemaPressed(item)) {
            states.add(16842919);
        }
        if (this.isItemSelected(item)) {
            states.add(0x10100A1);
        }
        int[] finalState = new int[states.size()];
        if (states.size() > 0) {
            for (int i = 0; i < states.size(); ++i) {
                finalState[i] = (Integer)states.get(i);
            }
        }
        return color.getColorForState(finalState, color.getDefaultColor());
    }

    private int[] getItemDrawableState(int item) {
        if (this.isItemSelected(item)) {
            return new int[]{0x10100A1, 16842910};
        }
        if (this.isItemaPressed(item)) {
            return new int[]{16842919, 16842910};
        }
        return new int[]{16842910};
    }

    private boolean isItemaPressed(int item) {
        return item == this.pressedDay;
    }

    private boolean isItemSelected(int item) {
        return item == this.selectedDay;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.calculateItemSize(w, h);
        this.calculateBackgroundRect();
        this.calculateIndicatorRect();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        int action = event.getActionMasked();
        switch (action) {
            case 2: {
                float currentMoveX = event.getX();
                int deltaMoveX = (int)(this.lastDownEventX - currentMoveX);
                if (!this.scrollingX && Math.abs(deltaMoveX) <= this.touchSlop) break;
                if (!this.scrollingX) {
                    deltaMoveX = 0;
                    this.pressedDay = Integer.MIN_VALUE;
                    this.scrollingX = true;
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.scrollPositionStart = this.getScrollX();
                }
                this.scrollBy(deltaMoveX, 0);
                this.lastDownEventX = currentMoveX;
                this.invalidate();
                break;
            }
            case 0: {
                if (!this.adjustScrollerX.isFinished()) {
                    this.adjustScrollerX.forceFinished(true);
                } else if (!this.flingScrollerX.isFinished()) {
                    this.flingScrollerX.forceFinished(true);
                } else {
                    this.scrollingX = false;
                }
                this.lastDownEventX = event.getX();
                if (!this.scrollingX) {
                    this.pressedDay = this.getDayPositionFromTouch(event.getX());
                }
                this.invalidate();
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.velocityTracker;
                velocityTracker.computeCurrentVelocity(500, (float)this.maximumFlingVelocity);
                int initialVelocityX = (int)velocityTracker.getXVelocity();
                if (this.scrollingX && Math.abs(initialVelocityX) > this.minimumFlingVelocity) {
                    this.flingX(initialVelocityX);
                } else {
                    float positionX = event.getX();
                    if (!this.scrollingX) {
                        int itemPos = this.getDayPositionFromTouch(positionX);
                        this.selectDay(itemPos);
                    } else if (this.scrollingX) {
                        this.finishScrolling();
                    }
                }
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
            case 3: {
                this.pressedDay = Integer.MIN_VALUE;
                this.invalidate();
            }
        }
        return true;
    }

    public void selectDay(@NonNull LocalDate date) {
        int day = this.getDayForDate(date);
        this.selectDay(day);
    }

    private void selectDay(int day) {
        if (this.selectedDay != day) {
            this.selectedDay = day;
            if (this.onDateSelected != null) {
                final LocalDate date = this.firstDay.plusDays((long)day);
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        WeekDatePicker.this.onDateSelected.onDateSelected(date);
                    }
                });
            }
            this.invalidate();
        }
        int week = this.selectedDay / 7;
        if (this.selectedDay < 0 && this.selectedDay % 7 != 0) {
            --week;
        }
        if (week != this.selectedWeek) {
            this.adjustToNearestWeekX(week);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyDown(keyCode, event);
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                return true;
            }
            case 21: {
                this.smoothScrollBy(-1);
                return true;
            }
            case 22: {
                this.smoothScrollBy(1);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void computeScroll() {
        this.computeScrollX();
    }

    public void getFocusedRect(Rect r) {
        super.getFocusedRect(r);
    }

    public void setOnWeekChangedListener(OnWeekChanged onWeekChanged) {
        this.onWeekChanged = onWeekChanged;
    }

    public void setOnDateSelectedListener(OnDateSelected onDateSelected) {
        this.onDateSelected = onDateSelected;
    }

    public int getSelectedWeek() {
        int x = this.getScrollX();
        return this.getWeekPositionFromCoordinates(x);
    }

    public void scrollToWeek(int index) {
        this.selectedWeek = index;
        this.scrollToItem(index);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.scrollToWeek(ss.mSelItem);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mSelItem = this.selectedWeek;
        return savedState;
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.ellipsize;
    }

    public void setEllipsize(TextUtils.TruncateAt ellipsize) {
        if (this.ellipsize != ellipsize) {
            this.ellipsize = ellipsize;
            this.remakeLayout();
            this.invalidate();
        }
    }

    public void setDateIndicator(@NonNull LocalDate date, boolean enabled) {
        int itemIndex = this.getDayForDate(date);
        if (enabled) {
            this.dayIndicators.put(itemIndex, true);
        } else {
            this.dayIndicators.delete(itemIndex);
        }
    }

    private int getDayForDate(@NonNull LocalDate date) {
        return this.firstDay.until((ChronoLocalDate)date).getDays();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.getWeekPositionFromCoordinates(l) != this.getWeekPositionFromCoordinates(oldl)) {
            this.remakeLayout();
        }
    }

    private int getDayPositionFromTouch(float x) {
        int weekPositionFromTouch = this.getWeekPositionFromTouch(x);
        int position = weekPositionFromTouch * 7 + this.getRelativeDayPositionFromTouch(x);
        if (weekPositionFromTouch < 0) {
            position += 6;
        }
        return position;
    }

    private int getRelativeDayPositionFromTouch(float x) {
        return this.getRelativeDayPositionFromCoordinates((int)((float)this.getScrollX() + x));
    }

    private int getWeekPositionFromTouch(float x) {
        return this.getWeekPositionFromCoordinates((int)((float)this.getScrollX() - ((float)this.weekWidth + this.dividerSize) * 0.5f + x));
    }

    private int getRelativeDayPositionFromCoordinates(int x) {
        float relativePosition = (float)x % ((float)this.weekWidth + this.dividerSize);
        return (int)(relativePosition / (float)this.dayWidth);
    }

    private void computeScrollX() {
        OverScroller scroller = this.flingScrollerX;
        if (scroller.isFinished() && (scroller = this.adjustScrollerX).isFinished()) {
            return;
        }
        if (scroller.computeScrollOffset()) {
            int currentScrollerX = scroller.getCurrX();
            if (this.previousScrollerX == Integer.MIN_VALUE) {
                this.previousScrollerX = scroller.getStartX();
            }
            this.scrollBy(currentScrollerX - this.previousScrollerX, 0);
            this.previousScrollerX = currentScrollerX;
            if (scroller.isFinished()) {
                this.onScrollerFinishedX(scroller);
            }
            this.postInvalidate();
        }
    }

    private void flingX(int velocityX) {
        int finalPosition;
        int signum = Integer.signum(velocityX);
        int currentWeekPosition = this.getWeekPositionFromCoordinates(this.scrollPositionStart);
        float weekWidth = (float)this.weekWidth + this.dividerSize;
        switch (signum) {
            case -1: {
                finalPosition = (int)weekWidth * (currentWeekPosition + 1);
                break;
            }
            default: {
                finalPosition = (int)weekWidth * currentWeekPosition;
                break;
            }
            case 1: {
                finalPosition = (int)weekWidth * (currentWeekPosition - 1);
            }
        }
        int dx = finalPosition - this.getScrollX();
        this.previousScrollerX = Integer.MIN_VALUE;
        this.flingScrollerX.startScroll(this.getScrollX(), this.getScrollY(), dx, 0);
        this.invalidate();
    }

    private void adjustToNearestWeekX() {
        int x = this.getScrollX();
        int week = Math.round((float)x / ((float)this.weekWidth + this.dividerSize * 1.0f));
        this.adjustToNearestWeekX(week);
    }

    private void adjustToNearestWeekX(int week) {
        int x = this.getScrollX();
        if (this.selectedWeek != week) {
            this.selectedWeek = week;
            this.notifyWeekChange();
        }
        int weekPosition = (this.weekWidth + (int)this.dividerSize) * week;
        int deltaX = weekPosition - x;
        this.previousScrollerX = Integer.MIN_VALUE;
        this.adjustScrollerX.startScroll(x, 0, deltaX, 0, 800);
        this.invalidate();
    }

    private void calculateItemSize(int w, int h) {
        int items = 1;
        int totalPadding = (int)this.dividerSize * (items - 1);
        this.weekWidth = (w - totalPadding) / items;
        this.dayWidth = this.weekWidth / 7;
        this.scrollToItem(this.selectedWeek);
        this.buildFontMetrics();
        this.buildLabelFontMetrics();
        this.remakeLayout();
    }

    private void calculateBackgroundRect() {
        if (this.dayDrawable != null) {
            float circleRadius = this.dayWidth / 3;
            int centerX = this.layouts[0].getWidth() / 2;
            int centerY = this.layouts[0].getHeight() / 2;
            this.backgroundRect = new Rect((int)((float)centerX - circleRadius), (int)((float)centerY - circleRadius), (int)((float)centerX + circleRadius), (int)((float)centerY + circleRadius));
        } else {
            this.backgroundRect = null;
        }
    }

    private void calculateIndicatorRect() {
        if (this.indicatorDrawable != null) {
            float circleRadius = this.dayWidth / 3;
            int centerX = this.layouts[0].getWidth() / 2;
            int centerY = this.layouts[0].getHeight() / 2;
            int indicatorDotWidth = this.indicatorDrawable.getIntrinsicWidth();
            int indicatorDotHeight = this.indicatorDrawable.getIntrinsicHeight();
            this.indicatorRect = new Rect(centerX - indicatorDotWidth / 2, (int)((float)centerY + circleRadius - (float)indicatorDotHeight), centerX + indicatorDotWidth / 2, (int)((float)centerY + circleRadius));
        } else {
            this.indicatorRect = null;
        }
    }

    private void onScrollerFinishedX(OverScroller scroller) {
        if (scroller == this.flingScrollerX) {
            this.finishScrolling();
        }
    }

    private void finishScrolling() {
        this.adjustToNearestWeekX();
        this.scrollingX = false;
    }

    private int getPositionOnScreen(float x) {
        return (int)(x / ((float)this.weekWidth + this.dividerSize));
    }

    private void smoothScrollBy(int i) {
        int deltaMoveX = (this.weekWidth + (int)this.dividerSize) * i;
        this.previousScrollerX = Integer.MIN_VALUE;
        this.flingScrollerX.startScroll(this.getScrollX(), 0, deltaMoveX, 0);
        this.invalidate();
    }

    private void setTextSize(float size) {
        if (size != this.dayTextPaint.getTextSize()) {
            this.dayTextPaint.setTextSize(size);
            this.buildFontMetrics();
            this.requestLayout();
            this.invalidate();
        }
    }

    private void setLabelTextSize(float size) {
        if (size != this.dayLabelTextPain.getTextSize()) {
            this.dayLabelTextPain.setTextSize(size);
            this.buildLabelFontMetrics();
            this.remakeLayout();
            this.invalidate();
        }
    }

    private int getWeekPositionFromCoordinates(int x) {
        return Math.round((float)x / ((float)this.weekWidth + this.dividerSize));
    }

    private void scrollToItem(int index) {
        this.scrollTo((this.weekWidth + (int)this.dividerSize) * index, 0);
    }

    private void notifyWeekChange() {
        if (this.onWeekChanged != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    LocalDate firstDay = WeekDatePicker.this.getFirstDay(WeekDatePicker.this.getWeekPositionFromCoordinates(WeekDatePicker.this.getScrollX()));
                    WeekDatePicker.this.onWeekChanged.onItemSelected(firstDay);
                }
            });
        }
    }

    private void buildFontMetrics() {
        Paint.FontMetricsInt fontMetricsInt = this.dayTextPaint.getFontMetricsInt();
        this.dayMetrics = WeekDatePicker.toBoringFontMetrics(fontMetricsInt, this.dayMetrics);
        this.dayMetrics.width = this.weekWidth;
    }

    private void buildLabelFontMetrics() {
        Paint.FontMetricsInt fontMetricsInt = this.dayLabelTextPain.getFontMetricsInt();
        this.dayLabelMetrics = WeekDatePicker.toBoringFontMetrics(fontMetricsInt, this.dayLabelMetrics);
        this.dayLabelMetrics.width = this.weekWidth;
    }

    private static BoringLayout.Metrics toBoringFontMetrics(Paint.FontMetricsInt metrics, @Nullable BoringLayout.Metrics fontMetrics) {
        if (fontMetrics == null) {
            fontMetrics = new BoringLayout.Metrics();
        }
        fontMetrics.ascent = metrics.ascent;
        fontMetrics.bottom = metrics.bottom;
        fontMetrics.descent = metrics.descent;
        fontMetrics.leading = metrics.leading;
        fontMetrics.top = metrics.top;
        return fontMetrics;
    }

    public static class SavedState
    extends View.BaseSavedState {
        private int mSelItem;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSelItem = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelItem);
        }

        public String toString() {
            return "HorizontalPicker.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selItem=" + this.mSelItem + "}";
        }
    }

    public static interface OnDateSelected {
        public void onDateSelected(LocalDate var1);
    }

    public static interface OnWeekChanged {
        public void onItemSelected(LocalDate var1);
    }
}

