/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.WorkerThread;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestListener;

public abstract class RequestTask<T>
implements Runnable {
    protected final RequestListener<T> listener;

    RequestTask(RequestListener<T> listener) {
        this.listener = listener;
    }

    @Override
    @WorkerThread
    public final void run() {
        this.onPreExecute();
        try {
            this.onSuccess(this.execute());
        }
        catch (RequestException e) {
            this.onFailed(e);
        }
        this.onPostExecute();
    }

    @WorkerThread
    protected void onPreExecute() {
    }

    @WorkerThread
    protected abstract T execute() throws RequestException;

    @WorkerThread
    protected abstract void onSuccess(T var1);

    @WorkerThread
    protected abstract void onFailed(RequestException var1);

    @WorkerThread
    protected void onPostExecute() {
    }

    @WorkerThread
    protected void onCancelled() {
    }
}

