/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.serialization;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import software.rsquared.restapi.exceptions.DefaultErrorResponse;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.serialization.ErrorDeserializer;

public class JsonErrorDeserializer
implements ErrorDeserializer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Config config;

    public JsonErrorDeserializer() {
        this(new Config());
    }

    public JsonErrorDeserializer(Config config) {
        this.config = config;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        this.objectMapper.registerModule((Module)module);
    }

    @Override
    public RequestException deserialize(int responseCode, String content) throws IOException {
        DefaultErrorResponse value = (DefaultErrorResponse)this.objectMapper.readerFor(this.config.errorClass).readValue(content);
        return new RequestException(responseCode, value.getName(), value.getMessage(), value.getErrorCode(), value.getErrors());
    }

    public static class Config {
        private Class<? extends DefaultErrorResponse> errorClass = DefaultErrorResponse.class;

        public Config setErrorClass(Class<? extends DefaultErrorResponse> errorClass) {
            this.errorClass = errorClass;
            return this;
        }
    }
}

