/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.AnyThread;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.exceptions.RequestException;

class ThreadPoolRequest
extends PoolRequest {
    private Map<Integer, Object> results = new LinkedHashMap<Integer, Object>();

    ThreadPoolRequest() {
    }

    @Override
    @AnyThread
    public void execute() {
        this.onPreExecute();
        for (Map.Entry entry : this.requestPool.entrySet()) {
            Integer requestCode = (Integer)entry.getKey();
            Request request = (Request)entry.getValue();
            this.onPreExecute();
            request.execute(this.api, new PoolRequest.PoolRequestListener((int)requestCode){

                @Override
                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    ThreadPoolRequest.this.onTaskSuccess(result, requestCode);
                    ThreadPoolRequest.this.results.put(requestCode, result);
                    ThreadPoolRequest.this.checkFinished(false);
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    ThreadPoolRequest.this.onFailed(e, requestCode);
                    if (ThreadPoolRequest.this.canContinueAfterFailed(e, requestCode)) {
                        ThreadPoolRequest.this.results.put(requestCode, null);
                        ThreadPoolRequest.this.checkFinished(false);
                    } else {
                        ThreadPoolRequest.this.checkFinished(true);
                    }
                }

                @Override
                public void onCanceled() {
                    if (!ThreadPoolRequest.this.cancelled.get()) {
                        ThreadPoolRequest.this.cancel();
                    }
                }
            });
        }
    }

    private void checkFinished(boolean forceCancel) {
        if (!this.cancelled.get()) {
            boolean allFinished;
            boolean bl = allFinished = this.results.size() == this.requestPool.size();
            if (allFinished) {
                this.onSuccess(this.results);
                this.onPostExecute();
            } else if (forceCancel) {
                this.cancel();
                this.onPostExecute();
            }
        }
    }
}

