/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import java.util.ArrayList;
import java.util.List;
import software.rsquared.restapi.Authorizable;
import software.rsquared.restapi.Request;

public abstract class RequestAuthenticator {
    private final List<Pair<String, Object>> parameters = new ArrayList<Pair<String, Object>>();
    private final List<Pair<String, Object>> queryParameters = new ArrayList<Pair<String, Object>>();
    private final List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();

    protected boolean isAuthorizable(Request request) {
        return request instanceof Authorizable;
    }

    synchronized void checkAndAdd(Request request) {
        this.checkAuthorization(request);
        this.clean();
        this.addAuthorization();
    }

    private void clean() {
        this.parameters.clear();
        this.queryParameters.clear();
        this.headers.clear();
    }

    protected abstract void checkAuthorization(Request var1);

    protected abstract void addAuthorization();

    protected final void putParameter(@NonNull String name, @Nullable Object value) {
        this.parameters.add((Pair<String, Object>)new Pair((Object)name, value));
    }

    protected final void putParameter(@Nullable Object value) {
        this.parameters.add((Pair<String, Object>)new Pair(null, value));
    }

    protected final void addHeader(@NonNull String name, @NonNull String value) {
        this.headers.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    protected final void putQueryParameter(@NonNull String name, @Nullable Object value) {
        this.queryParameters.add((Pair<String, Object>)new Pair((Object)name, value));
    }

    protected final void putQueryParameter(@Nullable Object value) {
        this.queryParameters.add((Pair<String, Object>)new Pair(null, value));
    }

    final List<Pair<String, Object>> getParameters() {
        return this.parameters;
    }

    final List<Pair<String, Object>> getQueryParameters() {
        return this.queryParameters;
    }

    final List<Pair<String, String>> getHeaders() {
        return this.headers;
    }
}

