/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.net.Uri;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import software.rsquared.restapi.Authorizable;
import software.rsquared.restapi.BasicAuth;
import software.rsquared.restapi.Checker;
import software.rsquared.restapi.HeaderFactory;
import software.rsquared.restapi.MockFactory;
import software.rsquared.restapi.Parameter;
import software.rsquared.restapi.RequestAuthenticator;
import software.rsquared.restapi.RequestTask;
import software.rsquared.restapi.RequestTypeReference;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.RestApiLogger;
import software.rsquared.restapi.RestApiUtils;
import software.rsquared.restapi.RestObject;
import software.rsquared.restapi.Timer;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.ErrorCallback;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.JsonSerializer;
import software.rsquared.restapi.serialization.Serializer;

public abstract class Request<T> {
    public static final MediaType MULTIPART_FORM_DATA = MediaType.parse((String)"multipart/form-data");
    public static final MediaType APPLICATION_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    public static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String KEY_BASIC_AUTHORIZATION = "BasicAuth";
    @NonNull
    private final HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
    @Nullable
    private HttpUrl url;
    @NonNull
    private final List<Parameter> bodyParameters = new ArrayList<Parameter>();
    @NonNull
    private final List<Parameter> queryParameters = new ArrayList<Parameter>();
    @NonNull
    private final Map<String, String> headerMap = new HashMap<String, String>();
    @NonNull
    private final Timer timer = new Timer();
    private long minExecutionTime = 0L;
    @Nullable
    private String logParameters;
    @Nullable
    private final String logCreateCodeLine;
    private AtomicBoolean executed = new AtomicBoolean(false);
    private T result;
    private RestApi api;
    @Nullable
    private RequestTask<T> task;
    @Nullable
    private Call requestCall;
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private OkHttpClient httpClient;

    protected Request() {
        this.logCreateCodeLine = RestApiUtils.getClassCodeLine(this.getClass().getName());
    }

    @AnyThread
    protected void execute(RestApi api, RequestListener<T> listener) {
        RequestTask<T> task = this.beforeExecution(api, listener);
        this.executeTask(api, task);
    }

    @WorkerThread
    protected T executeSync(RestApi api) throws RequestException {
        RequestTask<T> task = this.beforeExecution(api, null);
        this.executeTaskSync(task);
        return this.result;
    }

    protected RequestTask<T> beforeExecution(RestApi api, RequestListener<T> listener) {
        if (this.executed.compareAndSet(false, true)) {
            this.api = api;
            return this.createTask(listener);
        }
        throw new IllegalStateException("Request currently executed!");
    }

    @WorkerThread
    private void executeTaskSync(RequestTask<T> task) throws RequestException {
        task.onPreExecute();
        try {
            task.onSuccess(task.execute());
        }
        catch (RequestException e) {
            task.onFailed(e);
            throw e;
        }
        task.onPostExecute();
    }

    @AnyThread
    private void executeTask(RestApi api, RequestTask<T> task) {
        if (api.getNetworkExecutor() == null) {
            throw new IllegalStateException("NetworkExecutor is required!");
        }
        api.getNetworkExecutor().execute(task);
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            if (this.task != null) {
                this.task.onCancelled();
            }
            if (this.requestCall != null) {
                this.requestCall.cancel();
            }
        } else {
            this.getLogger().debug(this.logCreateCodeLine, "Already cancelled");
        }
    }

    @NonNull
    protected RequestTask<T> createTask(@Nullable RequestListener<T> listener) {
        return new RequestTask<T>(listener){

            @Override
            protected void onPreExecute() {
                Executor uiExecutor = Request.this.api.getUiExecutor();
                if (this.listener != null) {
                    uiExecutor.execute(this.listener::onPreExecute);
                }
            }

            @Override
            protected T execute() throws RequestException {
                Request.this.timer.start();
                Request.this.result = Request.this.executeRequest();
                Request.this.waitForMinExecutionTime();
                Request.this.getLogger().debug(Request.this.logCreateCodeLine, String.format(Locale.getDefault(), "Execution of " + Request.this.getClassName() + " took: %.3fms", Request.this.timer.getElapsedTime()));
                return Request.this.result;
            }

            @Override
            protected void onSuccess(T result) {
                Executor uiExecutor = Request.this.api.getUiExecutor();
                if (this.listener != null) {
                    uiExecutor.execute(() -> this.listener.onSuccess(result));
                }
            }

            @Override
            protected void onFailed(RequestException e) {
                ErrorCallback errorCallback = Request.this.api.getErrorCallback();
                if (errorCallback != null && errorCallback.onError(Request.this, e)) {
                    return;
                }
                Executor uiExecutor = Request.this.api.getUiExecutor();
                if (this.listener != null) {
                    uiExecutor.execute(() -> this.listener.onFailed(e));
                }
            }

            @Override
            protected void onPostExecute() {
                Executor uiExecutor = Request.this.api.getUiExecutor();
                if (this.listener != null) {
                    uiExecutor.execute(this.listener::onPostExecute);
                }
            }

            @Override
            protected void onCancelled() {
                Executor uiExecutor = Request.this.api.getUiExecutor();
                if (this.listener != null) {
                    uiExecutor.execute(this.listener::onCanceled);
                }
            }
        };
    }

    protected T executeRequest() throws RequestException {
        this.computeCheckers();
        this.result = this.getMockResponse(this.api.getMockFactory());
        if (this.result != null) {
            this.getLogger().debug(this.logCreateCodeLine, "Mocked response");
        } else {
            this.setUrl();
            HeaderFactory headerFactory = this.api.getHeaderFactory();
            if (headerFactory != null) {
                this.headerMap.putAll(headerFactory.getHeaders(this));
            }
            this.prepareRequest();
            this.computeAuthenticator();
            this.buildUrl();
            if (!this.cancelled.get()) {
                this.httpClient = this.createHttpClient();
                this.requestCall = this.createRequest(this.httpClient, this.url, this.headerMap, this.getRequestBody());
                this.getLogger().debug(this.logCreateCodeLine, "Start execution " + this.getClassName() + ":\n" + this.url + "\n" + this.logParameters);
                if (!this.cancelled.get()) {
                    try (Response response = this.requestCall.execute();){
                        this.result = this.readResponse(response);
                    }
                    catch (IOException e) {
                        throw new RequestException(e);
                    }
                }
            }
        }
        return this.result;
    }

    protected void computeCheckers() throws RequestException {
        List<Checker> checkers = this.api.getCheckerList();
        for (Checker checker : checkers) {
            checker.check(this);
        }
    }

    protected void computeAuthenticator() {
        RequestAuthenticator authenticator = this.api.getRequestAuthenticator();
        if (authenticator == null || !authenticator.isAuthorizable(this)) {
            return;
        }
        authenticator.checkAndAdd(this);
        for (Pair<String, Object> pair : authenticator.getQueryParameters()) {
            if (pair.first == null) {
                this.putQueryParameter(pair.second);
                continue;
            }
            this.putQueryParameter((String)pair.first, pair.second);
        }
        for (Pair<String, Object> pair : authenticator.getParameters()) {
            if (pair.first == null) {
                this.putParameter(pair.second);
                continue;
            }
            this.putParameter((String)pair.first, pair.second);
        }
        for (Pair<String, Object> pair : authenticator.getHeaders()) {
            this.addHeader((String)pair.first, (String)pair.second);
        }
    }

    protected boolean isAuthorizable() {
        return this instanceof Authorizable;
    }

    protected T getMockResponse(MockFactory mockFactory) {
        return mockFactory == null ? null : (T)mockFactory.getMockResponse(this);
    }

    private void setUrl() {
        this.setUrl(this.api.getUrl());
        BasicAuth basicAuth = this.api.getBasicAuth();
        if (basicAuth != null) {
            this.setBasicAuthorization(basicAuth.getUser(), basicAuth.getPassword());
        }
    }

    protected void buildUrl() {
        for (Parameter param : this.queryParameters) {
            this.urlBuilder.addQueryParameter(param.getName(), String.valueOf(param.getValue()));
        }
        this.url = this.urlBuilder.build();
    }

    protected void setUrl(@NonNull String url) {
        String fragment;
        Set parameterNames;
        List segments;
        String[] parts;
        Uri uri = Uri.parse((String)url);
        this.setScheme(uri.getScheme());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        String userInfo = uri.getUserInfo();
        if (!TextUtils.isEmpty((CharSequence)userInfo) && (parts = userInfo.split(":", 2)).length > 1) {
            this.setBasicAuthorization(parts[0], parts[1]);
        }
        if ((segments = uri.getPathSegments()) != null) {
            for (Object segment : segments) {
                this.urlBuilder.addPathSegment((String)segment);
            }
        }
        if ((parameterNames = uri.getQueryParameterNames()) != null) {
            for (String name : parameterNames) {
                this.urlBuilder.setQueryParameter(name, uri.getQueryParameter(name));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(fragment = uri.getFragment()))) {
            this.setFragment(fragment);
        }
    }

    protected void setScheme(String scheme) {
        this.urlBuilder.scheme(scheme);
    }

    protected void setBasicAuthorization(String username, String password) {
        this.urlBuilder.username(username);
        this.urlBuilder.password(password);
    }

    protected void setHost(String host) {
        this.urlBuilder.host(host);
    }

    protected void setPort(int port) {
        if (port > 0) {
            this.urlBuilder.port(port);
        }
    }

    protected void setFragment(String fragment) {
        this.urlBuilder.fragment(fragment);
    }

    protected void addPathSegments(String ... segments) {
        if (segments != null) {
            for (String segment : segments) {
                this.urlBuilder.addPathSegment(segment);
            }
        }
    }

    protected void putQueryParameter(@NonNull String name, @Nullable Object value) {
        this.getSerializer().serialize(this.queryParameters, name, value);
    }

    protected void putQueryParameter(@Nullable Object value) {
        String name = this.getNameFor(value);
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new RuntimeException("Unknown name!");
        }
        this.getSerializer().serialize(this.queryParameters, name, value);
    }

    void putParameter(@NonNull String name, @Nullable Object value) {
        this.getSerializer().serialize(this.bodyParameters, name, value);
    }

    void putParameter(@Nullable Object value) {
        String name = this.getNameFor(value);
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new RuntimeException("Unknown name!");
        }
        this.getSerializer().serialize(this.bodyParameters, name, value);
    }

    protected String getNameFor(Object object) {
        if (this.isRestObject(object)) {
            return this.getRestObjectName(object);
        }
        return null;
    }

    private boolean isRestObject(Object object) {
        return object != null && object.getClass().getAnnotation(RestObject.class) != null;
    }

    private String getRestObjectName(Object object) {
        RestObject restObject = object.getClass().getAnnotation(RestObject.class);
        if (!TextUtils.isEmpty((CharSequence)restObject.value())) {
            return restObject.value();
        }
        return object.getClass().getSimpleName();
    }

    protected void addHeader(@NonNull String name, @NonNull String value) {
        this.headerMap.put(name, value);
    }

    protected void removeParameter(@NonNull String key) {
        Iterator<Parameter> iterator = this.bodyParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!key.equals(parameter.getName())) continue;
            iterator.remove();
            return;
        }
    }

    protected void removeQueryParameter(@NonNull String key) {
        Iterator<Parameter> iterator = this.queryParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!key.equals(parameter.getName())) continue;
            iterator.remove();
            return;
        }
    }

    @Nullable
    protected RequestBody getRequestBody() {
        MediaType mediaType = this.getMediaType();
        if (MULTIPART_FORM_DATA.equals((Object)mediaType)) {
            return this.getMultipartBody();
        }
        if (APPLICATION_URLENCODED.equals((Object)mediaType)) {
            return this.getFormBody();
        }
        if (APPLICATION_JSON.equals((Object)mediaType)) {
            return this.getJsonBody();
        }
        throw new IllegalStateException("Unsupported media type: " + mediaType.toString());
    }

    protected MediaType getMediaType() {
        if (this.isMultipartRequest()) {
            return MULTIPART_FORM_DATA;
        }
        if (this.getSerializer() instanceof JsonSerializer) {
            return APPLICATION_JSON;
        }
        return APPLICATION_URLENCODED;
    }

    protected boolean isMultipartRequest() {
        for (Parameter parameter : this.bodyParameters) {
            if (!parameter.isFile()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    protected RequestBody getMultipartBody() {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MULTIPART_FORM_DATA);
        StringBuilder parametersStringBuilder = new StringBuilder();
        Iterator<Parameter> iterator = this.bodyParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!parameter.isFile()) continue;
            String name = parameter.getName();
            String path = parameter.getFilePath();
            this.appendParameterWithNewLine(parametersStringBuilder, name, path);
            File file = new File(path);
            if (file.exists()) {
                bodyBuilder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)("image/" + this.getFileExtension(file))), (File)file));
            }
            iterator.remove();
        }
        for (Parameter parameter : this.bodyParameters) {
            String name = parameter.getName();
            String value = String.valueOf(parameter.getValue());
            this.appendParameterWithNewLine(parametersStringBuilder, name, value);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            bodyBuilder.addFormDataPart(name, value);
        }
        this.logParameters = parametersStringBuilder.toString();
        return bodyBuilder.build();
    }

    private String getFileExtension(@NonNull File file) {
        String fileName = file.getName();
        int beginIndex = fileName.lastIndexOf(".") + 1;
        if (beginIndex == 0) {
            return "*";
        }
        return fileName.substring(beginIndex);
    }

    @NonNull
    protected RequestBody getFormBody() {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        StringBuilder parametersStringBuilder = new StringBuilder();
        for (Parameter parameter : this.bodyParameters) {
            String name = parameter.getName();
            String value = String.valueOf(parameter.getValue());
            this.appendParameterWithNewLine(parametersStringBuilder, name, value);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            bodyBuilder.add(name, value);
        }
        this.logParameters = parametersStringBuilder.toString();
        return bodyBuilder.build();
    }

    protected RequestBody getJsonBody() {
        if (this.getSerializer() instanceof JsonSerializer) {
            String body;
            this.logParameters = body = ((JsonSerializer)this.getSerializer()).toJsonString(this.bodyParameters);
            return RequestBody.create((MediaType)APPLICATION_JSON, (String)body);
        }
        throw new IllegalStateException("Json media type requires JsonSerializer. Set JsonSerializer via RestApi.Config().setSerializer()");
    }

    private void appendParameterWithNewLine(StringBuilder parametersStringBuilder, String name, String value) {
        if (parametersStringBuilder.length() > 0) {
            parametersStringBuilder.append("\n");
        }
        parametersStringBuilder.append(name).append(": ").append(value);
    }

    protected abstract void prepareRequest();

    @NonNull
    @WorkerThread
    protected abstract Call createRequest(OkHttpClient var1, HttpUrl var2, Map<String, String> var3, RequestBody var4) throws RequestException;

    protected void waitForMinExecutionTime() {
        double time = this.timer.getElapsedTime();
        if (time < (double)this.minExecutionTime) {
            try {
                Thread.sleep((long)((double)this.minExecutionTime - time));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @NonNull
    protected OkHttpClient createHttpClient() {
        long timeout = this.api.getTimeout();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, timeout, TimeUnit.MILLISECONDS)).followSslRedirects(true).connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS);
        BasicAuth basicAuth = this.api.getBasicAuth();
        if (basicAuth != null) {
            clientBuilder.authenticator((route, response) -> {
                Request.Builder requestBuilder = response.request().newBuilder().header("Authorization", basicAuth.getCredentials());
                return requestBuilder.build();
            });
        }
        if (this.api.isEnableTls12OnPreLollipop()) {
            return RestApiUtils.enableTls12OnPreLollipop(clientBuilder).build();
        }
        return clientBuilder.build();
    }

    @NonNull
    protected String getClassName() {
        String name = this.getClass().getName();
        String[] parts = name.split("\\.");
        if (parts.length > 0 && !TextUtils.isEmpty((CharSequence)parts[parts.length - 1])) {
            String classPart = parts[parts.length - 1];
            return (parts = classPart.split("\\$")).length > 0 && !TextUtils.isEmpty((CharSequence)parts[parts.length - 1]) ? parts[parts.length - 1] : classPart;
        }
        return "Request";
    }

    protected T readResponse(Response response) throws RequestException, IOException {
        if (response == null) {
            return null;
        }
        int status = response.code();
        ResponseBody body = response.body();
        String content = null;
        if (body != null) {
            content = body.string();
        }
        this.getLogger().verbose(this.logCreateCodeLine, "Response from " + this.getClassName() + " (" + this.url + "):\n" + content);
        if (this.isSuccess(response)) {
            T result = this.readResult(content);
            this.readHeaders(response.headers(), result);
            return result;
        }
        throw this.getErrorDeserializer().deserialize(status, content);
    }

    protected T readResult(String content) throws IOException {
        return this.getDeserializer().deserialize(this.getClass(), this.getResultType(), content);
    }

    protected TypeReference<T> getResultType() {
        return new RequestTypeReference(this);
    }

    protected void readHeaders(Headers headers, T result) {
    }

    protected boolean isSuccess(Response response) {
        return this.api.getSuccessStatusCodes().contains(response.code());
    }

    protected void setMinExecutionTime(long millis) {
        this.minExecutionTime = millis;
    }

    protected Serializer getSerializer() {
        return this.api.getSerializer();
    }

    protected Deserializer getDeserializer() {
        return this.api.getDeserializer();
    }

    protected ErrorDeserializer getErrorDeserializer() {
        return this.api.getErrorDeserializer();
    }

    protected RestApiLogger getLogger() {
        return this.api.getLogger();
    }
}

