/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.SerialPoolRequest;
import software.rsquared.restapi.ThreadPoolRequest;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestListener;

public abstract class PoolRequest {
    public static final int THREAD_POOL_EXECUTOR = 1;
    public static final int SERIAL_EXECUTOR = 2;
    protected Map<Integer, Request> requestPool = new LinkedHashMap<Integer, Request>();
    protected AtomicBoolean executed = new AtomicBoolean(false);
    protected AtomicBoolean cancelled = new AtomicBoolean(false);
    @Nullable
    private software.rsquared.restapi.listeners.PoolRequestListener listener;
    protected RestApi api;

    protected PoolRequest() {
    }

    public static PoolRequest create(int executor) {
        switch (executor) {
            case 1: {
                return new ThreadPoolRequest();
            }
        }
        return new SerialPoolRequest();
    }

    public PoolRequest addTask(@NonNull Request request, int requestCode) {
        if (this.executed.get()) {
            throw new IllegalStateException("New task cannot be added to the pool after executing.");
        }
        if (this.requestPool.containsKey(requestCode)) {
            throw new IllegalArgumentException("Task with this requestCode (" + requestCode + ") was already added.");
        }
        this.requestPool.put(requestCode, request);
        return this;
    }

    protected void execute(RestApi api, @Nullable software.rsquared.restapi.listeners.PoolRequestListener listener) {
        if (!this.executed.compareAndSet(false, true)) {
            throw new IllegalStateException("Already executed.");
        }
        this.api = api;
        this.listener = listener;
        this.execute();
    }

    protected abstract void execute();

    protected void onPreExecute() {
        if (this.listener != null) {
            this.api.getUiExecutor().execute(() -> this.listener.onPreExecute());
        }
    }

    protected void onTaskSuccess(Object result, int requestCode) {
        if (this.listener != null) {
            this.listener.onTaskSuccess(result, requestCode);
        }
    }

    protected void onFailed(RequestException e, int requestCode) {
        if (this.listener != null) {
            this.api.getUiExecutor().execute(() -> this.listener.onFailed(e, requestCode));
        }
    }

    protected boolean canContinueAfterFailed(RequestException e, int requestCode) {
        return this.listener == null || this.listener.canContinueAfterFailed(e, requestCode);
    }

    protected void onCanceled() {
        if (this.listener != null) {
            this.api.getUiExecutor().execute(() -> this.listener.onCanceled());
        }
    }

    protected void onSuccess(Map<Integer, Object> results) {
        if (this.listener != null) {
            this.api.getUiExecutor().execute(() -> this.listener.onSuccess(results));
        }
    }

    protected void onPostExecute() {
        if (this.listener != null) {
            this.api.getUiExecutor().execute(() -> this.listener.onPostExecute());
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            for (Request request : this.requestPool.values()) {
                request.cancel();
            }
            this.onCanceled();
        }
    }

    protected abstract class PoolRequestListener
    implements RequestListener<Object> {
        private int requestCode;

        public PoolRequestListener(int requestCode) {
            this.requestCode = requestCode;
        }

        public int getRequestCode() {
            return this.requestCode;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PoolExecutor {
    }
}

