/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RequestExecutor;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;

abstract class PoolRequest<P extends PoolRequest> {
    protected Map<Integer, Request> requestPool = new LinkedHashMap<Integer, Request>();
    protected boolean executed;
    protected RequestExecutor executor;
    protected boolean cancelled;
    @Nullable
    private RequestPoolListener listener;
    private Handler handler;

    protected PoolRequest(int poolSize) {
        this.executor = new RequestExecutor(poolSize, 0L);
    }

    public P addTask(@NonNull Request request, int requestCode) {
        if (this.executed) {
            throw new IllegalStateException("New task cannot be added to the pool after executing.");
        }
        if (this.requestPool.containsKey(requestCode)) {
            throw new IllegalArgumentException("Task with this requestCode (" + requestCode + ") was already added.");
        }
        this.requestPool.put(requestCode, request);
        return (P)this;
    }

    @CallSuper
    public void execute(@Nullable RequestPoolListener listener) {
        this.listener = listener;
        this.execute();
    }

    public abstract void execute();

    protected void onPreExecute() {
        if (this.listener != null) {
            this.getHandler().post(() -> this.listener.onPreExecute());
        }
    }

    protected void onTaskSuccess(Object result, int requestCode) {
        if (this.listener != null) {
            this.getHandler().post(() -> this.listener.onTaskSuccess(result, requestCode));
        }
    }

    protected void onFailed(RequestException e, int requestCode) {
        if (this.listener != null) {
            this.getHandler().post(() -> this.listener.onFailed(e, requestCode));
        }
    }

    protected boolean canContinueAfterFailed(RequestException e, int requestCode) {
        return this.listener == null || this.listener.canContinueAfterFailed(e, requestCode);
    }

    protected void onCanceled() {
        if (this.listener != null) {
            this.getHandler().post(() -> this.listener.onCanceled());
        }
    }

    protected void onSuccess(Map<Integer, Object> results) {
        if (this.listener != null) {
            this.getHandler().post(() -> this.listener.onSuccess(results));
        }
    }

    protected void onPostExecute() {
        if (this.listener != null) {
            this.getHandler().post(() -> this.listener.onPostExecute());
        }
    }

    public void cancel() {
        this.stopExecute();
    }

    protected void stopExecute() {
        this.executor.shutdownNow();
    }

    @NonNull
    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    abstract class PoolRequestListener
    implements RequestListener<Object> {
        private int requestCode;

        public PoolRequestListener(int requestCode) {
            this.requestCode = requestCode;
        }

        public int getRequestCode() {
            return this.requestCode;
        }
    }
}

