/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.serialization;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.rsquared.restapi.Parameter;
import software.rsquared.restapi.RestObject;
import software.rsquared.restapi.serialization.Serializer;

public class ObjectToFormSerializer
implements Serializer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Config config;

    public ObjectToFormSerializer() {
        this(new Config());
    }

    public ObjectToFormSerializer(@NonNull Config config) {
        this.config = config;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        this.setupModule(module);
        this.objectMapper.registerModule((Module)module);
        if (!this.config.nullValues) {
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        if (config.disableAutoDetect) {
            this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        }
    }

    @CallSuper
    protected void setupModule(SimpleModule module) {
        module.addSerializer(File.class, (JsonSerializer)new JsonSerializer<File>(){

            public void serialize(File value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString("_file{" + value.getAbsolutePath() + "}");
            }
        });
        if (this.config.intBoolean) {
            module.addSerializer(Boolean.class, (JsonSerializer)new JsonSerializer<Boolean>(){

                public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (value != null) {
                        gen.writeNumber(value != false ? 1 : 0);
                    }
                }
            });
            module.addSerializer(Boolean.TYPE, (JsonSerializer)new JsonSerializer<Boolean>(){

                public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    gen.writeNumber(value != false ? 1 : 0);
                }
            });
            module.addSerializer(boolean[].class, (JsonSerializer)new JsonSerializer<boolean[]>(){

                public void serialize(boolean[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    int[] array = new int[value.length];
                    for (int i = 0; i < value.length; ++i) {
                        Boolean aBoolean = value[i];
                        array[i] = aBoolean != false ? 1 : 0;
                    }
                    gen.writeArray(array, 0, array.length);
                }
            });
        }
        if (this.config.timeInSeconds) {
            module.addSerializer(Calendar.class, (JsonSerializer)new JsonSerializer<Calendar>(){

                public void serialize(Calendar value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (value != null) {
                        gen.writeNumber(value.getTimeInMillis() / 1000L);
                    }
                }
            });
            module.addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

                public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (value != null) {
                        gen.writeNumber(value.getTime() / 1000L);
                    }
                }
            });
        }
    }

    @Override
    public <T> void serialize(@NonNull List<Parameter> parameters, T object) {
        if (object != null) {
            String name = null;
            if (this.isRestObject(object.getClass())) {
                name = this.getObjectName(object);
            }
            this.serialize(parameters, name, object);
        }
    }

    @Override
    public <T> void serialize(@NonNull List<Parameter> parameters, @Nullable String name, T object) {
        if (object != null) {
            JsonNode jsonNode = this.objectMapper.valueToTree(object);
            this.addParameter(name, jsonNode, parameters);
        }
    }

    private void addParameter(String name, JsonNode jsonNode, List<Parameter> parameters) {
        if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode child = jsonNode.get(i);
                if (child.isNull()) continue;
                String key = name == null ? "[" + i + "]" : name + "[" + i + "]";
                this.addParameter(key, child, parameters);
            }
        } else if (jsonNode.isObject()) {
            Iterator fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String key = name == null ? (String)entry.getKey() : name + "[" + (String)entry.getKey() + "]";
                this.addParameter(key, (JsonNode)entry.getValue(), parameters);
            }
        } else {
            parameters.add(new Parameter(name, jsonNode.asText()));
        }
    }

    private <T> String getObjectName(T object) {
        RestObject restObject = object.getClass().getAnnotation(RestObject.class);
        if (!TextUtils.isEmpty((CharSequence)restObject.value())) {
            return restObject.value();
        }
        return object.getClass().getSimpleName();
    }

    private boolean isRestObject(Class<?> aClass) {
        return aClass.getAnnotation(RestObject.class) != null;
    }

    public static class Config {
        private boolean timeInSeconds;
        private boolean intBoolean;
        private boolean nullValues;
        private boolean disableAutoDetect;

        public Config setTimeInSeconds(boolean timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
            return this;
        }

        public Config setIntBoolean(boolean intBoolean) {
            this.intBoolean = intBoolean;
            return this;
        }

        public Config setSerializeNullValues(boolean nonNullValues) {
            this.nullValues = nonNullValues;
            return this;
        }

        public Config setDisableAutoDetect(boolean disable) {
            this.disableAutoDetect = disable;
            return this;
        }
    }
}

