/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.serialization;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.rsquared.restapi.exceptions.DeserializationException;
import software.rsquared.restapi.serialization.Deserializer;

public class JsonDeserializer
implements Deserializer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Config config;

    public JsonDeserializer() {
        this(new Config());
    }

    public JsonDeserializer(@NonNull Config config) {
        this.config = config;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        this.setupModule(module);
        this.objectMapper.registerModule((Module)module);
    }

    @CallSuper
    protected void setupModule(SimpleModule module) {
        if (this.config.timeInSeconds) {
            module.addDeserializer(Calendar.class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Calendar>(){

                public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    if (TextUtils.isEmpty((CharSequence)p.getText())) {
                        return null;
                    }
                    long value = p.getLongValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(value * 1000L);
                    return calendar;
                }
            });
            module.addDeserializer(Date.class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Date>(){

                public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    if (TextUtils.isEmpty((CharSequence)p.getText())) {
                        return null;
                    }
                    long value = p.getLongValue();
                    return new Date(value * 1000L);
                }
            });
        }
        module.addDeserializer(Boolean.class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                if (TextUtils.isEmpty((CharSequence)p.getText())) {
                    return null;
                }
                String valueText = p.getText();
                try {
                    return Integer.parseInt(valueText) > 0;
                }
                catch (NumberFormatException e) {
                    return Boolean.parseBoolean(valueText);
                }
            }
        });
        module.addDeserializer(Boolean.TYPE, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                if (TextUtils.isEmpty((CharSequence)p.getText())) {
                    throw new IOException("Cannot deserialize null primitive value");
                }
                String valueText = p.getText();
                try {
                    return Integer.parseInt(valueText) > 0;
                }
                catch (NumberFormatException ignored) {
                    return Boolean.parseBoolean(valueText);
                }
            }
        });
        module.addDeserializer(boolean[].class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<boolean[]>(){

            public boolean[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                String[] value = (String[])p.readValueAs(String[].class);
                if (value == null) {
                    return null;
                }
                boolean[] array = new boolean[value.length];
                for (int i = 0; i < value.length; ++i) {
                    String valueText = value[i];
                    try {
                        array[i] = Integer.parseInt(valueText) > 0;
                        continue;
                    }
                    catch (NumberFormatException ignored) {
                        array[i] = Boolean.parseBoolean(valueText);
                    }
                }
                return array;
            }
        });
    }

    @Override
    public <T> T read(Class<?> requestClass, String content) throws IOException {
        Type superclass = requestClass.getGenericSuperclass();
        while (!(superclass instanceof ParameterizedType) && requestClass.getSuperclass() != null) {
            requestClass = requestClass.getSuperclass();
            superclass = requestClass.getGenericSuperclass();
        }
        if (superclass != null && superclass instanceof ParameterizedType) {
            return this.readObject(JsonDeserializer.getParameterClasses((ParameterizedType)superclass), content);
        }
        throw new DeserializationException("Unknown parameter response class for " + requestClass.getSimpleName());
    }

    private <T> T readObject(List<Class<?>> classes, String content) throws IOException {
        int classesCount = classes.size();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.getEmptyJson(classes.get(0));
        }
        if (classesCount > 1) {
            JavaType javaType = null;
            for (int i = classesCount - 1; i >= 1; --i) {
                javaType = javaType == null ? this.objectMapper.getTypeFactory().constructParametricType(classes.get(i - 1), new Class[]{classes.get(i)}) : this.objectMapper.getTypeFactory().constructParametricType(classes.get(i - 1), new JavaType[]{javaType});
            }
            return (T)this.objectMapper.readerFor(javaType).readValue(content);
        }
        return (T)this.objectMapper.readerFor(classes.get(0)).readValue(content);
    }

    private String getEmptyJson(@NonNull Class<?> clazz) {
        if (this.isArray(clazz)) {
            return "[]";
        }
        return "{}";
    }

    private boolean isArray(@NonNull Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    public static List<Class<?>> getParameterClasses(@NonNull ParameterizedType type) {
        ArrayList classes = new ArrayList();
        Type subType = type.getActualTypeArguments()[0];
        if (subType instanceof Class) {
            classes.add((Class)subType);
        } else if (subType instanceof ParameterizedType) {
            classes.add((Class)((ParameterizedType)subType).getRawType());
            classes.addAll(JsonDeserializer.getParameterClasses((ParameterizedType)subType));
        }
        return classes;
    }

    public static class Config {
        private boolean timeInSeconds;

        public Config setTimeInSeconds(boolean timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
            return this;
        }
    }
}

