/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RequestExecutor;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;

abstract class PoolRequest<P extends PoolRequest> {
    protected Map<Integer, Request> requestPool = new LinkedHashMap<Integer, Request>();
    protected boolean ignoreErrorCallback;
    protected boolean executed;
    protected RequestExecutor executor;

    protected PoolRequest(int poolSize) {
        this.executor = new RequestExecutor(poolSize, 0L);
    }

    public P addTask(@NonNull Request request, int requestCode) {
        if (this.executed) {
            throw new IllegalStateException("New task cannot be added to the pool after executing.");
        }
        if (this.requestPool.containsKey(requestCode)) {
            throw new IllegalArgumentException("Task with this requestCode (" + requestCode + ") was already added.");
        }
        this.requestPool.put(requestCode, request);
        return (P)this;
    }

    public abstract void execute(RequestPoolListener var1);

    public void stopExecute() {
        this.executor.shutdownNow();
    }

    public P ignoreErrorCallback() {
        this.ignoreErrorCallback = true;
        return (P)this;
    }

    abstract class PoolRequestListener
    extends RequestListener {
        private int requestCode;

        public PoolRequestListener(int requestCode) {
            this.requestCode = requestCode;
        }

        public int getRequestCode() {
            return this.requestCode;
        }
    }
}

