/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.exceptions;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import software.rsquared.restapi.exceptions.AccessTokenException;

public class RequestException
extends ExecutionException {
    public static final int CODE_OK = 200;
    public static final int CODE_ACCEPTED = 202;
    public static final int CODE_BAD_REQUEST = 400;
    public static final int CODE_UNAUTHORIZED = 401;
    public static final int CODE_FORBIDDEN = 403;
    public static final int CODE_NOT_FOUND = 404;
    public static final int CODE_METHOD_NOT_ALLOWED = 405;
    public static final int CODE_TIMEOUT = 408;
    public static final int CODE_TOO_MANY_REQUESTS = 429;
    public static final int CODE_INTERNAL_SERVER_ERROR = 500;
    public static final int CODE_SERVICE_UNAVAILABLE = 503;
    public static final int UNKNOWN = -1;
    public static final int INTERRUPTED = -2;
    public static final int TIMEOUT = -3;
    public static final int INVALID_ACCESS_TOKEN = -3;
    private final int mResponseCode;
    private final String mName;
    private final String mMessage;
    private final int mErrorCode;
    private final Map<String, String[]> mErrorsMap;

    public RequestException(@NonNull Exception e) {
        super(e);
        this.mName = "Internal error";
        this.mMessage = e.getMessage();
        this.mResponseCode = e instanceof InterruptedException ? -2 : (e instanceof TimeoutException ? -3 : (e instanceof AccessTokenException ? -3 : -1));
        this.mErrorCode = -1;
        this.mErrorsMap = new HashMap<String, String[]>();
    }

    public RequestException(int responseCode, String name, String message, int errorCode, Map<String, String[]> errorsMap) {
        this.mResponseCode = responseCode;
        this.mName = name;
        this.mMessage = message;
        this.mErrorCode = errorCode;
        this.mErrorsMap = errorsMap;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public Map<String, String[]> getErrorsMap() {
        return this.mErrorsMap;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" ").append(this.mErrorCode).append("[").append(this.mResponseCode).append("] ");
        if (!TextUtils.isEmpty((CharSequence)this.mName)) {
            builder.append(this.mName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMessage)) {
            builder.append("\n");
            builder.append(this.mMessage);
        }
        for (Map.Entry<String, String[]> entry : this.mErrorsMap.entrySet()) {
            builder.append("\n");
            builder.append(entry.getKey()).append(": ").append(Arrays.toString(entry.getValue()));
        }
        return builder.toString() + "\n" + super.toString();
    }
}

