/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatLogger;
import software.rsquared.androidlogger.logcat.LogcatLoggerConfig;
import software.rsquared.restapi.BasicAuthorization;
import software.rsquared.restapi.InitialRequirements;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestAuthorizationService;
import software.rsquared.restapi.SerialPoolRequest;
import software.rsquared.restapi.ThreadPoolRequest;
import software.rsquared.restapi.exceptions.DefaultErrorResponse;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.JsonDeserializer;
import software.rsquared.restapi.serialization.JsonErrorDeserializer;
import software.rsquared.restapi.serialization.JsonSerializer;
import software.rsquared.restapi.serialization.Serializer;

public class RestApi {
    public static final int THREAD_POOL_EXECUTOR = 1;
    public static final int SERIAL_EXECUTOR = 2;
    private static Config sConfiguration;

    static Config getConfiguration() {
        return sConfiguration;
    }

    public static void setConfiguration(Config configuration) {
        sConfiguration = configuration;
    }

    static Logger getLogger() {
        return sConfiguration.mLogger;
    }

    static boolean isConfigured() {
        return sConfiguration != null;
    }

    public static <E> void execute(Request<E> request, RequestListener<E> listener) {
        request.execute(listener);
    }

    public static <E> E executeSync(Request<E> request) throws RequestException {
        return request.execute().get();
    }

    public static PoolBuilder pool(int executor) {
        return new PoolBuilder(executor);
    }

    public static class Config {
        public static final String HTTP = "http";
        public static final String HTTPS = "https";
        private int mTimeout = 60000;
        private String mScheme = "http";
        private String mHost;
        private int mPort = -1;
        @Nullable
        private BasicAuthorization mBasicAuthorization;
        @Nullable
        private InitialRequirements mInitialRequirements;
        private Logger mLogger = new LogcatLogger();
        @NonNull
        private ErrorDeserializer mErrorDeserializer = new JsonErrorDeserializer();
        @NonNull
        private Deserializer mDeserializer = new JsonDeserializer();
        @NonNull
        private Serializer mSerializer = new JsonSerializer();
        private RestAuthorizationService mUserService;
        private Class<? extends DefaultErrorResponse> mErrorResponseClass;
        private RestAuthorizationService mRestAuthorizationService;
        private Map<String, String> mHeaders = new HashMap<String, String>();

        public int getTimeout() {
            return this.mTimeout;
        }

        public Config setTimeout(int timeout) {
            this.mTimeout = timeout;
            return this;
        }

        public String getScheme() {
            return this.mScheme;
        }

        public Config setScheme(@NonNull String scheme) {
            this.mScheme = scheme;
            return this;
        }

        public String getHost() {
            return this.mHost;
        }

        public Config setHost(@NonNull String host) {
            this.mHost = host;
            return this;
        }

        public int getPort() {
            return this.mPort;
        }

        public Config setPort(int port) {
            this.mPort = port;
            return this;
        }

        @Nullable
        public BasicAuthorization getBasicAuthorization() {
            return this.mBasicAuthorization;
        }

        public Config setAuthorization(@NonNull String user, @NonNull String password) {
            if (TextUtils.isEmpty((CharSequence)user) || TextUtils.isEmpty((CharSequence)password)) {
                this.mBasicAuthorization = null;
                return this;
            }
            this.mBasicAuthorization = new BasicAuthorization(user, password);
            return this;
        }

        @Nullable
        public InitialRequirements getInitialRequirements() {
            return this.mInitialRequirements;
        }

        public Config setInitialRequirements(@NonNull InitialRequirements initialRequirements) {
            this.mInitialRequirements = initialRequirements;
            return this;
        }

        @NonNull
        public Deserializer getDeserializer() {
            return this.mDeserializer;
        }

        public Config setDeserializer(@NonNull Deserializer deserializer) {
            this.mDeserializer = deserializer;
            return this;
        }

        @NonNull
        public Serializer getSerializer() {
            return this.mSerializer;
        }

        public Config setSerializer(@NonNull Serializer serializer) {
            this.mSerializer = serializer;
            return this;
        }

        @Nullable
        public RestAuthorizationService getRestAuthorizationService() {
            return this.mRestAuthorizationService;
        }

        public Config setRestAuthorizationService(RestAuthorizationService authorizationService) {
            this.mRestAuthorizationService = authorizationService;
            return this;
        }

        @NonNull
        public ErrorDeserializer getErrorDeserializer() {
            return this.mErrorDeserializer;
        }

        public Config setErrorDeserializer(@NonNull ErrorDeserializer errorDeserializer) {
            this.mErrorDeserializer = errorDeserializer;
            return this;
        }

        public Config setLogLevel(Level level) {
            ((LogcatLogger)this.mLogger).setConfig((LogcatLoggerConfig)new LogcatLoggerConfig().setLevel(level));
            return this;
        }

        public Config addHeader(String name, String value) {
            this.mHeaders.put(name, value);
            return this;
        }

        public Config removeHeader(String name) {
            this.mHeaders.remove(name);
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.mHeaders;
        }
    }

    public static class PoolBuilder {
        protected Map<Integer, Request> mRequestPool = new LinkedHashMap<Integer, Request>();
        private int mExecutor;

        public PoolBuilder(int executor) {
            this.mExecutor = executor;
        }

        public PoolRequest build() {
            PoolRequest poolRequest;
            switch (this.mExecutor) {
                case 1: {
                    poolRequest = new ThreadPoolRequest(this.mRequestPool.size());
                    break;
                }
                default: {
                    poolRequest = new SerialPoolRequest();
                }
            }
            for (Map.Entry<Integer, Request> entry : this.mRequestPool.entrySet()) {
                poolRequest.addTask(entry.getValue(), entry.getKey());
            }
            return poolRequest;
        }

        public void execute(RequestPoolListener listener) {
            PoolRequest poolRequest = this.build();
            poolRequest.execute(listener);
        }

        public PoolBuilder add(@NonNull Request request, int requestCode) {
            this.mRequestPool.put(requestCode, request);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Executor {
    }
}

