/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import com.github.anrwatchdog.ANRWatchDog;
import software.rsquared.androidlogger.AppenderLogger;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatAppender;

public class LoggableANRWatchDog
extends ANRWatchDog {
    private final AppenderLogger logger = new AppenderLogger(new LogcatAppender());
    private ANRWatchDog.ANRListener customListener;
    private boolean preventCrash = false;

    public LoggableANRWatchDog() {
    }

    public LoggableANRWatchDog(int timeoutInterval) {
        super(timeoutInterval);
    }

    public LoggableANRWatchDog setANRListener(ANRWatchDog.ANRListener listener) {
        this.customListener = listener;
        return this;
    }

    public LoggableANRWatchDog preventCrash(boolean preventCrash) {
        this.preventCrash = preventCrash;
        return this;
    }

    public LoggableANRWatchDog setInterruptionListener(ANRWatchDog.InterruptionListener listener) {
        super.setInterruptionListener(listener);
        return this;
    }

    public LoggableANRWatchDog setReportThreadNamePrefix(String prefix) {
        super.setReportThreadNamePrefix(prefix);
        return this;
    }

    public LoggableANRWatchDog setReportMainThreadOnly() {
        super.setReportMainThreadOnly();
        return this;
    }

    public synchronized void start() {
        this.logger.w((Object)"=======================================");
        this.logger.w((Object)"LoggableANRWatchDog is running. Please use this carefully because the watchdog will prevent the debugger with hanging execution at breakpoints or exceptions (it will detect the debugging pause as an ANR).");
        this.logger.w((Object)"=======================================");
        super.setANRListener(error -> {
            Logger.error((Throwable)error);
            if (this.customListener != null) {
                try {
                    this.customListener.onAppNotResponding(error);
                    return;
                }
                catch (Error e) {
                    if (this.preventCrash) return;
                    throw e;
                }
            } else {
                if (this.preventCrash) return;
                throw error;
            }
        });
        super.start();
    }
}

