/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.AppenderConfig;
import software.rsquared.androidlogger.ConfigurableAppender;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatAppender;

public class ConfigPropertiesReader {
    private static final String LOGGER_CONFIG_PREFIX = "logger";
    private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("logger.level", "logger.separator", "logger.throwableSeparator", "logger.appenderId", "logger.logThrowableWithStackTrace", "logger.timePattern", "logger.catchUncaughtExceptions", "logger.useANRWatchDog"));
    private final Logger logger = Logger.createWith(new LogcatAppender());
    private Map<String, Logger> loggerMap = new HashMap<String, Logger>();
    private Map<String, String> configMap = new HashMap<String, String>();

    private ConfigPropertiesReader(Context context, @RawRes int propertiesRes) {
        Properties properties = new Properties();
        this.loadProperties(context, properties, propertiesRes);
        String value = properties.getProperty(LOGGER_CONFIG_PREFIX);
        if (value != null) {
            this.readLoggers(properties, value);
        }
        this.readBaseConfig(properties);
    }

    public static ConfigPropertiesReader read(Context context, int propertiesRes) {
        return new ConfigPropertiesReader(context, propertiesRes);
    }

    public Map<String, Logger> getLoggerMap() {
        return this.loggerMap;
    }

    public Map<String, String> getBaseConfigMap() {
        return this.configMap;
    }

    private void readBaseConfig(Properties properties) {
        this.addConfigProperty(properties, "logger.level");
        this.addConfigProperty(properties, "logger.separator");
        this.addConfigProperty(properties, "logger.throwableSeparator");
        this.addConfigProperty(properties, "logger.appenderId");
        this.addConfigProperty(properties, "logger.logThrowableWithStackTrace");
        this.addConfigProperty(properties, "logger.timePattern");
        this.addConfigProperty(properties, "logger.catchUncaughtExceptions");
        this.addConfigProperty(properties, "logger.useANRWatchDog");
    }

    private void loadProperties(Context context, Properties properties, @RawRes int propertiesRes) {
        try (InputStreamReader reader = new InputStreamReader(context.getResources().openRawResource(propertiesRes), "UTF-8");){
            properties.load(reader);
        }
        catch (IOException e) {
            this.logger.w(e);
        }
    }

    private void readLoggers(Properties properties, String loggerProperty) {
        String[] appenders = loggerProperty.split(",");
        Map<String, Map<String, String>> appenderMap = this.createAppenderMap(appenders);
        this.readProperties(properties, appenderMap);
        this.createLoggers(appenderMap);
    }

    private void addConfigProperty(Properties properties, String property) {
        String value = properties.getProperty(property);
        if (value != null) {
            this.configMap.put(property.substring(LOGGER_CONFIG_PREFIX.length() + 1), value);
        }
    }

    @NonNull
    private Map<String, Map<String, String>> createAppenderMap(String[] appenders) {
        HashMap<String, Map<String, String>> appenderMap = new HashMap<String, Map<String, String>>();
        for (String appender : appenders) {
            appender = appender.trim();
            this.checkLoggerName(appender);
            appenderMap.put(appender, new HashMap());
        }
        return appenderMap;
    }

    private void readProperties(Properties properties, Map<String, Map<String, String>> loggersMap) {
        Enumeration<?> propertyKeys = properties.propertyNames();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            if (RESERVED_PROPERTIES.contains(key) || LOGGER_CONFIG_PREFIX.equals(key)) continue;
            String loggerName = key.substring(key.indexOf(".") + 1);
            String propertyName = "";
            String propertyValue = properties.getProperty(key);
            int propertyIdx = loggerName.indexOf(".");
            if (propertyIdx > 0) {
                propertyName = loggerName.substring(propertyIdx + 1);
                loggerName = loggerName.substring(0, propertyIdx);
            }
            if (!loggersMap.containsKey(loggerName)) continue;
            loggersMap.get(loggerName).put(propertyName, propertyValue);
        }
    }

    private void checkLoggerName(String appenderId) {
        if (TextUtils.isEmpty((CharSequence)appenderId)) {
            throw new IllegalArgumentException("You must specified appender name");
        }
        if (RESERVED_PROPERTIES.contains("logger." + appenderId)) {
            throw new IllegalArgumentException("Appender cannot be named as " + appenderId);
        }
    }

    private void createLoggers(Map<String, Map<String, String>> appenderMap) {
        for (Map.Entry<String, Map<String, String>> entry : appenderMap.entrySet()) {
            String clazz = entry.getValue().get("");
            entry.getValue().remove("");
            this.addLogger(clazz, entry.getKey(), entry.getValue());
        }
    }

    private void addLogger(String appenderClass, String appenderId, Map<String, String> configMap) {
        try {
            Class<?> clazz = Class.forName(appenderClass);
            Appender appender = (Appender)clazz.newInstance();
            appender.setAppenderId(appenderId);
            if (appender instanceof ConfigurableAppender) {
                ((AppenderConfig)((ConfigurableAppender)((Object)appender)).getConfig()).read(configMap);
            }
            this.loggerMap.put(appenderId, Logger.createWith(appender));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Appender class '" + appenderClass + "' not found");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(appenderClass + " must have public 0 args constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(appenderClass + " must have public 0 args constructor");
        }
    }
}

