/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.Config;
import software.rsquared.androidlogger.ConfigurableAppender;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.LoggerConfig;
import software.rsquared.androidlogger.LoggerUtils;
import software.rsquared.androidlogger.Tag;

public class AppenderLogger
extends Logger {
    private final Appender appender;

    AppenderLogger(Appender appender) {
        this.appender = appender;
    }

    @Override
    protected void append(Level level, Tag tag, Object message, Throwable throwable) {
        if (this.isLevelAllowed(level)) {
            this.appender.append(level, tag, message, throwable);
        }
    }

    private String getSeparator() {
        Object appenderConfig;
        String separator = null;
        if (this.appender instanceof ConfigurableAppender && (appenderConfig = ((ConfigurableAppender)((Object)this.appender)).getConfig()) != null) {
            separator = ((Config)appenderConfig).getSeparator();
        }
        if (separator == null) {
            separator = LoggerConfig.getInstance().getSeparator();
        }
        return separator;
    }

    private boolean isLevelAllowed(Level level) {
        LoggerConfig config = LoggerConfig.getInstance();
        Config appenderConfig = null;
        if (this.appender instanceof ConfigurableAppender) {
            appenderConfig = (Config)((ConfigurableAppender)((Object)this.appender)).getConfig();
        }
        if (config.getOverwrittenLevels().containsKey((Object)level)) {
            level = config.getOverwrittenLevels().get((Object)level);
        }
        return ((Config)config).isLevelAllowed(level) && (appenderConfig == null || appenderConfig.isLevelAllowed(level));
    }

    @Override
    public void i(Object message) {
        this.append(Level.INFO, null, message, null);
    }

    @Override
    public void i(Tag tag, Object message) {
        this.append(Level.INFO, tag, message, null);
    }

    @Override
    public void iF(String message, Object ... args) {
        this.append(Level.INFO, null, String.format(message, args), null);
    }

    @Override
    public void iF(Tag tag, String message, Object ... args) {
        this.append(Level.INFO, tag, String.format(message, args), null);
    }

    @Override
    public void i(Object ... message) {
        this.append(Level.INFO, null, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void i(Tag tag, Object ... message) {
        this.append(Level.INFO, tag, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void i(Throwable th) {
        this.append(Level.INFO, null, null, th);
    }

    @Override
    public void i(Tag tag, Throwable th) {
        this.append(Level.INFO, tag, null, th);
    }

    @Override
    public void i(Object message, Throwable th) {
        this.append(Level.INFO, null, message, th);
    }

    @Override
    public void i(Tag tag, Object message, Throwable th) {
        this.append(Level.INFO, tag, message, th);
    }

    @Override
    public void e(Object message) {
        this.append(Level.ERROR, null, message, null);
    }

    @Override
    public void e(Tag tag, Object message) {
        this.append(Level.ERROR, tag, message, null);
    }

    @Override
    public void eF(String message, Object ... args) {
        this.append(Level.ERROR, null, String.format(message, args), null);
    }

    @Override
    public void eF(Tag tag, String message, Object ... args) {
        this.append(Level.ERROR, tag, String.format(message, args), null);
    }

    @Override
    public void e(Object ... message) {
        this.append(Level.ERROR, null, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void e(Tag tag, Object ... message) {
        this.append(Level.ERROR, tag, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void e(Throwable th) {
        this.append(Level.ERROR, null, null, th);
    }

    @Override
    public void e(Tag tag, Throwable th) {
        this.append(Level.ERROR, tag, null, th);
    }

    @Override
    public void e(Object message, Throwable th) {
        this.append(Level.ERROR, null, message, th);
    }

    @Override
    public void e(Tag tag, Object message, Throwable th) {
        this.append(Level.ERROR, tag, message, th);
    }

    @Override
    public void d(Object message) {
        this.append(Level.DEBUG, null, message, null);
    }

    @Override
    public void d(Tag tag, Object message) {
        this.append(Level.DEBUG, tag, message, null);
    }

    @Override
    public void dF(String message, Object ... args) {
        this.append(Level.DEBUG, null, String.format(message, args), null);
    }

    @Override
    public void dF(Tag tag, String message, Object ... args) {
        this.append(Level.DEBUG, tag, String.format(message, args), null);
    }

    @Override
    public void d(Object ... message) {
        this.append(Level.DEBUG, null, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void d(Tag tag, Object ... message) {
        this.append(Level.DEBUG, tag, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void d(Throwable th) {
        this.append(Level.DEBUG, null, null, th);
    }

    @Override
    public void d(Tag tag, Throwable th) {
        this.append(Level.DEBUG, tag, null, th);
    }

    @Override
    public void d(Object message, Throwable th) {
        this.append(Level.DEBUG, null, message, th);
    }

    @Override
    public void d(Tag tag, Object message, Throwable th) {
        this.append(Level.DEBUG, tag, message, th);
    }

    @Override
    public void v(Object message) {
        this.append(Level.VERBOSE, null, message, null);
    }

    @Override
    public void v(Tag tag, Object message) {
        this.append(Level.VERBOSE, tag, message, null);
    }

    @Override
    public void vF(String message, Object ... args) {
        this.append(Level.VERBOSE, null, String.format(message, args), null);
    }

    @Override
    public void vF(Tag tag, String message, Object ... args) {
        this.append(Level.VERBOSE, tag, String.format(message, args), null);
    }

    @Override
    public void v(Object ... message) {
        this.append(Level.VERBOSE, null, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void v(Tag tag, Object ... message) {
        this.append(Level.VERBOSE, tag, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void v(Throwable th) {
        this.append(Level.VERBOSE, null, null, th);
    }

    @Override
    public void v(Tag tag, Throwable th) {
        this.append(Level.VERBOSE, tag, null, th);
    }

    @Override
    public void v(Object message, Throwable th) {
        this.append(Level.VERBOSE, null, message, th);
    }

    @Override
    public void v(Tag tag, Object message, Throwable th) {
        this.append(Level.VERBOSE, tag, message, th);
    }

    @Override
    public void w(Object message) {
        this.append(Level.WARNING, null, message, null);
    }

    @Override
    public void w(Tag tag, Object message) {
        this.append(Level.WARNING, tag, message, null);
    }

    @Override
    public void wF(String message, Object ... args) {
        this.append(Level.WARNING, null, String.format(message, args), null);
    }

    @Override
    public void wF(Tag tag, String message, Object ... args) {
        this.append(Level.WARNING, tag, String.format(message, args), null);
    }

    @Override
    public void w(Object ... message) {
        this.append(Level.WARNING, null, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void w(Tag tag, Object ... message) {
        this.append(Level.WARNING, tag, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void w(Throwable th) {
        this.append(Level.WARNING, null, null, th);
    }

    @Override
    public void w(Tag tag, Throwable th) {
        this.append(Level.WARNING, tag, null, th);
    }

    @Override
    public void w(Object message, Throwable th) {
        this.append(Level.WARNING, null, message, th);
    }

    @Override
    public void w(Tag tag, Object message, Throwable th) {
        this.append(Level.WARNING, tag, message, th);
    }

    @Override
    public void t() {
        this.d((Object)"At $FullClassName$.$MethodName$$CodeLine$");
    }

    @Override
    public void t(Tag tag) {
        this.d(tag, (Object)"At $FullClassName$.$MethodName$$CodeLine$");
    }

    public Appender getAppender() {
        return this.appender;
    }
}

