/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.file;

import java.io.File;
import java.io.IOException;
import software.rsquared.androidlogger.file.BaseFileAppender;
import software.rsquared.androidlogger.file.RollingFileAppenderConfig;

public class RollingFileAppender
extends BaseFileAppender {
    protected RollingFileAppenderConfig config;

    @Override
    public RollingFileAppenderConfig getConfig() {
        if (this.config == null) {
            this.config = new RollingFileAppenderConfig();
        }
        return this.config;
    }

    @Override
    protected synchronized void writeToFile(File file, String string) {
        super.writeToFile(file, string);
        if (file.length() > this.config.getMaxFileSize() && this.config.getMaxFileSize() > 0L && this.config.getMaxFileBackupCount() > 0) {
            this.rollOver(file);
        }
    }

    private boolean rollOver(File file) {
        int backupsCount = this.config.getMaxFileBackupCount();
        File f = new File(file.getAbsolutePath() + ".bac" + backupsCount);
        boolean success = true;
        if (f.exists()) {
            success = f.delete();
        }
        for (int i = backupsCount - 1; i > 0 && success; --i) {
            f = new File(file.getAbsolutePath() + ".bac" + i);
            if (!f.exists()) continue;
            success = f.renameTo(new File(file.getAbsolutePath() + ".bac" + (i + 1)));
        }
        if (success) {
            success = file.renameTo(new File(file.getAbsolutePath() + ".bac" + 1));
        }
        if (success) {
            try {
                success = file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                success = false;
            }
        }
        return success;
    }
}

