/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.content.Context;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.AppenderLogger;
import software.rsquared.androidlogger.Config;
import software.rsquared.androidlogger.ConfigPropertiesReader;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.LoggableANRWatchDog;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatAppender;

public class LoggerConfig
extends Config {
    private static LoggerConfig instance;
    private static final String DEFAULT_APPENDER = "__$default_logger$";
    private static final String DEFAULT_TIME_PATTERN = "%1$tH:%1$tM:%1$tS.%1$tL";
    private final Map<String, Logger> loggerMap = new HashMap<String, Logger>();
    @NonNull
    private String defaultTag = "$CodeLine$";
    @NonNull
    private String timePattern = "%1$tH:%1$tM:%1$tS.%1$tL";

    private LoggerConfig() {
        this.enableDefaultAppender(true);
    }

    public static LoggerConfig getInstance() {
        if (instance == null) {
            instance = new LoggerConfig();
        }
        return instance;
    }

    public void fromProperties(Context context, @RawRes int propertiesRes) {
        ConfigPropertiesReader reader = ConfigPropertiesReader.read(context, propertiesRes);
        this.loggerMap.clear();
        this.loggerMap.putAll(reader.getLoggerMap());
        this.read(reader.getBaseConfigMap());
    }

    public LoggerConfig addAppender(@NonNull Appender appender) {
        return this.addAppender(null, appender);
    }

    public LoggerConfig addAppender(String appenderId, @NonNull Appender appender) {
        if (TextUtils.isEmpty((CharSequence)appenderId)) {
            appenderId = appender.getClass().getSimpleName() + "_" + System.currentTimeMillis();
        }
        appender.setAppenderId(appenderId);
        this.loggerMap.put(appenderId, Logger.createWith(appender));
        return this;
    }

    public LoggerConfig removeAppender(@NonNull String appenderId) {
        if (!TextUtils.isEmpty((CharSequence)appenderId)) {
            this.loggerMap.remove(appenderId);
        }
        return this;
    }

    public LoggerConfig removeAppender(@NonNull Logger logger) {
        if (logger instanceof AppenderLogger && !TextUtils.isEmpty((CharSequence)((AppenderLogger)logger).getAppender().getAppenderId())) {
            this.loggerMap.remove(((AppenderLogger)logger).getAppender().getAppenderId());
        }
        return this;
    }

    public LoggerConfig removeAppender(@NonNull Appender appender) {
        return this.removeAppender(appender.getAppenderId());
    }

    public LoggerConfig removeAllAppenders() {
        this.loggerMap.clear();
        return this;
    }

    public LoggerConfig overwriteLevel(@NonNull Level oldLevel, @NonNull Level newLevel) {
        this.overwrittenLevels.put(oldLevel, newLevel);
        return this;
    }

    public LoggerConfig removeLevelOverwriting(@NonNull Level level) {
        this.overwrittenLevels.remove((Object)level);
        return this;
    }

    public LoggerConfig removeAllLevelOverwrites() {
        this.overwrittenLevels.clear();
        return this;
    }

    public LoggerConfig setLevel(@NonNull Level level) {
        this.level = level;
        return this;
    }

    public LoggerConfig setDefaultTag(@NonNull String defaultTag) {
        this.defaultTag = defaultTag;
        return this;
    }

    public LoggerConfig setLogThrowableWithStackTrace(boolean logThrowableWithStackTrace) {
        this.logThrowableWithStackTrace = logThrowableWithStackTrace;
        return this;
    }

    public LoggerConfig setSeparator(@NonNull String separator) {
        this.separator = separator;
        return this;
    }

    public LoggerConfig setThrowableSeparator(@NonNull String throwableSeparator) {
        this.throwableSeparator = throwableSeparator;
        return this;
    }

    public LoggerConfig setTimePattern(@NonNull String timePattern) {
        this.timePattern = timePattern;
        return this;
    }

    public LoggerConfig enableDefaultAppender(boolean enable) {
        if (enable) {
            if (!this.loggerMap.containsKey(DEFAULT_APPENDER)) {
                this.loggerMap.put(DEFAULT_APPENDER, new AppenderLogger(new LogcatAppender()));
            }
        } else {
            this.loggerMap.remove(DEFAULT_APPENDER);
        }
        return this;
    }

    @NonNull
    public LoggerConfig catchUncaughtExceptions() {
        return this.catchUncaughtExceptions(true, null);
    }

    @NonNull
    public LoggerConfig catchUncaughtExceptions(boolean catchUncaughtExceptions) {
        return this.catchUncaughtExceptions(catchUncaughtExceptions, null);
    }

    @NonNull
    public LoggerConfig catchUncaughtExceptions(boolean catchUncaughtExceptions, @Nullable LoggerUncaughtExceptionHandler handler) {
        if (catchUncaughtExceptions) {
            Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
                Logger.error(ex);
                if (handler == null || !handler.uncaughtException(thread, ex)) {
                    Process.killProcess((int)Process.myPid());
                    System.exit(10);
                }
            });
        } else {
            Thread.setDefaultUncaughtExceptionHandler(null);
        }
        return this;
    }

    @NonNull
    public LoggerConfig runANRWatchDog(@NonNull LoggableANRWatchDog watchDog) {
        watchDog.start();
        return this;
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("timePattern")) {
            this.setTimePattern(config.get("timePattern"));
        }
        if (config.containsKey("catchUncaughtExceptions")) {
            this.catchUncaughtExceptions(Boolean.parseBoolean(config.get("catchUncaughtExceptions")));
        }
        if (config.containsKey("runANRWatchDog") && Boolean.parseBoolean(config.get("runANRWatchDog"))) {
            this.runANRWatchDog(new LoggableANRWatchDog());
        }
        if (config.containsKey("defaultTag")) {
            this.setDefaultTag(config.get("defaultTag"));
        }
    }

    Map<String, Logger> getLoggerMap() {
        return this.loggerMap;
    }

    @NonNull
    String getDefaultTag() {
        return this.defaultTag;
    }

    @NonNull
    String getTimePattern() {
        return this.timePattern;
    }

    public static interface LoggerUncaughtExceptionHandler {
        public boolean uncaughtException(Thread var1, Throwable var2);
    }
}

