/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.support.annotation.Nullable;
import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.AppenderLogger;
import software.rsquared.androidlogger.BaseLogger;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.LoggerConfig;
import software.rsquared.androidlogger.LoggerUtils;
import software.rsquared.androidlogger.Tag;

public abstract class Logger
extends BaseLogger {
    public static final String SPACE = " ";
    public static final String NEW_LINE = "\n";
    public static final String CLASS_NAME = "$ClassName$";
    public static final String FULL_CLASS_NAME = "$FullClassName$";
    public static final String METHOD_NAME = "$MethodName$";
    public static final String FILE_NAME = "$FileName$";
    public static final String LINE_NUMBER = "$LineNumber$";
    public static final String LEVEL = "$Level$";
    public static final String SHORT_LEVEL = "$ShortLevel$";
    public static final String CURRENT_TIME = "$CurrentTime$";
    public static final String CODE_LINE = "$CodeLine$";

    Logger() {
    }

    public static LoggerConfig getLoggerConfig() {
        return LoggerConfig.getInstance();
    }

    public static Logger getLogger(String appenderId) {
        return Logger.getLoggerConfig().getLoggerMap().get(appenderId);
    }

    public static Logger createWith(Appender appender) {
        return new AppenderLogger(appender);
    }

    public static void info(Object message) {
        Logger.appendToAll(Level.INFO, message, null);
    }

    public static void info(Tag tag, Object message) {
        Logger.appendToAll(Level.INFO, tag, message, null);
    }

    public static void infoF(String message, Object ... args) {
        Logger.appendToAll(Level.INFO, String.format(message, args), null);
    }

    public static void infoF(Tag tag, String message, Object ... args) {
        Logger.appendToAll(Level.INFO, tag, String.format(message, args), null);
    }

    public static void info(Object ... message) {
        Logger.appendToAll(Level.INFO, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void info(Tag tag, Object ... message) {
        Logger.appendToAll(Level.INFO, tag, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void info(Throwable th) {
        Logger.appendToAll(Level.INFO, null, th);
    }

    public static void info(Tag tag, Throwable th) {
        Logger.appendToAll(Level.INFO, tag, null, th);
    }

    public static void info(Object message, Throwable th) {
        Logger.appendToAll(Level.INFO, message, th);
    }

    public static void info(Tag tag, Object message, Throwable th) {
        Logger.appendToAll(Level.INFO, tag, message, th);
    }

    public static void error(Object message) {
        Logger.appendToAll(Level.ERROR, message, null);
    }

    public static void error(Tag tag, Object message) {
        Logger.appendToAll(Level.ERROR, tag, message, null);
    }

    public static void errorF(String message, Object ... args) {
        Logger.appendToAll(Level.ERROR, String.format(message, args), null);
    }

    public static void errorF(Tag tag, String message, Object ... args) {
        Logger.appendToAll(Level.ERROR, tag, String.format(message, args), null);
    }

    public static void error(Object ... message) {
        Logger.appendToAll(Level.ERROR, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void error(Tag tag, Object ... message) {
        Logger.appendToAll(Level.ERROR, tag, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void error(Throwable th) {
        Logger.appendToAll(Level.ERROR, null, th);
    }

    public static void error(Tag tag, Throwable th) {
        Logger.appendToAll(Level.ERROR, tag, null, th);
    }

    public static void error(Object message, Throwable th) {
        Logger.appendToAll(Level.ERROR, message, th);
    }

    public static void error(Tag tag, Object message, Throwable th) {
        Logger.appendToAll(Level.ERROR, tag, message, th);
    }

    public static void debug(Object message) {
        Logger.appendToAll(Level.DEBUG, message, null);
    }

    public static void debug(Tag tag, Object message) {
        Logger.appendToAll(Level.DEBUG, tag, message, null);
    }

    public static void debugF(String message, Object ... args) {
        Logger.appendToAll(Level.DEBUG, String.format(message, args), null);
    }

    public static void debugF(Tag tag, String message, Object ... args) {
        Logger.appendToAll(Level.DEBUG, tag, String.format(message, args), null);
    }

    public static void debug(Object ... message) {
        Logger.appendToAll(Level.DEBUG, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void debug(Tag tag, Object ... message) {
        Logger.appendToAll(Level.DEBUG, tag, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void debug(Throwable th) {
        Logger.appendToAll(Level.DEBUG, null, th);
    }

    public static void debug(Tag tag, Throwable th) {
        Logger.appendToAll(Level.DEBUG, tag, null, th);
    }

    public static void debug(Object message, Throwable th) {
        Logger.appendToAll(Level.DEBUG, message, th);
    }

    public static void debug(Tag tag, Object message, Throwable th) {
        Logger.appendToAll(Level.DEBUG, tag, message, th);
    }

    public static void verbose(Object message) {
        Logger.appendToAll(Level.VERBOSE, message, null);
    }

    public static void verbose(Tag tag, Object message) {
        Logger.appendToAll(Level.VERBOSE, tag, message, null);
    }

    public static void verboseF(String message, Object ... args) {
        Logger.appendToAll(Level.VERBOSE, String.format(message, args), null);
    }

    public static void verboseF(Tag tag, String message, Object ... args) {
        Logger.appendToAll(Level.VERBOSE, tag, String.format(message, args), null);
    }

    public static void verbose(Object ... message) {
        Logger.appendToAll(Level.VERBOSE, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void verbose(Tag tag, Object ... message) {
        Logger.appendToAll(Level.VERBOSE, tag, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void verbose(Throwable th) {
        Logger.appendToAll(Level.VERBOSE, null, th);
    }

    public static void verbose(Tag tag, Throwable th) {
        Logger.appendToAll(Level.VERBOSE, tag, null, th);
    }

    public static void verbose(Object message, Throwable th) {
        Logger.appendToAll(Level.VERBOSE, message, th);
    }

    public static void verbose(Tag tag, Object message, Throwable th) {
        Logger.appendToAll(Level.VERBOSE, tag, message, th);
    }

    public static void warning(Object message) {
        Logger.appendToAll(Level.WARNING, message, null);
    }

    public static void warning(Tag tag, Object message) {
        Logger.appendToAll(Level.WARNING, tag, message, null);
    }

    public static void warningF(String message, Object ... args) {
        Logger.appendToAll(Level.WARNING, String.format(message, args), null);
    }

    public static void warningF(Tag tag, String message, Object ... args) {
        Logger.appendToAll(Level.WARNING, tag, String.format(message, args), null);
    }

    public static void warning(Object ... message) {
        Logger.appendToAll(Level.WARNING, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void warning(Tag tag, Object ... message) {
        Logger.appendToAll(Level.WARNING, tag, LoggerUtils.array2String(Logger.getLoggerConfig().getSeparator(), message), null);
    }

    public static void warning(Throwable th) {
        Logger.appendToAll(Level.WARNING, null, th);
    }

    public static void warning(Tag tag, Throwable th) {
        Logger.appendToAll(Level.WARNING, tag, null, th);
    }

    public static void warning(Object message, Throwable th) {
        Logger.appendToAll(Level.WARNING, message, th);
    }

    public static void warning(Tag tag, Object message, Throwable th) {
        Logger.appendToAll(Level.WARNING, tag, message, th);
    }

    public static void trace() {
        Logger.debug((Object)"at $FullClassName$.$MethodName$$CodeLine$");
    }

    public static void trace(Tag tag) {
        Logger.debug(tag, (Object)"at $FullClassName$.$MethodName$$CodeLine$");
    }

    private static void appendToAll(Level level, @Nullable Object message, @Nullable Throwable throwable) {
        Logger.appendToAll(level, null, message, throwable);
    }

    private static void appendToAll(Level level, Tag tag, @Nullable Object message, @Nullable Throwable throwable) {
        LoggerConfig loggerConfig = Logger.getLoggerConfig();
        if (loggerConfig.getOverwrittenLevels().containsKey((Object)level)) {
            level = loggerConfig.getOverwrittenLevels().get((Object)level);
        }
        if (loggerConfig.isLevelAllowed(level)) {
            for (Logger logger : loggerConfig.getLoggerMap().values()) {
                logger.append(level, tag, message, throwable);
            }
        }
    }
}

