/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Calendar;
import software.rsquared.androidlogger.AppenderConfig;
import software.rsquared.androidlogger.Config;
import software.rsquared.androidlogger.ConfigurableAppender;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.LoggerConfig;
import software.rsquared.androidlogger.LoggerUtils;
import software.rsquared.androidlogger.Tag;
import software.rsquared.androidlogger.WordUtils;

public abstract class Appender {
    private static final int CHUNK_SIZE = 3000;
    private String appenderId;

    protected String getSimpleClassName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.SIMPLE_CLASS_NAME);
    }

    protected String getFullClassName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.FULL_CLASS_NAME);
    }

    protected String getFileName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.FILE_NAME);
    }

    protected String getMethodName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.METHOD_NAME);
    }

    protected String getLineNumber() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.LINE_NUMBER);
    }

    protected String getLevelName(@NonNull Level level) {
        return level.name();
    }

    protected String getLevelShortName(@NonNull Level level) {
        return level.name().substring(0, 1);
    }

    protected String getTime() {
        return String.format(LoggerConfig.getInstance().getTimePattern(), Calendar.getInstance());
    }

    protected abstract void append(Level var1, String var2, String var3);

    protected void append(Level level, Tag tag, Object message, Throwable throwable) {
        String msg = this.getMessage(message, level);
        StringBuilder builder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            builder.append(msg);
        }
        if (throwable != null) {
            if (builder.length() > 0) {
                builder.append(this.getThrowableSeparator());
            }
            builder.append(LoggerUtils.throwableToString(throwable, this.logWithStackTrace()));
        }
        if (builder.length() == 0) {
            if (msg == null && throwable == null) {
                builder.append("null");
            } else {
                builder.append("[empty log message]");
            }
        }
        if (builder.length() > 0) {
            String text = builder.toString();
            String formattedTag = this.getTag(level, tag);
            if (text.length() > 3000) {
                for (String line : WordUtils.wrap(text, 3000)) {
                    this.append(level, formattedTag, line);
                }
            } else {
                this.append(level, formattedTag, text);
            }
        }
    }

    @Nullable
    protected String getTag(Level level, @Nullable Tag tag) {
        Object appenderConfig;
        String result;
        String string = result = tag == null ? null : tag.value;
        if (TextUtils.isEmpty((CharSequence)result) && this instanceof ConfigurableAppender && (appenderConfig = ((ConfigurableAppender)((Object)this)).getConfig()) != null) {
            result = ((AppenderConfig)appenderConfig).getTag();
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = LoggerConfig.getInstance().getDefaultTag();
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        return LoggerUtils.formatTag(result, level);
    }

    protected boolean logWithStackTrace() {
        LoggerConfig config = LoggerConfig.getInstance();
        Object appenderConfig = null;
        if (this instanceof ConfigurableAppender) {
            appenderConfig = ((ConfigurableAppender)((Object)this)).getConfig();
        }
        return appenderConfig == null || appenderConfig.logThrowableWithStackTrace || config.logThrowableWithStackTrace;
    }

    protected String getMessage(Object msg, Level level) {
        if (msg == null) {
            return null;
        }
        return LoggerUtils.formatMessage(msg, level);
    }

    protected String getThrowableSeparator() {
        Object appenderConfig;
        String separator = null;
        if (this instanceof ConfigurableAppender && (appenderConfig = ((ConfigurableAppender)((Object)this)).getConfig()) != null) {
            separator = ((Config)appenderConfig).getThrowableSeparator();
        }
        if (separator == null) {
            separator = LoggerConfig.getInstance().getThrowableSeparator();
        }
        return separator;
    }

    String getAppenderId() {
        return this.appenderId;
    }

    void setAppenderId(String appenderId) {
        this.appenderId = appenderId;
    }
}

