/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.file;

import android.os.Environment;
import android.support.annotation.NonNull;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.ConfigurableAppender;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.file.BaseFileAppenderConfig;
import software.rsquared.androidlogger.logcat.LogcatAppender;

public abstract class BaseFileAppender<E extends BaseFileAppenderConfig>
extends Appender
implements ConfigurableAppender<E> {
    protected static final Logger logger = Logger.createWith(new LogcatAppender());
    protected static final String DEFAULT_LOG_FILE = "logger.log";

    @Override
    protected void append(Level level, String tag, String message) {
        try {
            this.writeToFile(this.createFileIfNeeded(), tag + " " + message + "\n");
        }
        catch (IOException e) {
            logger.e(e);
        }
    }

    protected synchronized void writeToFile(File file, String string) {
        try (FileWriter writer = new FileWriter(file, true);){
            writer.write(string);
        }
        catch (IOException e) {
            logger.e((Object)"Cannot write log to file", e);
        }
    }

    public synchronized void clearLogFile() {
        try (RandomAccessFile file = new RandomAccessFile(this.getLogFile(), "rw");){
            file.setLength(0L);
        }
        catch (IOException e) {
            logger.e((Object)"Cannot clear Log file", e);
        }
    }

    @NonNull
    protected File createFileIfNeeded() throws IOException {
        File file = this.getLogFile();
        if (file.isDirectory()) {
            throw new IOException("The Log file cannot be directory");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Cannot with directory of the Log file");
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot with Log file");
        }
        if (!file.canWrite()) {
            throw new IOException("File is not writable");
        }
        return file;
    }

    @NonNull
    public File getLogFile() {
        BaseFileAppenderConfig config = (BaseFileAppenderConfig)this.getConfig();
        File file = null;
        if (config != null) {
            file = config.getLogFile();
        }
        if (file == null) {
            file = new File(Environment.getExternalStorageDirectory(), DEFAULT_LOG_FILE);
        }
        return file;
    }
}

