/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.textview;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.Map;
import software.rsquared.androidlogger.AppenderConfig;
import software.rsquared.androidlogger.Level;

public class TextViewAppenderConfig
extends AppenderConfig<TextViewAppenderConfig> {
    private static final String COLOR_REGEX = "^#((([0-7a-fA-F])?([0-7a-fA-F]){3})|(([0-7a-fA-F]{2})?([0-7a-fA-F]{2}){3}))$";
    private boolean inNewLine = true;
    private Method printMethod = Method.APPEND;
    private ColorScheme colorScheme = ColorScheme.LIGHT;

    TextViewAppenderConfig() {
    }

    public TextViewAppenderConfig setPrintMethod(Method method) {
        this.printMethod = method;
        return this;
    }

    public Method getPrintMethod() {
        return this.printMethod;
    }

    public TextViewAppenderConfig setInNewLine(boolean inNewLine) {
        this.inNewLine = inNewLine;
        return this;
    }

    @NonNull
    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public TextViewAppenderConfig setColorScheme(@NonNull ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        return this;
    }

    public boolean isInNewLine() {
        return this.inNewLine;
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("inNewLine")) {
            this.setInNewLine(Boolean.parseBoolean(config.get("inNewLine")));
        }
        if (config.containsKey("printMethod")) {
            try {
                this.setPrintMethod(Method.valueOf(config.get("printMethod")));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown print method: " + config.get("printMethod"));
            }
        }
        if (config.containsKey("colorScheme")) {
            String colorScheme = config.get("colorScheme");
            try {
                this.colorScheme = colorScheme.contains(",") ? this.parseColorScheme(colorScheme) : ("dark".equalsIgnoreCase(colorScheme) ? ColorScheme.DARK : ("light".equalsIgnoreCase(colorScheme) ? ColorScheme.LIGHT : ColorScheme.NONE));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown color scheme: " + colorScheme);
            }
        }
    }

    private ColorScheme parseColorScheme(String colorScheme) {
        String[] colors = colorScheme.split(",");
        if (colors.length == 5) {
            String colorVerbose = this.parseColor(colors[0], null);
            String colorDebug = this.parseColor(colors[1], null);
            String colorInfo = this.parseColor(colors[2], null);
            String colorWarning = this.parseColor(colors[3], null);
            String colorError = this.parseColor(colors[4], null);
            return new ColorScheme(colorVerbose, colorDebug, colorInfo, colorWarning, colorError);
        }
        return ColorScheme.NONE;
    }

    private String parseColor(String color, String defaultValue) {
        if ((color = color.trim()).matches(COLOR_REGEX)) {
            return color;
        }
        if (TextUtils.isEmpty((CharSequence)defaultValue)) {
            return "#000000";
        }
        return defaultValue;
    }

    public static class ColorScheme {
        public static final ColorScheme NONE = new ColorScheme("#000000", "#000000", "#000000", "#000000", "#000000");
        public static final ColorScheme LIGHT = new ColorScheme("#000000", "#00007F", "#007F00", "#7F7F00", "#7F0000");
        public static final ColorScheme DARK = new ColorScheme("#BBBBBB", "#6F84DD", "#68E168", "#E1E168", "#FF6868");
        private String colorVerbose;
        private String colorDebug;
        private String colorInfo;
        private String colorWarning;
        private String colorError;

        public ColorScheme(String colorVerbose, String colorDebug, String colorInfo, String colorWarning, String colorError) {
            this.colorVerbose = colorVerbose;
            this.colorDebug = colorDebug;
            this.colorInfo = colorInfo;
            this.colorWarning = colorWarning;
            this.colorError = colorError;
        }

        public String getColorString(Level level) {
            switch (level) {
                case VERBOSE: {
                    return this.colorVerbose;
                }
                case DEBUG: {
                    return this.colorDebug;
                }
                case INFO: {
                    return this.colorInfo;
                }
                case WARNING: {
                    return this.colorWarning;
                }
                case ERROR: {
                    return this.colorError;
                }
            }
            return "#000000";
        }

        @ColorInt
        public int getColor(Level level) {
            return Color.parseColor((String)this.getColorString(level));
        }
    }

    public static enum Method {
        APPEND,
        PREPEND,
        OVERWRITE;

    }
}

