/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.LoggerConfig;

abstract class LoggerUtils {
    LoggerUtils() {
    }

    @SafeVarargs
    static <T> String array2String(@NonNull String separator, T ... array) {
        if (array == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (T el : array) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(el);
        }
        return builder.toString();
    }

    @Nullable
    static String getStackTraceField(@NonNull StackTraceField field) {
        StackTraceElement element = LoggerUtils.getStackTraceElement();
        if (element == null) {
            return null;
        }
        return LoggerUtils.getField(element, field);
    }

    @NonNull
    static String formatTag(@NonNull String tag, @NonNull Level level) {
        return LoggerUtils.replaceFormatValues(tag, level);
    }

    @NonNull
    static String formatMessage(@NonNull Object msg, @NonNull Level level) {
        return LoggerUtils.replaceFormatValues(msg + "", level);
    }

    /*
     * Loose catch block
     */
    @NonNull
    static String throwableToString(@NonNull Throwable throwable, boolean withStackTrace) {
        block30: {
            String string;
            Throwable throwable2;
            PrintWriter printWriter;
            Throwable throwable3;
            StringWriter writer;
            block28: {
                block29: {
                    block26: {
                        block27: {
                            if (!withStackTrace) break block30;
                            writer = new StringWriter();
                            throwable3 = null;
                            printWriter = new PrintWriter(writer);
                            throwable2 = null;
                            throwable.printStackTrace(printWriter);
                            string = ((Object)writer).toString();
                            if (printWriter == null) break block26;
                            if (throwable2 == null) break block27;
                            try {
                                printWriter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            break block26;
                        }
                        printWriter.close();
                    }
                    if (writer == null) break block28;
                    if (throwable3 == null) break block29;
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    break block28;
                }
                ((Writer)writer).close();
            }
            return string;
            {
                catch (Throwable throwable6) {
                    try {
                        try {
                            try {
                                try {
                                    throwable2 = throwable6;
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    if (printWriter != null) {
                                        if (throwable2 != null) {
                                            try {
                                                printWriter.close();
                                            }
                                            catch (Throwable throwable8) {
                                                throwable2.addSuppressed(throwable8);
                                            }
                                        } else {
                                            printWriter.close();
                                        }
                                    }
                                    throw throwable7;
                                }
                            }
                            catch (Throwable throwable9) {
                                throwable3 = throwable9;
                                throw throwable9;
                            }
                        }
                        catch (Throwable throwable10) {
                            if (writer != null) {
                                if (throwable3 != null) {
                                    try {
                                        ((Writer)writer).close();
                                    }
                                    catch (Throwable throwable11) {
                                        throwable3.addSuppressed(throwable11);
                                    }
                                } else {
                                    ((Writer)writer).close();
                                }
                            }
                            throw throwable10;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return throwable.getMessage();
    }

    @NonNull
    private static String replaceFormatValues(@NonNull String text, @NonNull Level level) {
        String time;
        String levelName;
        Log.e((String)"test", (String)("replaceFormatValues() " + text + ", " + (Object)((Object)level)));
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        Map<String, String> map = LoggerUtils.getStackTraceFieldMap();
        if (map != null) {
            text = LoggerUtils.replaceCodeLine(text);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String target = entry.getKey();
                String replacement = entry.getValue();
                Log.e((String)"test", (String)(target + ": " + replacement));
                if (target == null || replacement == null) continue;
                text = text.replace(target, replacement);
            }
        }
        if ((levelName = level.name()) != null) {
            text = text.replace("$Level$", levelName);
            text = text.replace("$ShortLevel$", levelName.substring(0, 1));
        }
        if ((time = LoggerUtils.getTime()) != null) {
            text = text.replace("$CurrentTime$", time);
        }
        return text;
    }

    private static String getTime() {
        return String.format(LoggerConfig.getInstance().getTimePattern(), Calendar.getInstance());
    }

    public static String replaceCodeLine(@NonNull String text) {
        return text.replace("$CodeLine$", "($FileName$:$LineNumber$)");
    }

    @Nullable
    private static Map<String, String> getStackTraceFieldMap() {
        StackTraceElement element = LoggerUtils.getStackTraceElement();
        if (element == null) {
            return null;
        }
        HashMap<String, String> stackMap = new HashMap<String, String>();
        stackMap.put("$ClassName$", LoggerUtils.getField(element, StackTraceField.SIMPLE_CLASS_NAME));
        stackMap.put("$FullClassName$", LoggerUtils.getField(element, StackTraceField.FULL_CLASS_NAME));
        stackMap.put("$MethodName$", LoggerUtils.getField(element, StackTraceField.METHOD_NAME));
        stackMap.put("$FileName$", LoggerUtils.getField(element, StackTraceField.FILE_NAME));
        stackMap.put("$LineNumber$", LoggerUtils.getField(element, StackTraceField.LINE_NUMBER));
        return stackMap;
    }

    @Nullable
    private static StackTraceElement getStackTraceElement() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements == null || elements.length <= 2) {
            return null;
        }
        for (int i = 2; i < elements.length; ++i) {
            String className = elements[i].getClassName();
            if (LoggerUtils.isLoggerClass(className)) continue;
            return elements[i];
        }
        return elements[2];
    }

    @NonNull
    private static String getField(@NonNull StackTraceElement element, @NonNull StackTraceField field) {
        switch (field) {
            case FULL_CLASS_NAME: {
                return element.getClassName();
            }
            case SIMPLE_CLASS_NAME: {
                String className = element.getClassName();
                String[] parts = className.split("\\.");
                return parts.length > 0 ? parts[parts.length - 1] : "";
            }
            case FILE_NAME: {
                return element.getFileName();
            }
            case METHOD_NAME: {
                return element.getMethodName();
            }
            case LINE_NUMBER: {
                return element.getLineNumber() + "";
            }
        }
        return "";
    }

    private static boolean isLoggerClass(@NonNull String className) {
        return className.equalsIgnoreCase("software.rsquared.androidlogger.LoggerUtils") || LoggerUtils.classExtendLogger(className) || LoggerUtils.classExtendAppender(className);
    }

    private static boolean classExtendLogger(String className) {
        try {
            return Logger.class.isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean classExtendAppender(String className) {
        try {
            return Appender.class.isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static enum StackTraceField {
        SIMPLE_CLASS_NAME,
        FULL_CLASS_NAME,
        FILE_NAME,
        METHOD_NAME,
        LINE_NUMBER;

    }
}

