/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import software.rsquared.androidlogger.Level;

abstract class Config {
    final Map<Level, Level> overwrittenLevels = new HashMap<Level, Level>();
    @NonNull
    Level level = Level.VERBOSE;
    boolean logThrowableWithStackTrace = true;
    @NonNull
    String separator = " ";
    @NonNull
    String throwableSeparator = "\n";

    Config() {
    }

    public boolean isLevelAllowed(Level level) {
        return level.ordinal() >= this.level.ordinal();
    }

    @CallSuper
    protected void read(@NonNull Map<String, String> config) {
        if (config.containsKey("separator")) {
            this.separator = config.get("separator");
        }
        if (config.containsKey("throwableSeparator")) {
            this.throwableSeparator = config.get("throwableSeparator");
        }
        if (config.containsKey("level")) {
            try {
                this.level = Level.valueOf(config.get("level"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown level: " + config.get("level"));
            }
        }
        if (config.containsKey("logThrowableWithStackTrace")) {
            this.logThrowableWithStackTrace = Boolean.parseBoolean(config.get("logThrowableWithStackTrace"));
        }
    }

    protected Map<Level, Level> getOverwrittenLevels() {
        return this.overwrittenLevels;
    }

    @NonNull
    protected Level getLevel() {
        return this.level;
    }

    protected boolean isLogThrowableWithStackTrace() {
        return this.logThrowableWithStackTrace;
    }

    @NonNull
    protected String getSeparator() {
        return this.separator;
    }

    @NonNull
    protected String getThrowableSeparator() {
        return this.throwableSeparator;
    }
}

