/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.Config;
import software.rsquared.androidlogger.ConfigurableAppender;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.LoggerConfig;
import software.rsquared.androidlogger.LoggerUtils;

public class AppenderLogger
extends Logger {
    private final Appender appender;

    AppenderLogger(Appender appender) {
        this.appender = appender;
    }

    @Override
    protected void append(Level level, Object message, Throwable throwable) {
        if (this.isLevelAllowed(level)) {
            this.appender.append(level, message, throwable);
        }
    }

    private String getSeparator() {
        Object appenderConfig;
        String separator = null;
        if (this.appender instanceof ConfigurableAppender && (appenderConfig = ((ConfigurableAppender)((Object)this.appender)).getConfig()) != null) {
            separator = ((Config)appenderConfig).getSeparator();
        }
        if (separator == null) {
            separator = LoggerConfig.getInstance().getSeparator();
        }
        return separator;
    }

    private boolean isLevelAllowed(Level level) {
        LoggerConfig config = LoggerConfig.getInstance();
        Config appenderConfig = null;
        if (this.appender instanceof ConfigurableAppender) {
            appenderConfig = (Config)((ConfigurableAppender)((Object)this.appender)).getConfig();
        }
        if (config.getOverwrittenLevels().containsKey((Object)level)) {
            level = config.getOverwrittenLevels().get((Object)level);
        }
        return ((Config)config).isLevelAllowed(level) && (appenderConfig == null || appenderConfig.isLevelAllowed(level));
    }

    @Override
    public void i(Object message) {
        this.append(Level.INFO, message, null);
    }

    @Override
    public void iF(String message, Object ... args) {
        this.append(Level.INFO, String.format(message, args), null);
    }

    @Override
    public void i(Object ... message) {
        this.append(Level.INFO, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void i(Throwable th) {
        this.append(Level.INFO, null, th);
    }

    @Override
    public void i(Object message, Throwable th) {
        this.append(Level.INFO, message, th);
    }

    @Override
    public void e(Object message) {
        this.append(Level.ERROR, message, null);
    }

    @Override
    public void eF(String message, Object ... args) {
        this.append(Level.ERROR, String.format(message, args), null);
    }

    @Override
    public void e(Object ... message) {
        this.append(Level.ERROR, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void e(Throwable th) {
        this.append(Level.ERROR, null, th);
    }

    @Override
    public void e(Object message, Throwable th) {
        this.append(Level.ERROR, message, th);
    }

    @Override
    public void d(Object message) {
        this.append(Level.DEBUG, message, null);
    }

    @Override
    public void dF(String message, Object ... args) {
        this.append(Level.DEBUG, String.format(message, args), null);
    }

    @Override
    public void d(Object ... message) {
        this.append(Level.DEBUG, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void d(Throwable th) {
        this.append(Level.DEBUG, null, th);
    }

    @Override
    public void d(Object message, Throwable th) {
        this.append(Level.DEBUG, message, th);
    }

    @Override
    public void v(Object message) {
        this.append(Level.VERBOSE, message, null);
    }

    @Override
    public void vF(String message, Object ... args) {
        this.append(Level.VERBOSE, String.format(message, args), null);
    }

    @Override
    public void v(Object ... message) {
        this.append(Level.VERBOSE, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void v(Throwable th) {
        this.append(Level.VERBOSE, null, th);
    }

    @Override
    public void v(Object message, Throwable th) {
        this.append(Level.VERBOSE, message, th);
    }

    @Override
    public void w(Object message) {
        this.append(Level.WARNING, message, null);
    }

    @Override
    public void wF(String message, Object ... args) {
        this.append(Level.WARNING, String.format(message, args), null);
    }

    @Override
    public void w(Object ... message) {
        this.append(Level.WARNING, LoggerUtils.array2String(this.getSeparator(), message), null);
    }

    @Override
    public void w(Throwable th) {
        this.append(Level.WARNING, null, th);
    }

    @Override
    public void w(Object message, Throwable th) {
        this.append(Level.WARNING, message, th);
    }

    @Override
    public void t() {
        this.d((Object)"At $FullClassName$.$MethodName$$CodeLine$");
    }

    public Appender getAppender() {
        return this.appender;
    }
}

