/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import software.rsquared.androidlogger.BaseLogger;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;

abstract class LoggerUtils {
    private static Context applicationContext;

    LoggerUtils() {
    }

    @SafeVarargs
    static <T> String array2String(@NonNull String separator, T ... array) {
        StringBuilder builder = new StringBuilder();
        for (T el : array) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(el);
        }
        return builder.toString();
    }

    @Nullable
    static String getStackTraceField(@NonNull StackTraceField field) {
        StackTraceElement element = LoggerUtils.getStackTraceElement();
        if (element == null) {
            return null;
        }
        return LoggerUtils.getField(element, field);
    }

    @NonNull
    static String formatTag(@NonNull String tag, @NonNull Level level) {
        return LoggerUtils.replaceFormatValues(tag, level);
    }

    @NonNull
    static String formatMessage(@NonNull Object msg, @NonNull Level level) {
        return LoggerUtils.replaceFormatValues(msg + "", level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static String throwableToString(@NonNull Throwable throwable, boolean withStackTrace) {
        if (withStackTrace) {
            StringWriter writer = null;
            PrintWriter printWriter = null;
            try {
                writer = new StringWriter();
                printWriter = new PrintWriter(writer);
                throwable.printStackTrace(printWriter);
                String string = ((Object)writer).toString();
                return string;
            }
            finally {
                if (writer != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException iOException) {}
                }
                if (printWriter != null) {
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return throwable.getMessage();
    }

    static Context getApplicationContext() {
        if (applicationContext == null) {
            LoggerUtils.tryGetContext();
        }
        return applicationContext;
    }

    @NonNull
    private static String replaceFormatValues(@NonNull String text, @NonNull Level level) {
        String time;
        String levelName;
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        Map<String, String> map = LoggerUtils.getStackTraceFieldMap();
        if (map != null) {
            text = LoggerUtils.replaceCodeLine(text);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String target = entry.getKey();
                String replacement = entry.getValue();
                if (target == null || replacement == null) continue;
                text = text.replace(target, replacement);
            }
        }
        if ((levelName = level.name()) != null) {
            text = text.replace("$Level$", levelName);
            text = text.replace("$ShortLevel$", levelName.substring(0, 1));
        }
        if ((time = Logger.getTime()) != null) {
            text = text.replace("$CurrentTime$", time);
        }
        return text;
    }

    public static String replaceCodeLine(@NonNull String text) {
        return text.replace("$CodeLine$", "($FileName$:$LineNumber$)");
    }

    @Nullable
    private static Map<String, String> getStackTraceFieldMap() {
        StackTraceElement element = LoggerUtils.getStackTraceElement();
        if (element == null) {
            return null;
        }
        HashMap<String, String> stackMap = new HashMap<String, String>();
        stackMap.put("$ClassName$", LoggerUtils.getField(element, StackTraceField.SIMPLE_CLASS_NAME));
        stackMap.put("$FullClassName$", LoggerUtils.getField(element, StackTraceField.FULL_CLASS_NAME));
        stackMap.put("$MethodName$", LoggerUtils.getField(element, StackTraceField.METHOD_NAME));
        stackMap.put("$FileName$", LoggerUtils.getField(element, StackTraceField.FILE_NAME));
        stackMap.put("$LineNumber$", LoggerUtils.getField(element, StackTraceField.LINE_NUMBER));
        return stackMap;
    }

    @Nullable
    private static StackTraceElement getStackTraceElement() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements == null || elements.length <= 2) {
            return null;
        }
        for (int i = 2; i < elements.length; ++i) {
            String className = elements[i].getClassName();
            if (LoggerUtils.isLoggerClass(className)) continue;
            return elements[i];
        }
        return elements[2];
    }

    @NonNull
    private static String getField(@NonNull StackTraceElement element, @NonNull StackTraceField field) {
        switch (field) {
            case FULL_CLASS_NAME: {
                return element.getClassName();
            }
            case SIMPLE_CLASS_NAME: {
                return element.getClass().getSimpleName();
            }
            case FILE_NAME: {
                return element.getFileName();
            }
            case METHOD_NAME: {
                return element.getMethodName();
            }
            case LINE_NUMBER: {
                return element.getLineNumber() + "";
            }
        }
        return "";
    }

    private static boolean isLoggerClass(@NonNull String className) {
        return className.equalsIgnoreCase("software.rsquared.androidlogger.LoggerUtils") || LoggerUtils.classExtendLogger(className);
    }

    private static boolean classExtendLogger(String className) {
        try {
            return BaseLogger.class.isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void tryGetContext() {
        try {
            applicationContext = (Context)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot retrieve application context, please config logger programmatically");
        }
    }

    static enum StackTraceField {
        SIMPLE_CLASS_NAME,
        FULL_CLASS_NAME,
        FILE_NAME,
        METHOD_NAME,
        LINE_NUMBER;

    }
}

