/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import software.rsquared.androidlogger.BaseLoggerConfig;
import software.rsquared.androidlogger.Config;
import software.rsquared.androidlogger.ConfigReader;
import software.rsquared.androidlogger.LoggableANRWatchDog;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatLogger;

public class LoggerConfig
extends BaseLoggerConfig<LoggerConfig>
implements Config {
    public static final String DATE_PATTERN = "HH:mm:ss:SSS";
    private String separator = " ";
    private String throwableSeparator = "\n";
    private String datePattern = "HH:mm:ss:SSS";
    private SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern, Locale.getDefault());
    private final Map<String, Logger> loggers = new HashMap<String, Logger>();
    public static final String DEFAULT_LOGGER = "default_logger";

    public LoggerConfig() {
        this.loggers.put(DEFAULT_LOGGER, new LogcatLogger());
        this.tag = "$CodeLine$";
        this.logThrowableWithStackTrace = true;
    }

    public LoggerConfig(@RawRes int propertiesRes) {
        this.loggers.put(DEFAULT_LOGGER, new LogcatLogger());
        this.tag = "$CodeLine$";
        this.logThrowableWithStackTrace = true;
        ConfigReader reader = ConfigReader.read(propertiesRes);
        this.loggers.clear();
        this.loggers.putAll(reader.getLoggers());
        this.read(reader.getBaseConfigMap());
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("separator")) {
            this.setSeparator(config.get("separator"));
        }
        if (config.containsKey("throwableSeparator")) {
            this.setThrowableSeparator(config.get("throwableSeparator"));
        }
        if (config.containsKey("datePattern")) {
            this.setDatePattern(config.get("datePattern"));
        }
        if (config.containsKey("catchUncaughtExceptions")) {
            this.catchUncaughtExceptions(Boolean.parseBoolean(config.get("catchUncaughtExceptions")));
        }
        if (config.containsKey("useANRWatchDog") && Boolean.parseBoolean(config.get("useANRWatchDog"))) {
            this.useANRWatchDog(new LoggableANRWatchDog());
        }
    }

    @Override
    public LoggerConfig setTag(@NonNull String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new IllegalArgumentException("Tag for all loggers cannot be empty");
        }
        this.tag = tag;
        return this;
    }

    @Override
    @NonNull
    public String getTag() {
        if (TextUtils.isEmpty((CharSequence)this.tag)) {
            throw new IllegalArgumentException("Tag for all loggers cannot be empty");
        }
        return this.tag;
    }

    @Override
    public LoggerConfig setLogThrowableWithStackTrace(@NonNull Boolean logThrowableWithStackTrace) {
        this.logThrowableWithStackTrace = logThrowableWithStackTrace;
        return this;
    }

    @Override
    @NonNull
    public Boolean isLogThrowableWithStackTrace() {
        if (this.logThrowableWithStackTrace == null) {
            throw new IllegalArgumentException("logThrowableWithStackTrace for all loggers cannot be null");
        }
        return this.logThrowableWithStackTrace;
    }

    @Override
    public Logger getLogger(String tag) {
        return this.loggers.get(tag);
    }

    @Override
    @NonNull
    public Collection<Logger> getLoggers() {
        return this.loggers.values();
    }

    @Override
    @NonNull
    public LoggerConfig addLogger(@NonNull Logger logger) {
        String loggerTag = logger.getClass().getSimpleName() + "_" + System.currentTimeMillis();
        this.addLogger(logger, loggerTag);
        return this;
    }

    @Override
    @NonNull
    public LoggerConfig addLogger(@NonNull Logger logger, @NonNull String loggerTag) {
        logger.loggerTag = loggerTag;
        this.loggers.put(loggerTag, logger);
        return this;
    }

    @Override
    @NonNull
    public LoggerConfig removeLogger(@NonNull String tag) {
        this.loggers.remove(tag);
        return this;
    }

    @Override
    @NonNull
    public LoggerConfig removeLogger(@NonNull Logger logger) {
        this.loggers.remove(logger.loggerTag);
        return this;
    }

    @Override
    @NonNull
    public LoggerConfig removeAllLoggers() {
        this.loggers.clear();
        return this;
    }

    @NonNull
    public LoggerConfig useANRWatchDog(@NonNull LoggableANRWatchDog watchDog) {
        watchDog.start();
        return this;
    }

    @NonNull
    public LoggerConfig catchUncaughtExceptions() {
        return this.catchUncaughtExceptions(true);
    }

    @NonNull
    public LoggerConfig catchUncaughtExceptions(boolean catchExceptions) {
        if (catchExceptions) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    Logger.error(ex);
                    Process.killProcess((int)Process.myPid());
                    System.exit(10);
                }
            });
        } else {
            Thread.setDefaultUncaughtExceptionHandler(null);
        }
        return this;
    }

    @NonNull
    public LoggerConfig setSeparator(@NonNull String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    @NonNull
    public String getSeparator() {
        return this.separator;
    }

    @NonNull
    public LoggerConfig setThrowableSeparator(@NonNull String throwableSeparator) {
        this.throwableSeparator = throwableSeparator;
        return this;
    }

    @Override
    @NonNull
    public String getThrowableSeparator() {
        return this.throwableSeparator;
    }

    @Override
    @NonNull
    public String getDatePattern() {
        return this.datePattern;
    }

    public LoggerConfig setDatePattern(@NonNull String datePattern) {
        this.datePattern = datePattern;
        this.dateFormat = new SimpleDateFormat(datePattern, Locale.getDefault());
        return this;
    }

    @Override
    @NonNull
    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public LoggerConfig setDateFormat(@NonNull SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }
}

