/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Date;
import software.rsquared.androidlogger.Config;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.LoggerConfig;
import software.rsquared.androidlogger.LoggerUtils;

abstract class BaseLogger {
    public static final String SPACE = " ";
    public static final String NEW_LINE = "\n";
    public static final String CLASS_NAME = "$ClassName$";
    public static final String FULL_CLASS_NAME = "$FullClassName$";
    public static final String METHOD_NAME = "$MethodName$";
    public static final String FILE_NAME = "$FileName$";
    public static final String LINE_NUMBER = "$LineNumber$";
    public static final String LEVEL = "$Level$";
    public static final String SHORT_LEVEL = "$ShortLevel$";
    public static final String CURRENT_TIME = "$CurrentTime$";
    public static final String CODE_LINE = "$CodeLine$";
    @NonNull
    static LoggerConfig baseConfig = new LoggerConfig();

    BaseLogger() {
    }

    public static void setBaseConfig(@NonNull LoggerConfig config) {
        baseConfig = config;
    }

    @NonNull
    public static Config getBaseConfig() {
        return baseConfig;
    }

    protected static void printToAll(Level level, @Nullable Object message, @Nullable Throwable throwable) {
        if (BaseLogger.baseConfig.overwrittenLevels.containsKey((Object)level)) {
            level = (Level)((Object)BaseLogger.baseConfig.overwrittenLevels.get((Object)level));
        }
        if (baseConfig.isLevelAllowed(level)) {
            for (Logger logger : baseConfig.getLoggers()) {
                logger.print(level, message, throwable);
            }
        }
    }

    protected static String getSimpleClassName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.SIMPLE_CLASS_NAME);
    }

    protected static String getFullClassName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.FULL_CLASS_NAME);
    }

    protected static String getFileName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.FILE_NAME);
    }

    protected static String getMethodName() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.METHOD_NAME);
    }

    protected static String getLineNumber() {
        return LoggerUtils.getStackTraceField(LoggerUtils.StackTraceField.LINE_NUMBER);
    }

    protected static String getLevelName(@NonNull Level level) {
        return level.name();
    }

    protected static String getLevelShortName(@NonNull Level level) {
        return level.name().substring(0, 1);
    }

    protected static String getTime() {
        return baseConfig.getDateFormat().format(new Date());
    }

    public static void info(Object message) {
        BaseLogger.printToAll(Level.INFO, message, null);
    }

    public static void infoF(String message, Object ... args) {
        BaseLogger.printToAll(Level.INFO, String.format(message, args), null);
    }

    public static void info(Object ... message) {
        BaseLogger.printToAll(Level.INFO, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public static void info(Throwable th) {
        BaseLogger.printToAll(Level.INFO, null, th);
    }

    public static void info(Object message, Throwable th) {
        BaseLogger.printToAll(Level.INFO, message, th);
    }

    public static void error(Object message) {
        BaseLogger.printToAll(Level.ERROR, message, null);
    }

    public static void errorF(String message, Object ... args) {
        BaseLogger.printToAll(Level.ERROR, String.format(message, args), null);
    }

    public static void error(Object ... message) {
        BaseLogger.printToAll(Level.ERROR, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public static void error(Throwable th) {
        BaseLogger.printToAll(Level.ERROR, null, th);
    }

    public static void error(Object message, Throwable th) {
        BaseLogger.printToAll(Level.ERROR, message, th);
    }

    public static void debug(Object message) {
        BaseLogger.printToAll(Level.DEBUG, message, null);
    }

    public static void debugF(String message, Object ... args) {
        BaseLogger.printToAll(Level.DEBUG, String.format(message, args), null);
    }

    public static void debug(Object ... message) {
        BaseLogger.printToAll(Level.DEBUG, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public static void debug(Throwable th) {
        BaseLogger.printToAll(Level.DEBUG, null, th);
    }

    public static void debug(Object message, Throwable th) {
        BaseLogger.printToAll(Level.DEBUG, message, th);
    }

    public static void verbose(Object message) {
        BaseLogger.printToAll(Level.VERBOSE, message, null);
    }

    public static void verboseF(String message, Object ... args) {
        BaseLogger.printToAll(Level.VERBOSE, String.format(message, args), null);
    }

    public static void verbose(Object ... message) {
        BaseLogger.printToAll(Level.VERBOSE, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public static void verbose(Throwable th) {
        BaseLogger.printToAll(Level.VERBOSE, null, th);
    }

    public static void verbose(Object message, Throwable th) {
        BaseLogger.printToAll(Level.VERBOSE, message, th);
    }

    public static void warning(Object message) {
        BaseLogger.printToAll(Level.WARNING, message, null);
    }

    public static void warningF(String message, Object ... args) {
        BaseLogger.printToAll(Level.WARNING, String.format(message, args), null);
    }

    public static void warning(Object ... message) {
        BaseLogger.printToAll(Level.WARNING, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public static void warning(Throwable th) {
        BaseLogger.printToAll(Level.WARNING, null, th);
    }

    public static void warning(Object message, Throwable th) {
        BaseLogger.printToAll(Level.WARNING, message, th);
    }

    public static void trace() {
        BaseLogger.debug((Object)"at $FullClassName$.$MethodName$$CodeLine$");
    }
}

