/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.file;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.util.Map;
import software.rsquared.androidlogger.file.BaseFileLoggerConfig;

public class RollingFileLoggerConfig
extends BaseFileLoggerConfig<RollingFileLoggerConfig> {
    private static int B = 1;
    private static int KB = 1024 * B;
    private static int MB = 1024 * KB;
    private static int GB = 1024 * MB;
    private long maxFileSize = -1L;
    private int maxFileBackupCount = 0;

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    @VisibleForTesting
    public BaseFileLoggerConfig setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public int getMaxFileBackupCount() {
        return this.maxFileBackupCount;
    }

    public BaseFileLoggerConfig setMaxFileBackupCount(int maxFileBackupCount) {
        this.maxFileBackupCount = maxFileBackupCount;
        return this;
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("maxFileSize")) {
            this.setMaxFileSize(this.parseFileSize(config.get("maxFileSize")));
        }
        if (config.containsKey("maxFileBackupCount")) {
            this.setMaxFileBackupCount(Integer.parseInt(config.get("maxFileBackupCount")));
        }
    }

    private long parseFileSize(@NonNull String size) {
        if (size.matches("^\\d$")) {
            return Long.parseLong(size);
        }
        if (size.matches("^\\d+(b|B)$")) {
            size = size.substring(0, size.length() - 1);
            return Long.parseLong(size) * (long)B;
        }
        if (size.matches("^\\d+((k|K)(b|B))$")) {
            size = size.substring(0, size.length() - 2);
            return Long.parseLong(size) * (long)KB;
        }
        if (size.matches("^\\d+((m|M)(b|B))$")) {
            size = size.substring(0, size.length() - 2);
            return Long.parseLong(size) * (long)MB;
        }
        if (size.matches("^\\d+((g|G)(b|B))$")) {
            size = size.substring(0, size.length() - 2);
            return Long.parseLong(size) * (long)GB;
        }
        return Long.parseLong(size);
    }
}

