/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Map;
import software.rsquared.androidlogger.BaseLogger;
import software.rsquared.androidlogger.BaseLoggerConfig;
import software.rsquared.androidlogger.ConfigSetter;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.LoggerUtils;
import software.rsquared.androidlogger.WordUtils;

public abstract class Logger
extends BaseLogger {
    private static final int CHUNK_SIZE = 3000;
    private final boolean hasConfig = this instanceof ConfigSetter;
    protected String loggerTag;

    public String getLoggerTag() {
        return this.loggerTag;
    }

    protected abstract void print(Level var1, String var2);

    @Nullable
    protected abstract BaseLoggerConfig getConfig();

    protected void init(@NonNull Map<String, String> config) {
        if (this.getConfig() != null) {
            this.getConfig().read(config);
        }
    }

    @Nullable
    private BaseLoggerConfig getConfigIfDefined() {
        if (this.getConfig() != null) {
            return this.getConfig();
        }
        return null;
    }

    protected String getTag(Level level) {
        BaseLoggerConfig config = this.getConfigIfDefined();
        if (config == null || config.getTag() == null) {
            return LoggerUtils.formatTag(baseConfig.getTag(), level);
        }
        return LoggerUtils.formatTag(config.getTag(), level);
    }

    protected Context getApplicationContext() {
        return LoggerUtils.getApplicationContext();
    }

    protected String getMessage(Object msg, Level level) {
        if (msg == null) {
            return null;
        }
        return LoggerUtils.formatMessage(msg, level);
    }

    protected boolean isLevelAllowed(@NonNull Level level) {
        BaseLoggerConfig config = this.getConfigIfDefined();
        return config == null || config.isLevelAllowed(level);
    }

    void print(Level level, Object message, Throwable throwable) {
        if (Logger.baseConfig.overwrittenLevels.containsKey((Object)level)) {
            level = (Level)((Object)Logger.baseConfig.overwrittenLevels.get((Object)level));
        }
        if (baseConfig.isLevelAllowed(level) && this.isLevelAllowed(level)) {
            String msg = this.getMessage(message, level);
            StringBuilder builder = new StringBuilder();
            if (msg == null && throwable == null) {
                builder.append("null");
            } else if (TextUtils.isEmpty((CharSequence)msg) && throwable == null) {
                builder.append("[empty log message]");
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                builder.append(msg);
            }
            if (throwable != null) {
                if (builder.length() > 0) {
                    builder.append(baseConfig.getThrowableSeparator());
                }
                builder.append(LoggerUtils.throwableToString(throwable, this.logWithStackTrace()));
            }
            if (builder.length() > 0) {
                String text = builder.toString();
                if (text.length() > 3000) {
                    for (String line : WordUtils.wrap(text, 3000)) {
                        this.print(level, line);
                    }
                } else {
                    this.print(level, text);
                }
            }
        }
    }

    private boolean logWithStackTrace() {
        Boolean logThrowableWithStackTrace;
        BaseLoggerConfig config = this.getConfigIfDefined();
        Boolean bl = logThrowableWithStackTrace = config == null ? null : config.isLogThrowableWithStackTrace();
        if (config != null && logThrowableWithStackTrace != null) {
            return logThrowableWithStackTrace;
        }
        return baseConfig.isLogThrowableWithStackTrace();
    }

    public void i(Object message) {
        this.print(Level.INFO, message, null);
    }

    public void iF(String message, Object ... args) {
        this.print(Level.INFO, String.format(message, args), null);
    }

    public void i(Object ... message) {
        this.print(Level.INFO, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public void i(Throwable th) {
        this.print(Level.INFO, null, th);
    }

    public void i(Object message, Throwable th) {
        this.print(Level.INFO, message, th);
    }

    public void e(Object message) {
        this.print(Level.ERROR, message, null);
    }

    public void eF(String message, Object ... args) {
        this.print(Level.ERROR, String.format(message, args), null);
    }

    public void e(Object ... message) {
        this.print(Level.ERROR, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public void e(Throwable th) {
        this.print(Level.ERROR, null, th);
    }

    public void e(Object message, Throwable th) {
        this.print(Level.ERROR, message, th);
    }

    public void d(Object message) {
        this.print(Level.DEBUG, message, null);
    }

    public void dF(String message, Object ... args) {
        this.print(Level.DEBUG, String.format(message, args), null);
    }

    public void d(Object ... message) {
        this.print(Level.DEBUG, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public void d(Throwable th) {
        this.print(Level.DEBUG, null, th);
    }

    public void d(Object message, Throwable th) {
        this.print(Level.DEBUG, message, th);
    }

    public void v(Object message) {
        this.print(Level.VERBOSE, message, null);
    }

    public void vF(String message, Object ... args) {
        this.print(Level.VERBOSE, String.format(message, args), null);
    }

    public void v(Object ... message) {
        this.print(Level.VERBOSE, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public void v(Throwable th) {
        this.print(Level.VERBOSE, null, th);
    }

    public void v(Object message, Throwable th) {
        this.print(Level.VERBOSE, message, th);
    }

    public void w(Object message) {
        this.print(Level.WARNING, message, null);
    }

    public void wF(String message, Object ... args) {
        this.print(Level.WARNING, String.format(message, args), null);
    }

    public void w(Object ... message) {
        this.print(Level.WARNING, LoggerUtils.array2String(baseConfig.getSeparator(), message), null);
    }

    public void w(Throwable th) {
        this.print(Level.WARNING, null, th);
    }

    public void w(Object message, Throwable th) {
        this.print(Level.WARNING, message, th);
    }

    public void t() {
        this.d((Object)"At $FullClassName$.$MethodName$$CodeLine$");
    }
}

