/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import software.rsquared.androidlogger.Level;

public abstract class BaseLoggerConfig<E extends BaseLoggerConfig> {
    protected Level level = Level.VERBOSE;
    protected String tag;
    protected Boolean logThrowableWithStackTrace;
    protected Map<Level, Level> overwrittenLevels = new HashMap<Level, Level>();

    @NonNull
    public Level getLevel() {
        return this.level;
    }

    public E setLevel(@NonNull Level level) {
        this.level = level;
        return (E)this;
    }

    public boolean isLevelAllowed(@NonNull Level level) {
        return level.ordinal() >= this.level.ordinal();
    }

    public E setTag(@Nullable String tag) {
        this.tag = tag;
        return (E)this;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    public E setLogThrowableWithStackTrace(@Nullable Boolean logThrowableWithStackTrace) {
        this.logThrowableWithStackTrace = logThrowableWithStackTrace;
        return (E)this;
    }

    @Nullable
    public Boolean isLogThrowableWithStackTrace() {
        return this.logThrowableWithStackTrace;
    }

    public E overwriteLevel(Level srcLevel, Level dstLevel) {
        this.overwrittenLevels.put(srcLevel, dstLevel);
        return (E)this;
    }

    @CallSuper
    protected void read(@NonNull Map<String, String> config) {
        if (config.containsKey("level")) {
            try {
                this.setLevel(Level.valueOf(config.get("level")));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unknown level: " + config.get("level"));
            }
        }
        if (config.containsKey("tag")) {
            this.setTag(config.get("tag"));
        }
        if (config.containsKey("logThrowableWithStackTrace")) {
            this.setLogThrowableWithStackTrace(Boolean.parseBoolean(config.get("logThrowableWithStackTrace")));
        }
    }
}

