/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import java.util.ArrayList;
import java.util.Map;
import org.partiql.lang.ast.DataManipulation;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PartiQLStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.StatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.translator.DeleteStatementTranslator;

public class DeleteStatementProcessor
extends StatementProcessor<DataManipulation> {
    private final DeleteStatementTranslator translator;

    public DeleteStatementProcessor(DeleteStatementTranslator translator, LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, PartiQLStatementFunction partiQLStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, partiQLStatementFunction, documentFactory);
        this.translator = translator;
    }

    @Override
    public ExecuteStatementResponse execute(ParsedPartiQLRequest<DataManipulation> request) {
        TranslatedPartiQLOperation translatedPartiQLOperation = this.translator.translate(request);
        return this.invokePartiqlDeleteItem(translatedPartiQLOperation);
    }

    public ExecuteStatementResponse invokePartiqlDeleteItem(TranslatedPartiQLOperation translatedPartiQLOperation) {
        DeleteItemResponse deleteItemResult = this.partiqlDeleteItem(translatedPartiQLOperation.getTableName(), translatedPartiQLOperation.getReturnValue(), translatedPartiQLOperation.getItem(), translatedPartiQLOperation.getConditionExpressionWrapper(), translatedPartiQLOperation.getReturnValuesOnConditionCheckFailure());
        ArrayList<Map> returnItems = new ArrayList<Map>();
        if (deleteItemResult.attributes() != null && deleteItemResult.hasAttributes()) {
            returnItems.add(deleteItemResult.attributes());
        }
        return (ExecuteStatementResponse)ExecuteStatementResponse.builder().items(returnItems).build();
    }

    private DeleteItemResponse partiqlDeleteItem(final String tableName, final ReturnValue returnVals, final Map<String, AttributeValue> primaryKey, ExpressionWrapper conditionExpressionWrapper, final ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.partiQLStatementFunction.validateTableName(tableName);
        TableInfo tableInfo = this.partiQLStatementFunction.validateTableExists(tableName);
        this.partiQLStatementFunction.validateReturnType(returnVals.name(), false);
        if (primaryKey == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        this.partiQLStatementFunction.validateGetKey((Map)primaryKey, tableInfo);
        if (conditionExpressionWrapper == null) {
            final DeleteItemResponse.Builder response = DeleteItemResponse.builder();
            new LocalDBAccess.ReadLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    Map<String, AttributeValue> oldItem = DeleteStatementProcessor.this.dbAccess.getRecord(tableName, primaryKey);
                    if (oldItem != null && (returnVals == ReturnValue.ALL_OLD || returnVals == ReturnValue.UPDATED_OLD)) {
                        response.attributes(DeleteStatementProcessor.this.partiQLStatementFunction.localDBOutputConverter.internalToExternalAttributes(oldItem));
                    }
                    DeleteStatementProcessor.this.dbAccess.deleteRecord(tableName, primaryKey, false);
                }
            }.execute();
            return (DeleteItemResponse)response.build();
        }
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(this.dbAccess.getTableInfo(tableName), conditionExpressionWrapper, this.partiQLStatementFunction.awsExceptionFactory);
        final Expression conditionExpression = conditionExpressionWrapper.getExpression();
        final DeleteItemResponse.Builder deleteResult = DeleteItemResponse.builder();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = DeleteStatementProcessor.this.dbAccess.getRecord(tableName, primaryKey);
                if (oldItem != null && !DeleteStatementProcessor.this.partiQLStatementFunction.doesItemMatchConditionExpression((Map)oldItem, conditionExpression)) {
                    DeleteStatementProcessor.ifConditionalFailureReturnItem(oldItem, returnValuesOnConditionCheckFailure);
                    DeleteStatementProcessor.this.partiQLStatementFunction.awsExceptionFactory.CONDITIONAL_CHECK_FAILED.throwAsException();
                }
                DeleteStatementProcessor.this.dbAccess.deleteRecord(tableName, primaryKey, false);
                if (oldItem != null && returnVals == ReturnValue.ALL_OLD) {
                    deleteResult.attributes(DeleteStatementProcessor.this.partiQLStatementFunction.localDBOutputConverter.internalToExternalAttributes(oldItem));
                }
            }
        }.execute();
        return (DeleteItemResponse)deleteResult.build();
    }

    static void ifConditionalFailureReturnItem(Map<String, AttributeValue> oldItem, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        if (DeleteStatementProcessor.getReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).equals((Object)ReturnValuesOnConditionCheckFailure.ALL_OLD)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage(), oldItem);
        }
    }
}

