/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.dynamodb.services.local.google.Function;
import software.amazon.dynamodb.services.local.google.Preconditions;
import software.amazon.dynamodb.services.local.google.Sets;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class ConsumedCapacityUtils {
    protected static final Set<ReturnConsumedCapacity> COMPUTE_CONSUMED_CAPACITY_TYPES = Sets.newHashSet(ReturnConsumedCapacity.INDEXES, ReturnConsumedCapacity.TOTAL);
    private static final Capacity ZERO = (Capacity)Capacity.builder().capacityUnits(Double.valueOf(0.0)).build();

    public static boolean doNotRequireConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        return returnConsumedCapacity == null || ReturnConsumedCapacity.NONE == returnConsumedCapacity;
    }

    public static ConsumedCapacity computeConsumedCapacity(List<Map<String, AttributeValue>> items, boolean readFromGsi, boolean readFromLsi, String tableName, String indexName, boolean random, boolean stronglyConsistent, TransactionsEnabledMode transaction, ReturnConsumedCapacity returnConsumedCapacity) {
        if (ConsumedCapacityUtils.doNotRequireConsumedCapacity(returnConsumedCapacity)) {
            return null;
        }
        Preconditions.checkArgument(!readFromGsi || !readFromLsi);
        double cuDouble = random ? ConsumedCapacityUtils.computeCapacityRandom(items, stronglyConsistent) : ConsumedCapacityUtils.computeCapacityContiguous(items, stronglyConsistent);
        if (transaction == TransactionsEnabledMode.TRANSACTIONS_ENABLED) {
            cuDouble *= 2.0;
        }
        Capacity cu = (Capacity)Capacity.builder().capacityUnits(Double.valueOf(cuDouble)).build();
        ConsumedCapacity.Builder consumedCapacityBuilder = ConsumedCapacity.builder().tableName(tableName);
        if (readFromGsi || readFromLsi) {
            consumedCapacityBuilder.capacityUnits(Double.valueOf(cuDouble));
            if (ReturnConsumedCapacity.INDEXES == returnConsumedCapacity) {
                consumedCapacityBuilder.table(ZERO);
                if (readFromLsi) {
                    consumedCapacityBuilder.localSecondaryIndexes(Collections.singletonMap(indexName, cu));
                } else {
                    consumedCapacityBuilder.globalSecondaryIndexes(Collections.singletonMap(indexName, cu));
                }
            }
        } else {
            if (!ReturnConsumedCapacity.TOTAL.equals((Object)returnConsumedCapacity)) {
                consumedCapacityBuilder.table(cu);
            }
            consumedCapacityBuilder.capacityUnits(Double.valueOf(cuDouble));
        }
        return (ConsumedCapacity)consumedCapacityBuilder.build();
    }

    public static List<ConsumedCapacity> mergeAllConsumedCapacities(List<ConsumedCapacity> capacities, ReturnConsumedCapacity returnConsumedCapacity) {
        if (returnConsumedCapacity == null || returnConsumedCapacity == ReturnConsumedCapacity.NONE) {
            return null;
        }
        HashMap consumedCapacitiesByTable = new HashMap(capacities.size());
        for (ConsumedCapacity consumedCapacity : capacities) {
            String tableName = consumedCapacity.tableName();
            if (!consumedCapacitiesByTable.containsKey(tableName)) {
                consumedCapacitiesByTable.put(tableName, new LinkedHashSet());
            }
            ((Collection)consumedCapacitiesByTable.get(tableName)).add(consumedCapacity);
        }
        ArrayList<ConsumedCapacity> result = new ArrayList<ConsumedCapacity>(consumedCapacitiesByTable.size());
        for (Map.Entry entry : consumedCapacitiesByTable.entrySet()) {
            result.add(ConsumedCapacityUtils.mergeConsumedCapacities((String)entry.getKey(), (Collection)entry.getValue(), returnConsumedCapacity));
        }
        return result;
    }

    public static ConsumedCapacity mergeConsumedCapacities(String tableName, Collection<ConsumedCapacity> capacities, ReturnConsumedCapacity returnConsumedCapacity) {
        if (returnConsumedCapacity == null || returnConsumedCapacity == ReturnConsumedCapacity.NONE) {
            return null;
        }
        ConsumedCapacity.Builder aggregateBuilder = ConsumedCapacity.builder().capacityUnits(Double.valueOf(0.0)).tableName(tableName);
        double totalCapacityUnits = 0.0;
        Double totalReadCapacityUnits = null;
        Double totalWriteCapacityUnits = null;
        Capacity tableCapacity = null;
        HashMap<String, Capacity> localSecondaryIndexMap = new HashMap<String, Capacity>();
        HashMap<String, Capacity> globalSecondaryIndexMap = new HashMap<String, Capacity>();
        if (ReturnConsumedCapacity.INDEXES == returnConsumedCapacity) {
            tableCapacity = (Capacity)Capacity.builder().capacityUnits(Double.valueOf(0.0)).build();
        }
        for (ConsumedCapacity consumedCapacity : capacities) {
            totalCapacityUnits += consumedCapacity.capacityUnits().doubleValue();
            totalReadCapacityUnits = ConsumedCapacityUtils.safelyAdd(totalReadCapacityUnits, consumedCapacity.readCapacityUnits());
            totalWriteCapacityUnits = ConsumedCapacityUtils.safelyAdd(totalWriteCapacityUnits, consumedCapacity.writeCapacityUnits());
            if (ReturnConsumedCapacity.INDEXES != returnConsumedCapacity) continue;
            if (tableCapacity != null && consumedCapacity.table() != null) {
                tableCapacity = ConsumedCapacityUtils.addCapacities(tableCapacity, consumedCapacity.table());
            }
            ConsumedCapacityUtils.mergeIndexCapacityMapsLeft(localSecondaryIndexMap, consumedCapacity.localSecondaryIndexes());
            ConsumedCapacityUtils.mergeIndexCapacityMapsLeft(globalSecondaryIndexMap, consumedCapacity.globalSecondaryIndexes());
        }
        aggregateBuilder.capacityUnits(Double.valueOf(totalCapacityUnits));
        if (totalReadCapacityUnits != null) {
            aggregateBuilder.readCapacityUnits(totalReadCapacityUnits);
        }
        if (totalWriteCapacityUnits != null) {
            aggregateBuilder.writeCapacityUnits(totalWriteCapacityUnits);
        }
        if (ReturnConsumedCapacity.INDEXES == returnConsumedCapacity) {
            aggregateBuilder.table(tableCapacity);
            if (!localSecondaryIndexMap.isEmpty()) {
                aggregateBuilder.localSecondaryIndexes(localSecondaryIndexMap);
            }
            if (!globalSecondaryIndexMap.isEmpty()) {
                aggregateBuilder.globalSecondaryIndexes(globalSecondaryIndexMap);
            }
        }
        return (ConsumedCapacity)aggregateBuilder.build();
    }

    public static void applyToAllConsumedCapacities(List<ConsumedCapacity> consumedCapacity, Function<ConsumedCapacity, Void> func) {
        if (consumedCapacity == null) {
            return;
        }
        for (ConsumedCapacity cap : consumedCapacity) {
            func.apply(cap);
        }
    }

    public static ConsumedCapacity copyToReadConsumedCapacity(ConsumedCapacity consumedCapacity) {
        if (consumedCapacity == null) {
            return null;
        }
        ConsumedCapacity.Builder builder = ConsumedCapacity.builder().tableName(consumedCapacity.tableName()).capacityUnits(consumedCapacity.capacityUnits()).readCapacityUnits(consumedCapacity.capacityUnits());
        if (consumedCapacity.table() != null) {
            builder.table(ConsumedCapacityUtils.copyReadCapacity(consumedCapacity.table()));
        }
        if (consumedCapacity.hasGlobalSecondaryIndexes()) {
            HashMap newGSIs = new HashMap();
            consumedCapacity.globalSecondaryIndexes().forEach((key, capacity) -> newGSIs.put(key, ConsumedCapacityUtils.copyReadCapacity(capacity)));
            builder.globalSecondaryIndexes(newGSIs);
        }
        if (consumedCapacity.hasLocalSecondaryIndexes()) {
            HashMap newLSIs = new HashMap();
            consumedCapacity.localSecondaryIndexes().forEach((key, capacity) -> newLSIs.put(key, ConsumedCapacityUtils.copyReadCapacity(capacity)));
            builder.localSecondaryIndexes(newLSIs);
        }
        return (ConsumedCapacity)builder.build();
    }

    private static Capacity copyReadCapacity(Capacity capacity) {
        return (Capacity)Capacity.builder().capacityUnits(capacity.capacityUnits()).readCapacityUnits(capacity.capacityUnits()).writeCapacityUnits(capacity.writeCapacityUnits()).build();
    }

    public static void applyToAllCapacities(ConsumedCapacity consumedCapacity, Function<Capacity, Void> func) {
        if (consumedCapacity == null) {
            return;
        }
        if (consumedCapacity.table() != null) {
            func.apply(consumedCapacity.table());
        }
        if (consumedCapacity.globalSecondaryIndexes() != null && !consumedCapacity.globalSecondaryIndexes().isEmpty()) {
            for (Capacity cap : consumedCapacity.globalSecondaryIndexes().values()) {
                func.apply(cap);
            }
        }
        if (consumedCapacity.localSecondaryIndexes() != null && !consumedCapacity.localSecondaryIndexes().isEmpty()) {
            for (Capacity cap : consumedCapacity.localSecondaryIndexes().values()) {
                func.apply(cap);
            }
        }
    }

    public static ConsumedCapacity doubleAndCopyToWriteConsumedCapacity(ConsumedCapacity consumedCapacity) {
        if (consumedCapacity == null) {
            return null;
        }
        Double doubledCapacityUnits = consumedCapacity.capacityUnits() != null ? Double.valueOf(consumedCapacity.capacityUnits() * 2.0) : null;
        ConsumedCapacity.Builder builder = ConsumedCapacity.builder().tableName(consumedCapacity.tableName()).capacityUnits(doubledCapacityUnits).writeCapacityUnits(doubledCapacityUnits).readCapacityUnits(consumedCapacity.readCapacityUnits());
        if (consumedCapacity.table() != null) {
            builder.table(ConsumedCapacityUtils.doubleAndCopyWriteCapacity(consumedCapacity.table()));
        }
        if (consumedCapacity.hasGlobalSecondaryIndexes()) {
            HashMap newGSIs = new HashMap();
            consumedCapacity.globalSecondaryIndexes().forEach((key, capacity) -> newGSIs.put(key, ConsumedCapacityUtils.doubleAndCopyWriteCapacity(capacity)));
            builder.globalSecondaryIndexes(newGSIs);
        }
        if (consumedCapacity.hasLocalSecondaryIndexes()) {
            HashMap newLSIs = new HashMap();
            consumedCapacity.localSecondaryIndexes().forEach((key, capacity) -> newLSIs.put(key, ConsumedCapacityUtils.doubleAndCopyWriteCapacity(capacity)));
            builder.localSecondaryIndexes(newLSIs);
        }
        return (ConsumedCapacity)builder.build();
    }

    private static Capacity doubleAndCopyWriteCapacity(Capacity capacity) {
        Double doubledCapacity = capacity.capacityUnits() != null ? Double.valueOf(capacity.capacityUnits() * 2.0) : null;
        return (Capacity)Capacity.builder().capacityUnits(doubledCapacity).writeCapacityUnits(doubledCapacity).readCapacityUnits(capacity.readCapacityUnits()).build();
    }

    private static void mergeIndexCapacityMapsLeft(Map<String, Capacity> mergeInto, Map<String, Capacity> mergeFrom) {
        Preconditions.checkNotNull(mergeInto, "merge into map must not be null");
        if (mergeFrom == null) {
            return;
        }
        for (Map.Entry<String, Capacity> entry : mergeFrom.entrySet()) {
            String indexName = entry.getKey();
            Capacity indexCapacity = entry.getValue();
            if (mergeInto.containsKey(indexName)) {
                mergeInto.put(indexName, ConsumedCapacityUtils.addCapacities(mergeInto.get(indexName), indexCapacity));
                continue;
            }
            mergeInto.put(indexName, indexCapacity);
        }
    }

    private static Double safelyAdd(Double left, Double right) {
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        return left + right;
    }

    private static Capacity addCapacities(Capacity left, Capacity right) {
        return (Capacity)Capacity.builder().capacityUnits(Double.valueOf(left.capacityUnits() + right.capacityUnits())).readCapacityUnits(ConsumedCapacityUtils.safelyAdd(left.readCapacityUnits(), right.readCapacityUnits())).writeCapacityUnits(ConsumedCapacityUtils.safelyAdd(left.writeCapacityUnits(), right.writeCapacityUnits())).build();
    }

    private static double computeCapacityContiguous(List<Map<String, AttributeValue>> itemsRead, boolean stronglyConsistent) {
        double bytes = 0.0;
        for (Map<String, AttributeValue> item : itemsRead) {
            bytes += (double)LocalDBUtils.getItemSizeBytes(item);
        }
        return stronglyConsistent ? Math.ceil(bytes / 4096.0) : Math.ceil(bytes / 4096.0) / 2.0;
    }

    private static double computeCapacityRandom(List<Map<String, AttributeValue>> itemsRead, boolean stronglyConsistent) {
        double capacityUnits = 0.0;
        if (itemsRead != null) {
            for (Map<String, AttributeValue> item : itemsRead) {
                double bytes = LocalDBUtils.getItemSizeBytes(item);
                bytes = Math.max(bytes, 1.0);
                capacityUnits += stronglyConsistent ? Math.ceil(bytes / 4096.0) : Math.ceil(bytes / 4096.0) / 2.0;
            }
        }
        return capacityUnits;
    }
}

