/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.QueryResponseInfo;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PaginatingFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionType;
import software.amazon.dynamodb.services.local.shared.helpers.ConsumedCapacityUtils;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.Condition;
import software.amazon.dynamodb.services.local.shared.validate.RangeQueryExpressionsWrapper;

public class ScanFunction
extends PaginatingFunction<ScanRequest, ScanResponse> {
    public ScanFunction(LocalDBAccess dbAccess, DbEnv localDBEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory) {
        super(dbAccess, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory);
    }

    private static byte[] getSegmentBeginningHashKey(int totalSegments, int segment) {
        BigInteger delta2 = LocalDBUtils.MAX_HASH_KEY.divide(BigInteger.valueOf(totalSegments));
        delta2 = delta2.multiply(BigInteger.valueOf(segment));
        return ScanFunction.bigIntegerToSHA1Bytes(delta2);
    }

    private static byte[] getSegmentEndHashKey(int totalSegments, int segment) {
        if (segment + 1 == totalSegments) {
            return ScanFunction.bigIntegerToSHA1Bytes(LocalDBUtils.MAX_HASH_KEY);
        }
        BigInteger delta2 = LocalDBUtils.MAX_HASH_KEY.divide(BigInteger.valueOf(totalSegments));
        delta2 = delta2.multiply(BigInteger.valueOf(segment + 1));
        return ScanFunction.bigIntegerToSHA1Bytes(delta2.subtract(BigInteger.valueOf(1L)));
    }

    private static byte[] bigIntegerToSHA1Bytes(BigInteger number) {
        byte[] numberBytes = number.toByteArray();
        if (numberBytes.length == 20) {
            return numberBytes;
        }
        byte[] bytes = new byte[20];
        int i = bytes.length - 1;
        for (int j = i + numberBytes.length - bytes.length; i >= 0 && j >= 0; --i, --j) {
            bytes[i] = numberBytes[j];
        }
        while (i >= 0) {
            bytes[i] = 0;
            --i;
        }
        return bytes;
    }

    @Override
    public ScanResponse apply(ScanRequest scanRequest) {
        boolean isGsiIndex;
        String tableName = scanRequest.tableName();
        tableName = this.getTableNameFromPossibleArn(tableName);
        scanRequest = (ScanRequest)scanRequest.toBuilder().tableName(tableName).build();
        this.validateTableName(tableName);
        TableInfo info = this.validateTableExists(tableName);
        String indexName = scanRequest.indexName();
        if (indexName != null && !info.hasIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.SECONDARY_INDEXES_NOT_FOUND.getMessage(), indexName));
        }
        boolean bl = isGsiIndex = indexName != null && info.isGSIIndex(indexName);
        if (indexName != null && info.isGSIIndex(indexName) && scanRequest.consistentRead() != null && scanRequest.consistentRead().booleanValue()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CONSISTENT_GSI_SCAN.getMessage());
        }
        LocalDBValidatorUtils.validateExpressions(scanRequest, this.inputConverter);
        HashMap<String, Condition> scanFilter = this.inputConverter.externalToInternalConditions(scanRequest.scanFilter());
        scanFilter = scanFilter == null ? new HashMap<String, Condition>() : scanFilter;
        this.validateConditions(scanFilter, scanRequest.conditionalOperatorAsString());
        long limit2 = this.validateLimitValue(scanRequest.limit());
        RangeQueryExpressionsWrapper rangeQueryExpressionsWrapper = this.inputConverter.externalToInternalExpressions(scanRequest.filterExpression(), scanRequest.projectionExpression(), null, scanRequest.expressionAttributeNames(), scanRequest.expressionAttributeValues());
        ExpressionWrapper filterExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getFilterExpressionWrapper();
        Expression filterExpression = filterExpressionWrapper == null ? null : filterExpressionWrapper.getExpression();
        ProjectionExpressionWrapper projectionExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getProjectionExpressionWrapper();
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        Map exclusiveStartKey = null;
        if (scanRequest.exclusiveStartKey() != null && !scanRequest.exclusiveStartKey().isEmpty()) {
            exclusiveStartKey = (Map)this.inputConverter.externalToInternalAttributes(scanRequest.exclusiveStartKey());
        }
        List keyDefs = this.getKeyAttributes(info, indexName);
        this.validateExclusiveStartKey(exclusiveStartKey, keyDefs);
        this.validateExclusiveStartKeyForEmptyAttributeValue(exclusiveStartKey, info, indexName, isGsiIndex);
        Select select = this.validateSelect(scanRequest.selectAsString(), scanRequest.attributesToGet(), projectionExpression, indexName, info);
        String projectionExpressionString = scanRequest.projectionExpression();
        List<String> attributesToGet = this.determineAttributesToGetForScan(scanRequest, info, indexName, select);
        byte[] beginHash = null;
        byte[] endHash = null;
        if (scanRequest.segment() != null | scanRequest.totalSegments() != null) {
            this.validateParallelScanRequest(scanRequest.segment(), scanRequest.totalSegments());
            beginHash = ScanFunction.getSegmentBeginningHashKey(scanRequest.totalSegments(), scanRequest.segment());
            endHash = ScanFunction.getSegmentEndHashKey(scanRequest.totalSegments(), scanRequest.segment());
            this.validateParallelScanExclusiveStartKey(beginHash, endHash, exclusiveStartKey, info.getHashKey());
        }
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(info, filterExpressionWrapper, this.awsExceptionFactory);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(info, projectionExpressionWrapper, this.awsExceptionFactory);
        if (!(select == Select.COUNT || StringUtils.isEmpty((CharSequence)projectionExpressionString) && CollectionUtils.isNullOrEmpty((Collection)scanRequest.attributesToGet()))) {
            this.validateAttributesToGetAndProjExpr((List)attributesToGet, projectionExpression, indexName, info);
        }
        QueryResponseInfo results = this.dbAccess.queryRecords(tableName, indexName, null, exclusiveStartKey, limit2, true, beginHash, endHash, true, isGsiIndex);
        ScanResponse.Builder scanResponse = ScanResponse.builder();
        int scannedItemCount = 0;
        long totalSize = 0L;
        List<Map<String, AttributeValue>> dbRecords = results.getReturnedRecords();
        ConditionalOperator conditionalOperator = this.conditionalOperatorFrom(scanRequest.conditionalOperatorAsString());
        ArrayList<Map<String, AttributeValue>> dbRecordsAfterFiltering = new ArrayList<Map<String, AttributeValue>>();
        ArrayList<Map<String, AttributeValue>> chargeableDbRecords = new ArrayList<Map<String, AttributeValue>>();
        for (Map<String, AttributeValue> item : dbRecords) {
            if (this.doesItemMatchConditionalOperator(item, scanFilter, conditionalOperator) && this.doesItemMatchFilterExpression((Map)item, filterExpression)) {
                if (select != Select.COUNT) {
                    Map<String, AttributeValue> filteredItem = null;
                    filteredItem = projectionExpressionString == null && attributesToGet != null ? LocalDBUtils.projectAttributes(item, attributesToGet) : (projectionExpressionString != null ? LocalDBUtils.projectAttributes(item, projectionExpression) : item);
                    if (filteredItem != null) {
                        dbRecordsAfterFiltering.add(filteredItem);
                    }
                } else {
                    dbRecordsAfterFiltering.add(item);
                }
            }
            chargeableDbRecords.add(item);
            long itemSize = LocalDBUtils.getItemSizeBytes(item);
            if (totalSize + itemSize >= 0x100000L) {
                ++scannedItemCount;
                break;
            }
            totalSize += itemSize;
            ++scannedItemCount;
        }
        if (select != Select.COUNT) {
            scanResponse.items(this.localDBOutputConverter.internalToExternalItemList(dbRecordsAfterFiltering));
        }
        scanResponse.count(Integer.valueOf(dbRecordsAfterFiltering.size()));
        scanResponse.scannedCount(Integer.valueOf(scannedItemCount));
        Map<String, AttributeValue> lastItem = scannedItemCount > 0 && scannedItemCount < results.getReturnedRecords().size() ? results.getReturnedRecords().get(scannedItemCount - 1) : results.getLastEvaluatedItem();
        Map<String, AttributeValue> lastKey = LocalDBUtils.projectAttributes(lastItem, this.getAttributeNames(keyDefs));
        Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> lastKeyConverted = this.localDBOutputConverter.internalToExternalAttributes(lastKey);
        if (lastKeyConverted != null && !lastKeyConverted.isEmpty()) {
            scanResponse.lastEvaluatedKey(lastKeyConverted);
        }
        scanResponse.consumedCapacity(ConsumedCapacityUtils.computeConsumedCapacity(chargeableDbRecords, isGsiIndex, !isGsiIndex && indexName != null, tableName, indexName, false, scanRequest.consistentRead() != null && scanRequest.consistentRead() != false, this.transactionsMode, this.convertReturnConsumedCapacity(scanRequest.returnConsumedCapacityAsString())));
        return (ScanResponse)scanResponse.build();
    }

    private void validateParallelScanExclusiveStartKey(byte[] beginHash, byte[] endHash, Map<String, AttributeValue> exclusiveStartKey, AttributeDefinition hashKeyDef) {
        if (exclusiveStartKey == null) {
            return;
        }
        byte[] exclusiveStartHashVal = LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.attributeName()));
        if (LocalDBUtils.compareUnsignedByteArrays(exclusiveStartHashVal, beginHash) < 0 || LocalDBUtils.compareUnsignedByteArrays(exclusiveStartHashVal, endHash) > 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_KEY_FOR_SCAN.getMessage());
        }
    }

    private void validateParallelScanRequest(Integer segment, Integer totalSegments) {
        if (segment == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SEGMENT_NOT_SET.getMessage());
        }
        if (totalSegments == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOTAL_SEGMENTS_NOT_SET.getMessage());
        }
        if (segment < 0 || segment >= totalSegments) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + segment + "' at 'segment' failed to satisfy constraint: Member must have value less than or equal to " + (totalSegments - 1));
        }
        if (totalSegments <= 0 || totalSegments > 1000000) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + totalSegments + "' at 'totalSegments' failed to satisfy constraint: Member must have value less than or equal to 1000000");
        }
    }

    private List<String> determineAttributesToGetForScan(ScanRequest scanRequest, TableInfo tableInfo, String indexName, Select select) {
        switch (select) {
            case SPECIFIC_ATTRIBUTES: {
                return scanRequest.attributesToGet();
            }
            case ALL_PROJECTED_ATTRIBUTES: {
                Projection indexProjection = tableInfo.getProjection(indexName);
                return this.determineAttributesToGetWhenSelectingAllProjectedAttributes(tableInfo, indexName, indexProjection.projectionTypeAsString(), indexProjection.nonKeyAttributes());
            }
            case ALL_ATTRIBUTES: {
                return null;
            }
            case COUNT: {
                return null;
            }
        }
        LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        return null;
    }
}

