/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ApplicationSettingsResponse;
import software.amazon.awssdk.services.workspaces.model.CapacityStatus;
import software.amazon.awssdk.services.workspaces.model.TimeoutSettings;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolError;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolErrorsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspacesPool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspacesPool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(WorkspacesPool.getter(WorkspacesPool::poolId)).setter(WorkspacesPool.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(WorkspacesPool.getter(WorkspacesPool::poolArn)).setter(WorkspacesPool.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()}).build();
    private static final SdkField<CapacityStatus> CAPACITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityStatus").getter(WorkspacesPool.getter(WorkspacesPool::capacityStatus)).setter(WorkspacesPool.setter(Builder::capacityStatus)).constructor(CapacityStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityStatus").build()}).build();
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(WorkspacesPool.getter(WorkspacesPool::poolName)).setter(WorkspacesPool.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WorkspacesPool.getter(WorkspacesPool::description)).setter(WorkspacesPool.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(WorkspacesPool.getter(WorkspacesPool::stateAsString)).setter(WorkspacesPool.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(WorkspacesPool.getter(WorkspacesPool::createdAt)).setter(WorkspacesPool.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(WorkspacesPool.getter(WorkspacesPool::bundleId)).setter(WorkspacesPool.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(WorkspacesPool.getter(WorkspacesPool::directoryId)).setter(WorkspacesPool.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<WorkspacesPoolError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(WorkspacesPool.getter(WorkspacesPool::errors)).setter(WorkspacesPool.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspacesPoolError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationSettingsResponse> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSettings").getter(WorkspacesPool.getter(WorkspacesPool::applicationSettings)).setter(WorkspacesPool.setter(Builder::applicationSettings)).constructor(ApplicationSettingsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<TimeoutSettings> TIMEOUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeoutSettings").getter(WorkspacesPool.getter(WorkspacesPool::timeoutSettings)).setter(WorkspacesPool.setter(Builder::timeoutSettings)).constructor(TimeoutSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, POOL_ARN_FIELD, CAPACITY_STATUS_FIELD, POOL_NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD, CREATED_AT_FIELD, BUNDLE_ID_FIELD, DIRECTORY_ID_FIELD, ERRORS_FIELD, APPLICATION_SETTINGS_FIELD, TIMEOUT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String poolId;
    private final String poolArn;
    private final CapacityStatus capacityStatus;
    private final String poolName;
    private final String description;
    private final String state;
    private final Instant createdAt;
    private final String bundleId;
    private final String directoryId;
    private final List<WorkspacesPoolError> errors;
    private final ApplicationSettingsResponse applicationSettings;
    private final TimeoutSettings timeoutSettings;

    private WorkspacesPool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.poolArn = builder.poolArn;
        this.capacityStatus = builder.capacityStatus;
        this.poolName = builder.poolName;
        this.description = builder.description;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.bundleId = builder.bundleId;
        this.directoryId = builder.directoryId;
        this.errors = builder.errors;
        this.applicationSettings = builder.applicationSettings;
        this.timeoutSettings = builder.timeoutSettings;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public final CapacityStatus capacityStatus() {
        return this.capacityStatus;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final String description() {
        return this.description;
    }

    public final WorkspacesPoolState state() {
        return WorkspacesPoolState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<WorkspacesPoolError> errors() {
        return this.errors;
    }

    public final ApplicationSettingsResponse applicationSettings() {
        return this.applicationSettings;
    }

    public final TimeoutSettings timeoutSettings() {
        return this.timeoutSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesPool)) {
            return false;
        }
        WorkspacesPool other = (WorkspacesPool)obj;
        return Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.poolArn(), other.poolArn()) && Objects.equals(this.capacityStatus(), other.capacityStatus()) && Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.directoryId(), other.directoryId()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && Objects.equals(this.timeoutSettings(), other.timeoutSettings());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspacesPool").add("PoolId", (Object)this.poolId()).add("PoolArn", (Object)this.poolArn()).add("CapacityStatus", (Object)this.capacityStatus()).add("PoolName", (Object)this.poolName()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("CreatedAt", (Object)this.createdAt()).add("BundleId", (Object)this.bundleId()).add("DirectoryId", (Object)this.directoryId()).add("Errors", this.hasErrors() ? this.errors() : null).add("ApplicationSettings", (Object)this.applicationSettings()).add("TimeoutSettings", (Object)this.timeoutSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
            case "CapacityStatus": {
                return Optional.ofNullable(clazz.cast(this.capacityStatus()));
            }
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "TimeoutSettings": {
                return Optional.ofNullable(clazz.cast(this.timeoutSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspacesPool, T> g) {
        return obj -> g.apply((WorkspacesPool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolId;
        private String poolArn;
        private CapacityStatus capacityStatus;
        private String poolName;
        private String description;
        private String state;
        private Instant createdAt;
        private String bundleId;
        private String directoryId;
        private List<WorkspacesPoolError> errors = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettingsResponse applicationSettings;
        private TimeoutSettings timeoutSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacesPool model) {
            this.poolId(model.poolId);
            this.poolArn(model.poolArn);
            this.capacityStatus(model.capacityStatus);
            this.poolName(model.poolName);
            this.description(model.description);
            this.state(model.state);
            this.createdAt(model.createdAt);
            this.bundleId(model.bundleId);
            this.directoryId(model.directoryId);
            this.errors(model.errors);
            this.applicationSettings(model.applicationSettings);
            this.timeoutSettings(model.timeoutSettings);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final CapacityStatus.Builder getCapacityStatus() {
            return this.capacityStatus != null ? this.capacityStatus.toBuilder() : null;
        }

        public final void setCapacityStatus(CapacityStatus.BuilderImpl capacityStatus) {
            this.capacityStatus = capacityStatus != null ? capacityStatus.build() : null;
        }

        @Override
        public final Builder capacityStatus(CapacityStatus capacityStatus) {
            this.capacityStatus = capacityStatus;
            return this;
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspacesPoolState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<WorkspacesPoolError.Builder> getErrors() {
            List<WorkspacesPoolError.Builder> result = WorkspacesPoolErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<WorkspacesPoolError.BuilderImpl> errors) {
            this.errors = WorkspacesPoolErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<WorkspacesPoolError> errors) {
            this.errors = WorkspacesPoolErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(WorkspacesPoolError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<WorkspacesPoolError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (WorkspacesPoolError)((WorkspacesPoolError.Builder)WorkspacesPoolError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettingsResponse.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsResponse.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsResponse applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final TimeoutSettings.Builder getTimeoutSettings() {
            return this.timeoutSettings != null ? this.timeoutSettings.toBuilder() : null;
        }

        public final void setTimeoutSettings(TimeoutSettings.BuilderImpl timeoutSettings) {
            this.timeoutSettings = timeoutSettings != null ? timeoutSettings.build() : null;
        }

        @Override
        public final Builder timeoutSettings(TimeoutSettings timeoutSettings) {
            this.timeoutSettings = timeoutSettings;
            return this;
        }

        public WorkspacesPool build() {
            return new WorkspacesPool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspacesPool> {
        public Builder poolId(String var1);

        public Builder poolArn(String var1);

        public Builder capacityStatus(CapacityStatus var1);

        default public Builder capacityStatus(Consumer<CapacityStatus.Builder> capacityStatus) {
            return this.capacityStatus((CapacityStatus)((CapacityStatus.Builder)CapacityStatus.builder().applyMutation(capacityStatus)).build());
        }

        public Builder poolName(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(WorkspacesPoolState var1);

        public Builder createdAt(Instant var1);

        public Builder bundleId(String var1);

        public Builder directoryId(String var1);

        public Builder errors(Collection<WorkspacesPoolError> var1);

        public Builder errors(WorkspacesPoolError ... var1);

        public Builder errors(Consumer<WorkspacesPoolError.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettingsResponse var1);

        default public Builder applicationSettings(Consumer<ApplicationSettingsResponse.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettingsResponse)((ApplicationSettingsResponse.Builder)ApplicationSettingsResponse.builder().applyMutation(applicationSettings)).build());
        }

        public Builder timeoutSettings(TimeoutSettings var1);

        default public Builder timeoutSettings(Consumer<TimeoutSettings.Builder> timeoutSettings) {
            return this.timeoutSettings((TimeoutSettings)((TimeoutSettings.Builder)TimeoutSettings.builder().applyMutation(timeoutSettings)).build());
        }
    }
}

