/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsFilter;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsFiltersCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesPoolsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspacesPoolsRequest> {
    private static final SdkField<List<String>> POOL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PoolIds").getter(DescribeWorkspacesPoolsRequest.getter(DescribeWorkspacesPoolsRequest::poolIds)).setter(DescribeWorkspacesPoolsRequest.setter(Builder::poolIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DescribeWorkspacesPoolsFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeWorkspacesPoolsRequest.getter(DescribeWorkspacesPoolsRequest::filters)).setter(DescribeWorkspacesPoolsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeWorkspacesPoolsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeWorkspacesPoolsRequest.getter(DescribeWorkspacesPoolsRequest::limit)).setter(DescribeWorkspacesPoolsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesPoolsRequest.getter(DescribeWorkspacesPoolsRequest::nextToken)).setter(DescribeWorkspacesPoolsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_IDS_FIELD, FILTERS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> poolIds;
    private final List<DescribeWorkspacesPoolsFilter> filters;
    private final Integer limit;
    private final String nextToken;

    private DescribeWorkspacesPoolsRequest(BuilderImpl builder) {
        super(builder);
        this.poolIds = builder.poolIds;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPoolIds() {
        return this.poolIds != null && !(this.poolIds instanceof SdkAutoConstructList);
    }

    public final List<String> poolIds() {
        return this.poolIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<DescribeWorkspacesPoolsFilter> filters() {
        return this.filters;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoolIds() ? this.poolIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesPoolsRequest)) {
            return false;
        }
        DescribeWorkspacesPoolsRequest other = (DescribeWorkspacesPoolsRequest)((Object)obj);
        return this.hasPoolIds() == other.hasPoolIds() && Objects.equals(this.poolIds(), other.poolIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesPoolsRequest").add("PoolIds", this.hasPoolIds() ? this.poolIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolIds": {
                return Optional.ofNullable(clazz.cast(this.poolIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesPoolsRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesPoolsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> poolIds = DefaultSdkAutoConstructList.getInstance();
        private List<DescribeWorkspacesPoolsFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesPoolsRequest model) {
            super(model);
            this.poolIds(model.poolIds);
            this.filters(model.filters);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPoolIds() {
            if (this.poolIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.poolIds;
        }

        public final void setPoolIds(Collection<String> poolIds) {
            this.poolIds = WorkspacesPoolIdsCopier.copy(poolIds);
        }

        @Override
        public final Builder poolIds(Collection<String> poolIds) {
            this.poolIds = WorkspacesPoolIdsCopier.copy(poolIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolIds(String ... poolIds) {
            this.poolIds(Arrays.asList(poolIds));
            return this;
        }

        public final List<DescribeWorkspacesPoolsFilter.Builder> getFilters() {
            List<DescribeWorkspacesPoolsFilter.Builder> result = DescribeWorkspacesPoolsFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DescribeWorkspacesPoolsFilter.BuilderImpl> filters) {
            this.filters = DescribeWorkspacesPoolsFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DescribeWorkspacesPoolsFilter> filters) {
            this.filters = DescribeWorkspacesPoolsFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DescribeWorkspacesPoolsFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DescribeWorkspacesPoolsFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (DescribeWorkspacesPoolsFilter)((DescribeWorkspacesPoolsFilter.Builder)DescribeWorkspacesPoolsFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesPoolsRequest build() {
            return new DescribeWorkspacesPoolsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesPoolsRequest> {
        public Builder poolIds(Collection<String> var1);

        public Builder poolIds(String ... var1);

        public Builder filters(Collection<DescribeWorkspacesPoolsFilter> var1);

        public Builder filters(DescribeWorkspacesPoolsFilter ... var1);

        public Builder filters(Consumer<DescribeWorkspacesPoolsFilter.Builder> ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

